package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.BgNum;
import gov.va.caret.model.BgNumModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the BgNum service. Represents a row in the &quot;CARET_BOXED_GROUP_NUMERIC&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.BgNumModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BgNumImpl}.
 * </p>
 *
 * @author caret
 * @see BgNumImpl
 * @see gov.va.caret.model.BgNum
 * @see gov.va.caret.model.BgNumModel
 * @generated
 */
public class BgNumModelImpl extends BaseModelImpl<BgNum> implements BgNumModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a bg num model instance should use the {@link gov.va.caret.model.BgNum} interface instead.
     */
    public static final String TABLE_NAME = "CARET_BOXED_GROUP_NUMERIC";
    public static final Object[][] TABLE_COLUMNS = {
            { "bgNumId", Types.BIGINT },
            { "ownerId", Types.BIGINT },
            { "boxGpId", Types.BIGINT },
            { "value", Types.DOUBLE }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_BOXED_GROUP_NUMERIC (bgNumId LONG not null primary key,ownerId LONG,boxGpId LONG,value DOUBLE)";
    public static final String TABLE_SQL_DROP = "drop table CARET_BOXED_GROUP_NUMERIC";
    public static final String ORDER_BY_JPQL = " ORDER BY bgNum.bgNumId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_BOXED_GROUP_NUMERIC.bgNumId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.BgNum"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.BgNum"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.BgNum"),
            true);
    public static long BOXGPID_COLUMN_BITMASK = 1L;
    public static long OWNERID_COLUMN_BITMASK = 2L;
    public static long BGNUMID_COLUMN_BITMASK = 4L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.BgNum"));
    private static ClassLoader _classLoader = BgNum.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { BgNum.class };
    private long _bgNumId;
    private long _ownerId;
    private long _originalOwnerId;
    private boolean _setOriginalOwnerId;
    private long _boxGpId;
    private long _originalBoxGpId;
    private boolean _setOriginalBoxGpId;
    private double _value;
    private long _columnBitmask;
    private BgNum _escapedModel;

    public BgNumModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _bgNumId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setBgNumId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _bgNumId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return BgNum.class;
    }

    @Override
    public String getModelClassName() {
        return BgNum.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("bgNumId", getBgNumId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("boxGpId", getBoxGpId());
        attributes.put("value", getValue());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long bgNumId = (Long) attributes.get("bgNumId");

        if (bgNumId != null) {
            setBgNumId(bgNumId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        Long boxGpId = (Long) attributes.get("boxGpId");

        if (boxGpId != null) {
            setBoxGpId(boxGpId);
        }

        Double value = (Double) attributes.get("value");

        if (value != null) {
            setValue(value);
        }
    }

    @Override
    public long getBgNumId() {
        return _bgNumId;
    }

    @Override
    public void setBgNumId(long bgNumId) {
        _bgNumId = bgNumId;
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _columnBitmask |= OWNERID_COLUMN_BITMASK;

        if (!_setOriginalOwnerId) {
            _setOriginalOwnerId = true;

            _originalOwnerId = _ownerId;
        }

        _ownerId = ownerId;
    }

    public long getOriginalOwnerId() {
        return _originalOwnerId;
    }

    @Override
    public long getBoxGpId() {
        return _boxGpId;
    }

    @Override
    public void setBoxGpId(long boxGpId) {
        _columnBitmask |= BOXGPID_COLUMN_BITMASK;

        if (!_setOriginalBoxGpId) {
            _setOriginalBoxGpId = true;

            _originalBoxGpId = _boxGpId;
        }

        _boxGpId = boxGpId;
    }

    public long getOriginalBoxGpId() {
        return _originalBoxGpId;
    }

    @Override
    public double getValue() {
        return _value;
    }

    @Override
    public void setValue(double value) {
        _value = value;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            BgNum.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public BgNum toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (BgNum) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        BgNumImpl bgNumImpl = new BgNumImpl();

        bgNumImpl.setBgNumId(getBgNumId());
        bgNumImpl.setOwnerId(getOwnerId());
        bgNumImpl.setBoxGpId(getBoxGpId());
        bgNumImpl.setValue(getValue());

        bgNumImpl.resetOriginalValues();

        return bgNumImpl;
    }

    @Override
    public int compareTo(BgNum bgNum) {
        long primaryKey = bgNum.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof BgNum)) {
            return false;
        }

        BgNum bgNum = (BgNum) obj;

        long primaryKey = bgNum.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        BgNumModelImpl bgNumModelImpl = this;

        bgNumModelImpl._originalOwnerId = bgNumModelImpl._ownerId;

        bgNumModelImpl._setOriginalOwnerId = false;

        bgNumModelImpl._originalBoxGpId = bgNumModelImpl._boxGpId;

        bgNumModelImpl._setOriginalBoxGpId = false;

        bgNumModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<BgNum> toCacheModel() {
        BgNumCacheModel bgNumCacheModel = new BgNumCacheModel();

        bgNumCacheModel.bgNumId = getBgNumId();

        bgNumCacheModel.ownerId = getOwnerId();

        bgNumCacheModel.boxGpId = getBoxGpId();

        bgNumCacheModel.value = getValue();

        return bgNumCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgNumId=");
        sb.append(getBgNumId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", boxGpId=");
        sb.append(getBoxGpId());
        sb.append(", value=");
        sb.append(getValue());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.BgNum");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>bgNumId</column-name><column-value><![CDATA[");
        sb.append(getBgNumId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>boxGpId</column-name><column-value><![CDATA[");
        sb.append(getBoxGpId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>value</column-name><column-value><![CDATA[");
        sb.append(getValue());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
