package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Assmt;
import gov.va.caret.service.AssmtLocalServiceUtil;

/**
 * The extended model base implementation for the Assmt service. Represents a row in the &quot;CARET_ASSESSMENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AssmtImpl}.
 * </p>
 *
 * @author caret
 * @see AssmtImpl
 * @see gov.va.caret.model.Assmt
 * @generated
 */
public abstract class AssmtBaseImpl extends AssmtModelImpl implements Assmt {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a assmt model instance should use the {@link Assmt} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            AssmtLocalServiceUtil.addAssmt(this);
        } else {
            AssmtLocalServiceUtil.updateAssmt(this);
        }
    }
}
