package gov.va.caret.hook;

import java.io.IOException;
import java.util.Calendar;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;


public class LandingPage extends Action {

	private static final Log _log = LogFactoryUtil.getLog( LandingPage.class );

	@Override
	public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		Group userSite = (Group) request.getAttribute("groupSite");
		_log.info("landing page start..." );
		if ( userSite == null ){
			try {
				userSite = LandingGroupSequence.getUserSite( PortalUtil.getUser(request) );
			} catch (PortalException e) {
				e.printStackTrace();
			} catch (SystemException e) {
				e.printStackTrace();
			}
			if ( userSite == null ) {
				_log.info("landing page user site is null..." );
				if ( "true".equals( PropsUtil.get( "landing.url.redirect" ) ) ) {
					checkRedirect( request, response );
				}
				return;
			}
		}
		String siteLanding = PortalUtil.getPortalProperties().get( PropsKeys.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING ) + userSite.getFriendlyURL();
		LastPath lastPath = new LastPath(StringPool.BLANK, siteLanding);
		if ( _log.isInfoEnabled() ){
			_log.info("landing page..." + lastPath );
		}
		request.getSession().setAttribute(WebKeys.LAST_PATH, lastPath);
		if ( siteLanding.contains("clinic") ) {
			try {
				Calendar tenHours = Calendar.getInstance();
				tenHours.add( Calendar.MINUTE, PrefsPropsUtil.getInteger("clinic.total.session", 600) ); //default 10 hours
				CaretUtil.setExpandoValue( PortalUtil.getUser(request), CaretStrPool.MAX_SESSION_TIME, String.valueOf( tenHours.getTimeInMillis() ) );
			} catch (SystemException | PortalException e) {
				e.printStackTrace();
			}
		}
		
	}

	private void checkRedirect( HttpServletRequest request, HttpServletResponse response ) {
		String headerToCheck = PropsUtil.get( "sso.headerTo.check" );
		if ( Toolbox.isEmpty( headerToCheck ) ) {
			headerToCheck = "referer";
		}
		String referer = request.getHeader(headerToCheck);
		if ( !Toolbox.isEmpty(referer) ) {
			String ssoiUrlContains = PropsUtil.get( "ssoi.url.contains" );
			if (Toolbox.isEmpty(ssoiUrlContains) ) {
				ssoiUrlContains = "ssologon.";
			}
			if ( referer.contains( ssoiUrlContains ) ) {
				_log.info("AUTO_LOGIN_REDIRECT: " + PropsUtil.get( "logout.url.clinic" ) );
				request.setAttribute(AutoLogin.AUTO_LOGIN_REDIRECT, PropsUtil.get( "logout.url.clinic" ) );
				sendRedirect( response, PropsUtil.get( "logout.url.clinic" ) );
			} else {
				_log.info("AUTO_LOGIN_REDIRECT: " + PropsUtil.get( "logout.url.online" ) );
				request.setAttribute(AutoLogin.AUTO_LOGIN_REDIRECT, PropsUtil.get( "logout.url.online" ) );
				sendRedirect( response, PropsUtil.get( "logout.url.online" ) );
			}
		} else {
			String unknown = PropsUtil.get( "logout.url.headerless" );
			if ( !Toolbox.isEmpty(unknown) ) {
				request.setAttribute(AutoLogin.AUTO_LOGIN_REDIRECT, unknown );
				_log.info("AUTO_LOGIN_REDIRECT: " + unknown );
				sendRedirect( response, PropsUtil.get( "logout.url.online" ) );
			}
		}
	}
	
	public void sendRedirect ( HttpServletResponse response, String url ) {
		_log.info("trying redirect...2" + url);
		try {
			response.sendRedirect(url);
		} catch (IOException e) {
			_log.error( "redirect failed..." );
		}
	}
}


