package gov.va.caret.controller.dashboard.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
//import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

public class VisnDashboardConfig extends CscDashboardConfig {

	private String visnGroupIds = "0"; 
	private static final long serialVersionUID = 1L;
//	private static GenericReport APP_DELAY = new AdhocReport( "appDelay", ReportParameter.classPk ){
//		public String getPageName() {
//			return "appDelay";
//		}
//		public String getOrderBy() {
//			return "creationDate";
//		}
//		public boolean isDesc() {
//			return true;
//		}
//		public boolean isLazy(){
//			return true;
//		}
//	};
	
	public VisnDashboardConfig() {
		this.reports = new GenericReport[]{ 
//				APP_DELAY, 
				new GenericReport("appDelays", true, "creationDate", true, GenericReport.VISN_QUERY_NDX, ReportParameter.visnGroupIds ),
				new GenericReport("myApplicationWork", true, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
				new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId ),
				new CachedReport("persnAudit"),
				new CachedReport("persn"),
				new CachedReport("workAudit"),
				new CachedReport("vcgAudit"),
				new CachedReport("vcgOpenWork"),
				new CachedReport("vcgAssociatedCalls"),
				new CachedReport("vcgOpenRefs"),
				new CachedReport("vcgClosedWork"),
				new CachedReport("vcgClosedRefs"),
				new CachedReport("assmtAudit"),
				new CachedReport("assmtAuditAll"),
				new CachedReport("assmtAuditPeriodicAll"),
				new CachedReport("periodicAssessmentsAll"),
				new CachedReport("vcgSupportingDocsAll"),
				new CachedReport("vcgDocsHistoryAll")
			};
	
		enabledWork = new HashSet<WorkType>(Arrays.asList(new WorkType[]{
//				WorkType.CSC_APP, 
//				WorkType.ONLINE_APP, 
//				WorkType.CSC_WAIVER, 
				WorkType.APP_DELAY}));
	}
	
	public GenericReport getReport (String name){
		for ( GenericReport report: enabledSearch.getCachedReports() ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
		}
		for ( GenericReport report: reports ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
//			if ( name.startsWith("appDelay") ){
//				return APP_DELAY;
//			}
		}
		return null;
	}
	
	public Map<String, Long> getAssignees(WorkItemSupport workItem) {
		if ( WorkType.APP_DELAY == workItem.getWorkType() ){
			return getAppDelayAssignees();
		}
		return Collections.emptyMap();
	}
	
	public void configureFacility(PortletRequest request) throws ApplicationWorkFlowException {
		super.configureFacility(request);
		if ( CAction.canDoCaret(request, CAction.CaretCan.VISN_CSC_WAIVER_Q ) ){
			request.setAttribute("appDelay", true );
			enabledWork.add( WorkType.APP_DELAY );
		}
		
		Map<String,Long> groupIds = new TreeMap<String,Long>();
		try {
			for( Organization org: OrganizationLocalServiceUtil.getUserOrganizations( PortalUtil.getUserId(request) ) ){
				if ( org.getName().toLowerCase().startsWith("visn") ){
					visnId.add( org.getPrimaryKey() );
					for ( Organization descendant : org.getDescendants() ){
						Facil facil = FacilLocalServiceUtil.getByOrgId(descendant.getPrimaryKey());
						groupIds.put( facil.getFacilityNumber() + StringPool.DASH + descendant.getName(), descendant.getOrganizationId() );
					}
				} else {
					Facil facil = FacilLocalServiceUtil.getByOrgId( org.getOrganizationId() );
					groupIds.put( facil.getFacilityNumber() + StringPool.DASH + org.getName(), org.getOrganizationId() );
				}
			}
//			if ( groupId.isEmpty() ) {
				setVisnInfo ( request );
//			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
			
//		request.setAttribute("visnName", setVisnInfo(request) );
			
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put( "visnGroupIds", visnGroupIds );
		caret.put( CaretStrPool.GROUP_ID, groupId );
		caret.put( CaretStrPool.WORKITEM_GROUPS, groupIds );
		caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTreeNoDistrict( PortalUtil.getCompanyId( request ), true ) );
//		caret.put( CaretStrPool.USERMAP, request.getPortletSession().getAttribute(CaretStrPool.USERMAP) );
		caret.put( CaretStrPool.WORKITEM_TYPES, WorkType.getFilterRegistered() );
		caret.put( "CREATE_VACO_WAIVER", CAction.canDoCaret( request, CAction.CaretCan.CREATE_VACO_WAIVER ) );
		
	}
	
	
	@Override
	public void loadReports(PortletRequest request) throws ApplicationWorkFlowException {
		super.loadReports(request);
//		if ( request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) instanceof FacilityDashboardConfig ) {
//			Map<Long, String> orgMap = CaretUtil.getVhaOrgList( request );
//			ResultMap.getCaretMap(request).put( CaretStrPool.VHA_MEMBER, orgMap );
//			for ( Long orgId : orgMap.keySet() ){
//				ResultMap.getResultTotalMap( request ).put( "appDelay"+orgId, 
//					CaretLocalServiceUtil.getReportCount( "appDelay", orgId) );
//			}
//		}
	}
	
	public String setVisnInfo ( PortletRequest request ) {
		String visn = StringPool.BLANK;
		
		if ( CAction.canDoCaret(request, CaretCan.VACO_FUNCTION) && !visnId.isEmpty() ){
			StringBuilder sb = new StringBuilder();
			try {
				for ( Long vId: visnId ){
					Organization org = OrganizationLocalServiceUtil.getOrganization(vId);
					visn = org.getName() + StringPool.COMMA_AND_SPACE;
					List<Organization> descendants = org.getDescendants();
					if ( descendants != null && !descendants.isEmpty() ){
						for ( Organization organ: descendants ){
							sb.append( organ.getOrganizationId() ).append(StringPool.COMMA_AND_SPACE);
							groupId.add( org.getOrganizationId() );
						}
					}
				}
				visnGroupIds = sb.substring( 0, sb.length()-2 );
				visn = visn.substring( 0, visn.length()-2 );
			} catch (SystemException | PortalException e) {
				e.printStackTrace();
			}
		}
		return visn;
	}
	
	public String getVisnGroupIds(){
		return visnGroupIds;
	}
	
	public CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{};
	}
	
	@Override
	public String getView() {
		return "/jsp/dashboard/visn.jsp";
	}

	@Override
	public Map<String, String> getVisnMap() {
		Map<String, String> map = new HashMap<String, String>();
		map.put("visnGroupIds", visnGroupIds);
		return map;
	}
}
