package gov.va.caret.controller.dashboard.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Role;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;


public class ViewDashboardConfig extends DashboardConfig implements InitDashboard {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/internal/viewOnly.jsp";
	private static final Collection<WorkType> workItemTypes = new HashSet<WorkType>(Arrays.asList(new WorkType[]{
			WorkType.CSC_APP, 
//			WorkType.ONLINE_APP, 
			WorkType.CSC_WAIVER, 
			WorkType.VCG_TRANSFER, 
			WorkType.HOME_VISIT, 
			WorkType.REFERRAL, 
			WorkType.CALL_REFERRAL,
			WorkType.DELAY_REVIEWED,
			WorkType.CSL_REFERRAL,
			WorkType.HEC_REFERRAL,
			WorkType.APP_DELAY}));
	
	private static GenericReport[] viewReports = new GenericReport[]{ 
			new AdhocReport("vcgNotes", ReportParameter.classPk ),
			new CachedReport("persnAudit"),
			new CachedReport("persn"),
			new CachedReport("workAudit"),
			new CachedReport("vcgAudit"),
			new CachedReport("assmtAudit"),
			new CachedReport("assmtAuditAll"),
			new CachedReport("assmtAuditPeriodicAll"),
			new CachedReport("periodicAssessmentsAll"),
			new CachedReport("vcgSupportingDocsAll"),
			new CachedReport("vcgAssociatedCalls"),
			new CachedReport("vcgOpenRefs"),
			new CachedReport("vcgClosedRefs"),
			new CachedReport("vcgOpenWork"),
			new CachedReport("vcgClosedWork"),
			new CachedReport("vcgDocsHistoryAll")
		};
	
	public ViewDashboardConfig() {
		super();
		
		this.reports = viewReports;
		this.enabledSearch = new EnabledSearch( new CachedReport("vcgs"), new CachedReport("workItems"), 
				new CachedReport(CaretStrPool.CALLS), 
				new CachedReport(CaretStrPool.REFFERALS), 
				new CachedReport("searchCompletedSocs"),
				new CachedReport("searchSocs"), 
				new CachedReport("vendors"),
				new CachedReport("blsRates"),
				new CachedReport("payments"),
				new CachedReport("paymentConfig")
				);
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[0];
	}
	
	public Collection<WorkType> getEnabledWork() {
		return workItemTypes;
	}
	
	public Map<String, Long> getAssignees(WorkItemSupport workItem) {
		return Collections.emptyMap();
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR,
			};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}
	
	public void initDashBoard(PortletRequest request) {
		List<Role> roles;
		try {
			roles = RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) );
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
			_log.error("unable to init(2)");
			return;
		}
		Map<String,Long> roleMap = (Map<String,Long>)request.getPortletSession().getAttribute("ROLEMAP");
		if ( roleMap == null ) {
			roleMap = new TreeMap<String,Long>();
		}
		if ( roleMap.isEmpty() ){
			for ( Role role: roles ){
				roleMap.put(role.getName(), role.getRoleId() );
			}
			
			roleMap.put("veteran", 1l );
			roleMap.put("primary-general", 2l );
			roleMap.put("secondary-cg", 3l );
			roleMap.put("secondary-two-cg", 4l );
			roleMap.put("caller", 2l );
			
			request.getPortletSession().setAttribute("ROLEMAP", roleMap);
		}
	}
	
	@Override
	public void loadReports(PortletRequest request) throws ApplicationWorkFlowException {
		setSearchContext( request );
		super.loadReports(request);
	}
	
	protected void loadReport(GenericReport report, PortletRequest renderRequest) throws ApplicationWorkFlowException {
		int count = 0;
		ResultMap.getResultTotalMap( renderRequest ).put( report.getName(), count );
		
		if ( count > 0 && !report.isLazy() ){
			
			int cur = ParamUtil.getInteger(renderRequest, SearchContainer.DEFAULT_CUR_PARAM );
			int delta = ParamUtil.getInteger(renderRequest, SearchContainer.DEFAULT_DELTA_PARAM, SearchContainer.DEFAULT_DELTA);
			int start = ( cur == 0 )? 0 : delta * ( cur-1 );
			int end = ( cur == 0 )? delta : ( delta * cur );
			
			report.run(renderRequest, false, start, end);
		}
	}
	
	public void setSearchContext(PortletRequest request) throws ApplicationWorkFlowException {
		
		request.setAttribute(CaretStrPool.ROLES, request.getPortletSession().getAttribute("ROLEMAP"));
		
		Map<Long,Facil> facilities = CaretParam.getFacilities(request);
		request.setAttribute("facilIds", facilities.keySet() );
		if ( facilities != null && !facilities.isEmpty() ){
			StringBuilder sb = new StringBuilder(" ( ");
			for ( Iterator<Facil> iter = facilities.values().iterator(); iter.hasNext(); ){
				sb.append(iter.next().getFacilityNumber()).append(", ");
			}
			request.setAttribute("facility", sb.substring(0, sb.length() - 2) + " )" );
		}
		
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTreeNoDistrict( PortalUtil.getCompanyId( request ), true ) );
		caret.put( CaretStrPool.WORKITEM_TYPES, WorkType.getFilterRegistered() );
		caret.put( CaretStrPool.USE_WORKTYPES, true );
		caret.put( CaretStrPool.USE_PHONE, true);
		
		caret.put( CaretStrPool.FILTER_STATUSES, WorkItemSupport.CSC_WORK_STATUSES );
		caret.put( "cgRoles", new String[]{"caller", "UNKNOWN_CALLER", "primary-cg", "secondary-cg", "secondary-two-cg", "general-cg"} );
		caret.put( "USE_UNION", Boolean.TRUE );
		
		request.setAttribute("roleUsers", CaretLocalServiceUtil.getReport( "cslUserList", Collections.singletonMap("roleGroup", PortletProps.get(CaretStrPool.CSL_PROP) )) );
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			String[] array = (callType + StringPool.COMMA + "soc-call").split(StringPool.COMMA) ;
			List<String> c = ListUtil.fromArray(array);
			Collections.sort(c);
			ResultMap.getCaretMap(request).put( "standard-call-types", c );
		}
		ResultMap.getCaretMap(request).put( CaretStrPool.CUSTOM_CALL_TYPES, BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.CUSTOM_CALL_TYPES) );
		
	}
	
	
	
	private static Log _log = LogFactoryUtil.getLog( ViewDashboardConfig.class );

}
