package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkItemSupport;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CodifiedRole;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.portlet.PortletRequest;


public class TechDashboardConfig extends DashboardConfig implements InitDashboard {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/dashboard/tech.jsp";
	private static final Collection<WorkType> workItemTypes = new HashSet<WorkType>(Arrays.asList(new WorkType[]{
			WorkType.CSC_APP, 
			WorkType.ONLINE_APP, 
			WorkType.CSC_WAIVER, 
			WorkType.VCG_TRANSFER, 
			WorkType.HOME_VISIT, 
			WorkType.REFERRAL, 
			WorkType.TIU_NOTE_REWRITE,
			WorkType.FAILED_TIU_NOTE,
			WorkType.CALL_REFERRAL,
			WorkType.DELAY_REVIEWED,
			WorkType.CSL_REFERRAL,
			WorkType.HEC_REFERRAL,
			WorkType.APP_DELAY}));
	
	
	private static GenericReport FAILED_TIU_NOTE = new GenericReport( "failedTiuNote", true, "creationDate", true );
	private static GenericReport APPEALS = new CachedReport( "appeals" );
	private static GenericReport MY_WORK = new GenericReport( "myWork", true, "creationDate", true, ReportParameter.userId );
	
	public TechDashboardConfig() {
		super();
		Collection<GenericReport> enabledSearch = new TreeSet<GenericReport>();
		Collection<GenericReport> reportsColl = new TreeSet<GenericReport>();
		for ( DashboardType type: DashboardType.values() ){
			if ( type.isHelped() ){
				try {
					DashboardConfig dashboardConfig = type.dashboardConfig.newInstance();
					for ( GenericReport report : dashboardConfig.getReports() ){
						if ( report instanceof CachedReport || report instanceof AdhocReport ){
							enabledSearch.add( report );
						} else {
							reportsColl.add( report );
						}
					}
					enabledSearch.addAll( dashboardConfig.enabledSearch.getCachedReports() );
				} catch (InstantiationException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (IllegalAccessException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		enabledSearch.add(APPEALS);
		reportsColl.add( FAILED_TIU_NOTE );
		reportsColl.add(MY_WORK);
		this.reports = reportsColl.toArray( new GenericReport[reportsColl.size()] );
		this.enabledSearch = new EnabledSearch( enabledSearch );
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_APPLICATIONS,
			CAction.CaretCan.SET_GENERAL_CG,
			CAction.CaretCan.CREATE_CALLS,
			CAction.CaretCan.CREATE_CALL_TYPE,
			CAction.CaretCan.CREATE_REFERRAL
		};
	}
	
	public Collection<WorkType> getEnabledWork() {
		return workItemTypes;
	}
	
	public Map<String, Long> getAssignees(WorkItemSupport workItem) {
		if ( WorkType.FAILED_TIU_NOTE == workItem.getWorkType() ){
			Map<String,Long> userMap = new TreeMap<String,Long>();
			try {
				Role role = RoleLocalServiceUtil.getRole(companyId, CodifiedRole.getRoleName("TEC_ST1") );
				
				List<User> users = UserLocalServiceUtil.getRoleUsers( role.getRoleId() );
				for ( User user: users ){
					if ( user.getUserId() == userId ) continue;
					userMap.put(user.getFullName(), user.getUserId() );
				}
				
			} catch (SystemException e1) {
				ApplicationWorkFlowException.handleException(e1);
			} catch (PortalException e) {
				e.printStackTrace();
			}
			return userMap;
		}
		return Collections.singletonMap("UnAssign", 0l);
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR,
				CAction.CaretCan.IDENTITY_MATCHING
			};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}
	
	public void initDashBoard(PortletRequest request) {
		List<Role> roles;
		try {
			roles = RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) );
		} catch (SystemException e1) {
			ApplicationWorkFlowException.handleException(e1);
			_log.error("unable to init(2)");
			return;
		}
		Map<String,Long> roleMap = (Map<String,Long>)request.getPortletSession().getAttribute("ROLEMAP");
		if ( roleMap == null ) {
			roleMap = new TreeMap<String,Long>();
		}
		if ( roleMap.isEmpty() ){
			for ( Role role: roles ){
				roleMap.put(role.getName(), role.getRoleId() );
			}
			
			roleMap.put("veteran", 1l );
			roleMap.put("primary-general", 2l );
			roleMap.put("secondary-cg", 3l );
			roleMap.put("secondary-two-cg", 4l );
			roleMap.put("caller", 2l );
			
			request.getPortletSession().setAttribute("ROLEMAP", roleMap);
		}
	}
	
	@Override
	public void loadReports(PortletRequest request) throws ApplicationWorkFlowException {
		// No reports are loaded by default for Tech Dashboard
		setSearchContext( request );
		super.loadReports(request);
//		CAction.canImpersonate( renderRequest );
		
	}
	
	protected void loadReport(GenericReport report, PortletRequest renderRequest) throws ApplicationWorkFlowException {
		Object reportParams = CaretParam.getParameter( renderRequest, report.getParameterNames() );
		int count = 0;
		if ( report == FAILED_TIU_NOTE || report == MY_WORK ){
			count = CaretLocalServiceUtil.getReportCount( report.getName(), reportParams );
		}
		ResultMap.getResultTotalMap( renderRequest ).put( report.getName(), count );
		
		if ( count > 0 && !report.isLazy() ){
			
			int cur = ParamUtil.getInteger(renderRequest, SearchContainer.DEFAULT_CUR_PARAM );
			int delta = ParamUtil.getInteger(renderRequest, SearchContainer.DEFAULT_DELTA_PARAM, SearchContainer.DEFAULT_DELTA);
			int start = ( cur == 0 )? 0 : delta * ( cur-1 );
			int end = ( cur == 0 )? delta : ( delta * cur );
			
			report.run(renderRequest, false, start, end);
		}
	}
	
	public void setSearchContext(PortletRequest request) throws ApplicationWorkFlowException {
		
		request.setAttribute(CaretStrPool.ROLES, request.getPortletSession().getAttribute("ROLEMAP"));
		
		Map<Long,Facil> facilities = CaretParam.getFacilities(request);
		request.setAttribute("facilIds", facilities.keySet() );
		if ( facilities != null && !facilities.isEmpty() ){
			StringBuilder sb = new StringBuilder(" ( ");
			for ( Iterator<Facil> iter = facilities.values().iterator(); iter.hasNext(); ){
				sb.append(iter.next().getFacilityNumber()).append(", ");
			}
			request.setAttribute("facility", sb.substring(0, sb.length() - 2) + " )" );
		}
		
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTreeNoDistrict( PortalUtil.getCompanyId( request ), true ) );
		caret.put( CaretStrPool.WORKITEM_TYPES, WorkType.getFilterRegistered() );
	}
	
	private static Log _log = LogFactoryUtil.getLog( TechDashboardConfig.class );

}
