package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.model.Role;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkType;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletRequest;


public abstract class FacilityDashboardConfig extends DashboardConfig implements InitDashboard {

	/**
	 * 
	 */
	private static final long serialVersionUID = -119344347382509643L;
	protected Map<Long,Facil> facilities;
	protected Set<Long> groupId = new HashSet<Long>();
	protected Set<Long> visnId = new HashSet<Long>();
	protected Collection<WorkType> enabledWork = new HashSet<WorkType>(Arrays.asList(new WorkType[]{
			WorkType.CSC_APP,
			WorkType.ONLINE_APP,
			WorkType.CSC_WAIVER,
			WorkType.HOME_VISIT,
			WorkType.REFERRAL,
			WorkType.CALL_REFERRAL,
			WorkType.DELAY_REVIEWED,
			WorkType.CSL_REFERRAL,
			WorkType.VCG_TRANSFER,
			WorkType.VCG_TRANSFER_SOUGHT,
			WorkType.APPROVED_DISPOSITION,
			WorkType.REVOKED_DISPOSITION,
			WorkType.REINSTATED_DISPOSITION,
			WorkType.TIER_UPDATE,
			WorkType.ADDRESS_CHANGE,
			WorkType.HEC_REFERRAL}));
	
	public abstract void setFacilityId( long facilityId );
	public abstract Set<Long> getGroupId();
	public abstract Set<Long> getVisnId();
	public abstract Map<Long,Facil> getFacilities();
	public abstract void setFacilities(Map<Long,Facil> facilities);
	public abstract void configureFacility( PortletRequest request ) throws ApplicationWorkFlowException;
	public abstract void setUsers(PortletRequest request, List<Role> roles ) throws ApplicationWorkFlowException;
	public abstract Map<String,String> getVisnMap();
	
	@Override
	public void loadReports(PortletRequest request) throws ApplicationWorkFlowException {
		configureFacility( request );
		super.loadReports(request);
	}
	
	public boolean canAssign(WorkType workType) {
		return enabledWork.contains(workType);
	}
}
