package gov.va.caret.controller.dashboard.config;

import gov.va.caret.security.CAction;

public enum DashboardType {
	CSC_FUNCTION( CscDashboardConfig.class, CAction.CaretCan.CSC_FUNCTION, true ),
	CSL_FUNCTION( CslDashboardConfig.class, CAction.CaretCan.CSL_FUNCTION, true ),
	HEC_FUNCTION( HealthDashboardConfig.class, CAction.CaretCan.HEALTH_FUNCTION, true ),
	HRC_FUNCTION( HealthDashboardConfig.class, CAction.CaretCan.HEALTH_FUNCTION, true ),
	CBOPC_FUNCTION( CbopcDashboardConfig.class, CAction.CaretCan.CBOPC_FUNCTION, true ),
	CBOPCFM_FUNCTION( CbopcFmDashboardConfig.class, CAction.CaretCan.CBOPCFM_FUNCTION, true ),
	VACO_FUNCTION( VisnDashboardConfig.class, CAction.CaretCan.VACO_FUNCTION, true ),
	VIEW_FUNCTION( ViewDashboardConfig.class, CAction.CaretCan.VIEW_FUNCTION, true ),
	TECH_FUNCTION( TechDashboardConfig.class, CAction.CaretCan.TECH_FUNCTION, false );
	
	Class<? extends DashboardConfig> dashboardConfig;
	boolean helped = false;
	CAction.CaretCan dashboardAction;
	
	DashboardType( Class<? extends DashboardConfig> dashboardConfig, CAction.CaretCan action, boolean helped ){
		this.dashboardConfig = dashboardConfig;
		this.dashboardAction = action;
		this.helped = helped;
	}
	
	public CAction.CaretCan getAction (){
		return CAction.CaretCan.valueOf( name() );
	}
	public boolean isHelped (){
		return helped;
	}
	public CAction.CaretCan getDashboardAction (){
		return dashboardAction;
	}
}