package gov.va.caret.controller.dashboard.config;

import java.util.Map;

import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Role;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.security.CAction;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.ResultMap;

public class DashboardConfigFactory { 
	
	public static DashboardConfig loadInstance( PortletRequest request, MimeResponse response ) {
		DashboardConfig dashboardConfig = null;
		
		if ( request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) == null || CAction.isOmniAdmin( request )){
			try {
				dashboardConfig = initDashboard(request);
				request.getPortletSession().setAttribute( CaretStrPool.DASHBOARD_CONFIG, dashboardConfig);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		} else {
			dashboardConfig = (DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		}
		if ( dashboardConfig != null ){
			try {
				request.setAttribute( CaretStrPool.ROLE, dashboardConfig.getRole() );
				if ( response != null ){
					
					request.setAttribute( CaretStrPool.CARET_MENU, dashboardConfig.getMenu( request ) );
					request.setAttribute( CaretStrPool.SEARCHES, dashboardConfig.getEnabledSearch().getKeywords() );
					if ( dashboardConfig.getEnabledSearch().getKeywords().contains("vcgs") && request.getPortletSession().getAttribute("searchForm") == null ) {
						Map<String,Object> form = ResultMap.getForm (request);
						form.put("searchContext", "vcgs" );
						request.getPortletSession().setAttribute("searchForm", form);
					}
					dashboardConfig.loadReports ( request );
				}
				
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		if ( dashboardConfig == null ){
			_log.info("dashboard is...null");
		} else {
			_log.info("dashboard is..." + dashboardConfig.getRole() );
		}
		return dashboardConfig;
	}

	private static DashboardConfig initDashboard ( PortletRequest request ) throws SystemException, ApplicationWorkFlowException {

		if ( CAction.isOmniAdmin( request ) ){
			DashboardConfig dashboardConfig = DashboardConfig.getOmniDashboard( PortalUtil.getCompanyId(request) );
			if ( dashboardConfig != null ) {
				if ( dashboardConfig instanceof InitDashboard ){
					((InitDashboard) dashboardConfig).initDashBoard( request );
				}
				return dashboardConfig;
			}
		}

		//Assumption is that CareT users will have at most 1 site role and 1 general role with sub-type "CareT"
		long userId = PortalUtil.getUserId(request);
		for ( Role role : RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) ) ){
			if ( _log.isDebugEnabled() ){
				_log.debug ("Role is " +  role.getName() );
			}
			if ( RoleLocalServiceUtil.hasUserRole( userId, role.getRoleId() ) ){
				try { 
					for ( DashboardType dashboarType: DashboardType.values() ){ 
						if ( CAction.canDoCaret( request, dashboarType.getDashboardAction() ) ){
							DashboardConfig dashboardConfig = dashboarType.dashboardConfig.newInstance();
							dashboardConfig.setRole( role.getName() );
							dashboardConfig.setRoleId ( role.getRoleId() );
							dashboardConfig.setRoleHref( CaretUtil.getTrainingDocument(role) );
							if ( dashboardConfig instanceof InitDashboard ){
								((InitDashboard) dashboardConfig).initDashBoard( request );
							}
							
							return dashboardConfig;
						}
					}
				} catch(java.lang.IllegalArgumentException e){
					ApplicationWorkFlowException.handleException(e);
				} catch (InstantiationException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (IllegalAccessException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			} else {
				if ( _log.isDebugEnabled() ){
					_log.debug("Not..." + role.getName() );
				}
			}
		}
		
		_log.info("No dashboard created...");
		return null;
	}
	
	
	private static Log _log = LogFactoryUtil.getLog(DashboardConfigFactory.class);
	
}