package gov.va.caret.controller.dashboard.config;

import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.letters.OccLetterType;
import gov.va.caret.model.BgNum;
import gov.va.caret.model.impl.BgNumImpl;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.BgNumLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PayLgLocalServiceUtil;
import gov.va.caret.service.impl.FmsOgSupport;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

public class CbopcFmDashboardConfig extends DashboardConfig {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/dashboard/cbopcfm.jsp";
	public static final long AVAILABLE_ID = 212l;
	public static final long THRESHOLD_ID = 211l;
	private static final String AVAILABLE = "AVAILABLE";
	private static final String SCHEDULED = "SCHEDULED";
	private static final String THRESHOLD = "THRESHOLD";
	
	public CbopcFmDashboardConfig() {
		super();
		this.enabledSearch = new EnabledSearch( new CachedReport("blsRates"), new CachedReport("vendors"), new CachedReport("payments") );
		this.reports = new GenericReport[]{ 
								new CachedReport("workAudit"),
								new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId ),
								new GenericReport("occFmPayments", true, "wi.creationDate", true, GenericReport.FM_QUERY_NDX ),
								new GenericReport("occFmRequest", true, "fo.creationDate", true, GenericReport.FM_QUERY_NDX ),
								new GenericReport("occFmResponse", true, "fin.creationDate", true, GenericReport.FM2_QUERY_NDX ),
		};
		try {
			List<BgNum> list = BoxGpLocalServiceUtil.getBoxGroupBgNum( AVAILABLE_ID );
			if ( list.isEmpty() ){
				BgNum available = new BgNumImpl();
				available.setBoxGpId(AVAILABLE_ID);
				available.setOwnerId(AVAILABLE_ID);
				available.setValue(0);
				BgNumLocalServiceUtil.addBgNum(available);
			}
			List<BgNum> trlist = BoxGpLocalServiceUtil.getBoxGroupBgNum( THRESHOLD_ID );
			if ( trlist.isEmpty() ){
				BgNum threshold = new BgNumImpl();
				threshold.setBoxGpId(THRESHOLD_ID);
				threshold.setOwnerId(THRESHOLD_ID);
				threshold.setValue(5000000);
				BgNumLocalServiceUtil.addBgNum(threshold);
			}
		} catch (SystemException e) {
			e.printStackTrace();
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
	}

	
	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
				CAction.CaretCan.UPDATE_FUNDING,
				CAction.CaretCan.FMS_SERVICE
		};
	}
/*
 * (non-Javadoc)
 * @see gov.va.caret.controller.dashboard.config.DashboardConfig#getToolsActions()
 */
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}
	
	public final CAction.CaretCan[] getMessageActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.INTERNAL_MESSAGE
		};
	}

	@Override
	public String getView() {
		return VIEW;
	}
	
	
	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		
		super.loadReports( request );
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		caret.put("menu", "fms");
		caret.put( "cgRoles", new String[]{"vendor"} );
		BgNum available = BoxGpLocalServiceUtil.getBoxGroupBgNum( AVAILABLE_ID ).get(0);
		caret.put("avid", available.getPrimaryKey());
		BgNum threshold = BoxGpLocalServiceUtil.getBoxGroupBgNum( THRESHOLD_ID ).get(0);
		caret.put("thid", threshold.getPrimaryKey());
		_log.info("avid:");
		caret.put(AVAILABLE, available.getValue());
		caret.put(THRESHOLD, threshold.getValue());
		caret.put(CaretStrPool.USE_DATE_RANGE, true);
		
		caret.put("week", Toolbox.getWeekRange( new Date() ) );
		caret.put("month", DateFormatSymbols.getInstance().getMonths()[Calendar.getInstance().get(Calendar.MONTH)] );
		
		Map<String,String> thresholdData = new HashMap<String,String>();
		thresholdData.put("not-less-than", "5000000" );
		caret.put("thresholdData", thresholdData );
		
		Calendar calendar = Calendar.getInstance();
		double result = CaretLocalServiceUtil.getFmsOutSum( new Date() );
		_log.info("result:" + result);
		caret.put("candidate", result > 0);
		
		if ( result > 0 ) {
			caret.put(SCHEDULED, result);
			caret.put("projected", "Elected" );
		} else {
			//TODO: run query...
			double estimatedMonth = CaretLocalServiceUtil.getFmsOutSumEstimate( String.valueOf( calendar.get(Calendar.MONTH) ), String.valueOf( Calendar.MONTH + calendar.get(Calendar.YEAR)*12 ) );
			caret.put(SCHEDULED, estimatedMonth);
			caret.put("projected", "Estimated" );
		}
		
		caret.put(CaretStrPool.OCC_LETTER_NAMES, Arrays.asList(OccLetterType.values()));
	}

}
