package gov.va.caret.controller;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.model.Dummy;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.OnlineDashboardConfig;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.VcgUx;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.impl.VcgUxImpl;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.pdf.FileType;
import gov.va.caret.pdf.PdfHandler;
import gov.va.caret.pdf.VaForm1010cgSection;
import gov.va.caret.security.CAction;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgUxLocalServiceUtil;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.OnlineUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ResultMap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ProcessAction;

import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;


/*
 * Central controller for CareT Online... shared between ResourceCommand and ActionCommand
 * 
 */

public class OnlineViewController extends CaretBaseViewController implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	public static Log _log = LogFactoryUtil.getLog(  OnlineViewController.class );
	
	private static OnlineViewController viewController = null;
	
	public static OnlineViewController get(){
		if ( viewController == null ){
			viewController = new OnlineViewController();
		}
		return viewController;
	}
	
	@Override
	public String loadDefaultView( PortletRequest request, MimeResponse response ){
		
		String mvcPath = ParamUtil.get( request, CaretStrPool.MVC_PATH, StringPool.BLANK );
		_log.info("mvcPath..." + mvcPath);
		
		loadFlexWidgetConfig( request );
		
		Map<String,Object> form = ResultMap.getForm (request);
    	List<VcgUx> applicationUserExperienceList;
		try {
			applicationUserExperienceList = VcgUxLocalServiceUtil.findByTentenRole( PortalUtil.getUserId(request), new long[] {1l}, false);
			if ( applicationUserExperienceList == null || applicationUserExperienceList.isEmpty() ) {
				form.put("appInProgress", false );
			} else {
				form.put("appInProgress", true );
			}
		} catch (ApplicationWorkFlowException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
		if ( StringPool.BLANK.equals( mvcPath ) && request.getAttribute( CaretStrPool.MVC_PATH ) != null ){
			mvcPath = (String) request.getAttribute( CaretStrPool.MVC_PATH );
		}
		if ( StringPool.BLANK.equals( mvcPath ) ){
			try {
				mvcPath = loadRoleView( request, response ); 
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return mvcPath;
	}
	
	private void loadFlexWidgetConfig(PortletRequest request) {
		if ( StringPool.TRUE.equals( PropsUtil.get("ESigDSS.widget.ssoe.enabled") ) ){
			try {
				request.setAttribute("eSigWidget", new String( FileUtil.getFile().getBytes( new File( CaretUtil.getWsdlDirectory() + "/eSigWidget.html") )) );
				request.setAttribute("iframeScript", new String( FileUtil.getFile().getBytes( new File( CaretUtil.getWsdlDirectory() + "/script.js") )) );
			} catch (IOException e) {
				_log.error("COULD NOT LOAD FLEX WIDGET CONFIG");
				e.printStackTrace();
			}
		} else {
			_log.warn("ESIG WIDGET (ESigDSS.widget.ssoe.enabled) NOT ENABLED");
		}
		
	}
	
	public void loadAddress(String prefix, Map<String,String> map, Person persn) throws ApplicationWorkFlowException {
		persn.setCountry( map.get(prefix+"_country") );
		OnlineViewController.get().loadPersnAddress( map, persn, prefix );
		
		if ( PortletProps.get("required."+ persn.getRole().getLabel() + ".input").contains("uspsValidation") &&
				!persn.isForeigner() ){
			persn.setValidAddress(true);
		}
	}
	
	@ProcessAction (name="saveApplicationVcg")
	public long saveApplicationVcg( PortletRequest request, Map<String,String> map, Person signedPerson ) throws ApplicationWorkFlowException, PortalException, SystemException {
		
		Person intent = null;
		long vcgAnId = Toolbox.getLong("vcgAnId", map); 
		Persn persn = null;
		persn = PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) );			
	
		Veteran veteran = null;
		Primary primary = null;
		Secondary secondary = null;
		SecondaryTwo secondaryTwo = null;
		
		VcgApplication vcgApplication;
		StringBuilder message = new StringBuilder();
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
		String signed1010Form = LanguageUtil.get(themeDisplay.getLocale(), "signed-1010cg-form", " signed VA Form 10-10CG" );
		ServiceContext sc = CaretParam.setOnlineServiceContext(request);
		Set<Long> userIds = new HashSet<Long>();
		boolean signedAndSaved = false;
		
		if ( vcgAnId > 0 ){  //Update to application by caregiver
			
			try {
				vcgApplication = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAnId) ); 
				veteran = new Veteran ( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
				userIds.add( veteran.getRootUserId() );
				if ( vcgApplication.getPrimaryId() > 0 && vcgApplication.getPrimaryId() == persn.getPersnId() ){
					if ( vcgApplication.getPrimarySignDate() != null ){
						throw new ApplicationWorkFlowException( "Application was signed in another session." );
					}
					boolean mediEnrolled =  Toolbox.getBoolean("vcgAn_mediEnrolled", map );
					vcgApplication.setMediEnrolled(mediEnrolled);
					vcgApplication.setPrimaryRelationship(map.get("vcgAn_primaryRelationship"));
					
					primary = new Primary ( PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ) );
					
					Primary formPrim = (Primary) CaretParam.loadModel(map, new Primary( new PersnImpl() ),
							Toolbox.getCollection("lastName","firstName","middleName",
													"birthDate","gender","ssn","email","phone","phone2","email2", "otherHealthInsurance" ), 
													CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
					formPrim.setMediEnrolled(mediEnrolled);
					loadAddress( CaretStrPool.PRIMARY_PERSN, map, formPrim );
					boolean otherHealthInsurance = Toolbox.getBoolean("vcgAn_otherHealthInsuranceYesNo", map);
					String otherHealthInsuranceName = map.get("vcgAn_otherHealthInsurance");
					formPrim.setOtherInsChecked(otherHealthInsurance);
					if ( !otherHealthInsurance ){
						formPrim.setOtherHealthInsurance(StringPool.BLANK);
					} else {
						formPrim.setOtherHealthInsurance(otherHealthInsuranceName);
					}
					//formPrim.getOtherHeathBoolean()
					if ( OnlineUtil.isRevision(formPrim, primary) ){
						CaretLocalServiceUtil.save( formPrim );
						vcgApplication.setPrimaryId( formPrim.getPersnId() );
						primary = formPrim;
					} else {
						CaretLocalServiceUtil.save( primary );
					}
					primary.setFamily( Toolbox.getBoolean( "certifyFamily", map) ); 
					primary.setNotFamily( Toolbox.getBoolean( "certifyNotFamily", map ) );
					primary.setRelationship( vcgApplication.getPrimaryRelationship() );
					message.append(primary.getFullName());
					userIds.add( primary.getRootUserId() );
					intent = primary;
		      		_log.info("person is primary, notFamily=" + intent.isNotFamily() + ".. family=" + intent.isFamily()  );
				}
				if ( vcgApplication.getSecondaryId() > 0 && vcgApplication.getSecondaryId() == persn.getPersnId() ){
					if ( vcgApplication.getSecondarySignDate() != null ){
						throw new ApplicationWorkFlowException( "Application was signed in another session." );
					}
					vcgApplication.setSecondaryRelationship( map.get("vcgAn_secondaryRelationship") );
					
					secondary = new Secondary ( PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ) );
					
					Secondary formSec = (Secondary) CaretParam.loadModel(map, new Secondary( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
							"birthDate","gender","ssn","phone","phone2","email","email2"), CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
					loadAddress( CaretStrPool.SECONDARY_PERSN, map, formSec );
					if ( OnlineUtil.isRevision(formSec, secondary) ){
						CaretLocalServiceUtil.save( formSec );
						vcgApplication.setSecondaryId( formSec.getPersnId() );
						secondary = formSec;
					} else {
						CaretLocalServiceUtil.save( secondary );
					}
					secondary.setFamily( Toolbox.getBoolean( "certifyFamily", map) ); 
					secondary.setNotFamily( Toolbox.getBoolean( "certifyNotFamily", map) ); 
					secondary.setRelationship( vcgApplication.getSecondaryRelationship() );
					message.append(secondary.getFullName());
					userIds.add( secondary.getRootUserId() );
					intent = secondary;
		      		_log.info("person is secondary");
				}
				if ( vcgApplication.getSecondaryTwoId() > 0 && vcgApplication.getSecondaryTwoId() == persn.getPersnId() ){
					if ( vcgApplication.getSecondaryTwoSignDate() != null ){
						throw new ApplicationWorkFlowException( "Application was signed in another session." );
					}
					vcgApplication.setSecondaryTwoRelationship( map.get("vcgAn_secondaryTwoRelationship") );
					
					secondaryTwo = new SecondaryTwo ( PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ) );
					
					SecondaryTwo formSec2 = (SecondaryTwo) CaretParam.loadModel(map, new SecondaryTwo( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
							"birthDate","gender","ssn","phone","phone2","email","email2"), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
					loadAddress( CaretStrPool.SECONDARY_TWO_PERSN, map, formSec2 );
					if ( OnlineUtil.isRevision(formSec2, secondaryTwo) ){
						CaretLocalServiceUtil.save( formSec2 );
						vcgApplication.setSecondaryTwoId( formSec2.getPersnId() );
						secondaryTwo = formSec2;
					} else {
						CaretLocalServiceUtil.save( secondaryTwo );
					}
					secondaryTwo.setFamily( Toolbox.getBoolean( "certifyFamily", map) ); 
					secondaryTwo.setNotFamily( Toolbox.getBoolean("certifyNotFamily", map) ); 
					secondaryTwo.setRelationship( vcgApplication.getSecondaryTwoRelationship() );
					message.append(secondaryTwo.getFullName());
					userIds.add( secondaryTwo.getRootUserId() );
					intent = secondaryTwo;
		      		_log.info("person is secondarytwo");
				}
				/*
				if ( "eSig".equals(request.getParameter("eSig") ) ) {
					VaForm1010cgSection vaForm1010cg = new VaForm1010cgSection( intent, vcgApplication, null );
					try {
						_log.info("CGC signing form");
						if ( !new PdfHandler().signUpdateDocum(vaForm1010cg) ){
							_log.error("Could not save document, it was locked by another user");
							request.setAttribute(CaretStrPool.FORM, vaForm1010cg );
							loadApplication ( request );
							return 0;
						} else {
							message.append( signed1010Form );
							if ( intent.getRole() == Person.Role.PRIMARY ){
								vcgApplication.setPrimarySignDate( sc.getCreateDate() );
							} else if ( intent.getRole() == Person.Role.SECONDARY ){
								vcgApplication.setSecondarySignDate( sc.getCreateDate() );
							} else if ( intent.getRole() == Person.Role.SECONDARYTWO ){
								vcgApplication.setSecondaryTwoSignDate( sc.getCreateDate() );
							}
						}
					} catch (COSVisitorException | IOException e2) {
						e2.printStackTrace();
						_log.error("Error for sign");
						return 0;
					}
				}*/
			} catch (PortalException e) {
				throw new ApplicationWorkFlowException(e);
			} catch (SystemException e) {
				throw new ApplicationWorkFlowException(e);
			}
		} else {  // new Application submitted by Veteran....
			veteran = new Veteran(PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ));
			vcgApplication = (VcgApplication) 
					CaretParam.loadModel(map, 
					new VcgApplication( new VcgAnImpl() ), 
					Toolbox.getCollection("lastTreatmentPlace","hospital","clinic","vaHealthEnrolled","primaryId","secondaryId","secondaryTwoId"), 
					CaretStrPool.VCGAN_UNDERLINE);
			
			if ( ( vcgApplication.getPrimaryId() > 0 && !veteran.isPrimaryAvailable() )
			  || ( vcgApplication.getSecondaryId() > 0 && !veteran.isSecondaryAvailable() )
			  || ( vcgApplication.getSecondaryTwoId() > 0 && !veteran.isSecondaryTwoAvailable() )){
				throw new ApplicationWorkFlowException( "Application was signed in another session...." );
			}
			
			Veteran formPerson = (Veteran) CaretParam.loadModel(map, new Veteran( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
					"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.VETERAN_PERSN_UNDERLINE);
			loadAddress( CaretStrPool.VETERAN_PERSN, map, formPerson );
			formPerson.setVaHealthEnrolled( vcgApplication.getVaHealthEnrolled() );

			if ( OnlineUtil.isRevision(formPerson, veteran) ){
				CaretLocalServiceUtil.save( formPerson );
				veteran = formPerson;
			} else {
				CaretLocalServiceUtil.save( veteran );
			}
			userIds.add( veteran.getRootUserId() );//[22601]
			
			if ( vcgApplication.getPrimaryId() > 0 ){
				primary = new Primary( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) ); 
				userIds.add( primary.getRootUserId() );
				String secondEmail = map.get("primaryPersn_email2");
				if ( !Toolbox.isEmpty(  secondEmail ) && !Person.EMAIL_FORMAT.equals(secondEmail) ){
					primary.setEmail2( secondEmail );
					CaretLocalServiceUtil.save(primary);
				}
			}
			
			if ( vcgApplication.getSecondaryId() > 0 ){
				secondary = new Secondary( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) ); 
				userIds.add( secondary.getRootUserId() );
				String secondEmail = map.get("secondaryPersn_email2");
				if ( !Toolbox.isEmpty(  secondEmail ) && !Person.EMAIL_FORMAT.equals(secondEmail) ){
					secondary.setEmail2( secondEmail );
					CaretLocalServiceUtil.save(secondary);
				}
			}
			
			if ( vcgApplication.getSecondaryTwoId() > 0 ){
				secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) ); 
				userIds.add( secondaryTwo.getRootUserId() );
				String secondEmail = map.get("secondaryTwoPersn_email2");
				if ( !Toolbox.isEmpty(  secondEmail ) && !Person.EMAIL_FORMAT.equals(secondEmail) ){
					secondaryTwo.setEmail2( secondEmail );
					CaretLocalServiceUtil.save(secondaryTwo);
				}
			}
			
			vcgApplication.setVeteranId( veteran.getPersnId() );
			vcgApplication.setGroupId( veteran.getGroupId() );
			vcgApplication.setStatus( ApplicationStatus.NEED_SIGNATURE.name() );

			message.append(formPerson.getFullName()).append(signed1010Form);
			
			CaretLocalServiceUtil.save( vcgApplication );
			
			if ( !Toolbox.getBoolean( "signed", map) ) {
				_log.info("VVV signing form");
				VaForm1010cgSection vaForm1010cg = new VaForm1010cgSection( veteran, vcgApplication, null );
				try {
					if ( !new PdfHandler().signUpdateDocum(vaForm1010cg) ){
						_log.error("Could not save document, it was locked by another user");
					} else {
						signedAndSaved = true;
					}
				} catch (COSVisitorException | IOException e2) {
					e2.printStackTrace();
				}
			}
		}
		
		WorIm workItem = null;
		if (signedPerson != null) {
			if ( signedPerson.getRole() == Person.Role.PRIMARY ){
				vcgApplication.setPrimarySignDate( sc.getCreateDate() );
			} else if ( signedPerson.getRole() == Person.Role.SECONDARY ){
				vcgApplication.setSecondarySignDate( sc.getCreateDate() );
			} else if ( signedPerson.getRole() == Person.Role.SECONDARYTWO ){
				vcgApplication.setSecondaryTwoSignDate( sc.getCreateDate() );
			}
		}
		
		
		if ( vcgAnId > 0 ){
			int signCount = 0;
			if ( vcgApplication.getSecondaryTwoSignDate() != null ) signCount++;
			if ( vcgApplication.getPrimarySignDate() != null ) signCount++;
			if ( vcgApplication.getSecondarySignDate() != null ) signCount++;
			
			int idCount = 0;
			if ( vcgApplication.getPrimaryId() > 0 ) idCount++;
			if ( vcgApplication.getSecondaryId() > 0 ) idCount++;
			if ( vcgApplication.getSecondaryTwoId() > 0 ) idCount++;
			
			if ( signCount > 0 && signCount == idCount ){
				vcgApplication.setSubmitDate( sc.getCreateDate() );
				vcgApplication.setReceivedDate( sc.getCreateDate() );
				vcgApplication.setStatus( ApplicationStatus.SUBMITTED.name() );
				long caregiverId = 0;
				if ( vcgApplication.getPrimaryId() > 0 ){
					caregiverId = vcgApplication.getPrimaryId(); 
					if ( primary == null ){
						primary = new Primary( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) );
					}
					userIds.add( primary.getRootUserId() );
				} else if ( vcgApplication.getSecondaryId() > 0 ){
					caregiverId = vcgApplication.getSecondaryId();
					if ( secondary == null ){
						secondary = new Secondary( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) );
					}
					userIds.add( secondary.getRootUserId() );
				} else {
					caregiverId = vcgApplication.getSecondaryTwoId();
					userIds.add(caregiverId);
					if ( secondaryTwo == null ){
						secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) );
					}
					userIds.add( secondaryTwo.getRootUserId() );
				}
				userIds.add( veteran.getRootUserId() );
				
				workItem = CaretUtil.createWorkItem( sc, vcgApplication.getGroupId(), vcgApplication, WorkType.ONLINE_APP, veteran.getPersnId(), caregiverId );
			
			}
		}
		CaretLocalServiceUtil.save( vcgApplication );

		if ( signedAndSaved ) {
			_log.info("User signed and saved in 1 call");
		} else {
			_log.info("User used save for later on eSig... merge docum ID");
			List<VcgUx> applicationUserExperienceList = VcgUxLocalServiceUtil.findByTentenRole( PortalUtil.getUserId(request), new long[] {Person.Role.VETERAN.getId()}, false );
			if ( applicationUserExperienceList != null && !applicationUserExperienceList.isEmpty() ) {
				String documId;
				try {
					documId = Toolbox.getUrlQuery( applicationUserExperienceList.get(0).getUxState() ).get("documId");
					Docum docum = DocumLocalServiceUtil.getDocum( Long.valueOf(documId) );
					docum.setClassPk(vcgApplication.getVcgAnId());
					docum.setClassId(PortalUtil.getClassNameId(VcgAn.class));
					docum.setNote(StringPool.BLANK);
					DocumLocalServiceUtil.updateDocum(docum);
				} catch (UnsupportedEncodingException e) {
					e.printStackTrace();
				}
			}
		}
		
		
		map.put(CaretStrPool.VCGANID, Long.toString(vcgApplication.getVcgAnId()));
		String tracker = map.get(CaretStrPool.TRACKER);
		List<Docum> documents = DocumLocalServiceUtil.getByTrackerNote( tracker );
		for ( Docum docum : documents ){
			if ( docum.getClassPk() == 0 ){
				docum.setClassPk(vcgApplication.getVcgAnId());
				docum.setClassId(PortalUtil.getClassNameId(VcgAn.class));
				docum.setNote(StringPool.BLANK);
				DocumLocalServiceUtil.updateDocum(docum);
			}
		}
		
		for ( long userId : userIds ){
			CaretLocalServiceUtil.addNote( CaretUtil.createNote(
					sc.getCreateDate(), vcgApplication.getVcgAnId(), 0, userId, message.toString() ) );
		}
		if ( workItem != null ){
			String workAddedToQue = LanguageUtil.get(themeDisplay.getLocale(), "online-1010-work-added-to-q", "10-10CG was submitted to VA for Review." );
			CaretLocalServiceUtil.save( workItem );
			userIds = new HashSet<Long>();
			userIds.add(veteran.getRootUserId());
			if ( vcgApplication.getPrimaryId() > 0 ){
				userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getPrimaryId())).getRootUserId());
			}
			if ( vcgApplication.getSecondaryId() > 0 ){
				userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getSecondaryId())).getRootUserId());
			}
			if ( vcgApplication.getSecondaryTwoId() > 0 ){
				userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getSecondaryTwoId())).getRootUserId());
			}
			for ( long userId : userIds ){
				CaretLocalServiceUtil.addNote( CaretUtil.createNote(
						sc.getCreateDate(), vcgApplication.getVcgAnId(), 0, userId, workAddedToQue ) );
			}
		}
		_log.info( "finished Application creation...");
		return vcgApplication.getVcgAnId();
	}
	

	public long signPdfDocument( PortletRequest request, Map<String,String> map ) {

//		if ( "eSig".equals(request.getParameter("eSig") ) ) {

		try {
			
			VcgAn vcgApplication = new VcgApplication( new VcgAnImpl() );
			int roleId = ParamUtil.getInteger(request, CaretStrPool.ROLE_ID );
			long userId = PortalUtil.getUserId(request);
			long vcgAnId = 0;
			Person.Role role = Person.Role.getRole( roleId );
			VcgAn vcgAn;
			Person intent;
			switch( role ) {
			case VETERAN:
				vcgAn = (VcgAn)
				CaretParam.loadModel(map, 
						new VcgApplication( new VcgAnImpl() ), 
						Toolbox.getCollection("lastTreatmentPlace","hospital","clinic","vaHealthEnrolled","primaryId","secondaryId","secondaryTwoId"), 
						CaretStrPool.VCGAN_UNDERLINE);
		
				intent = new Veteran( PersnLocalServiceUtil.getPersn( CaretParam.getPersnId(request) ) );
				intent = (Veteran) CaretParam.loadModel(map, intent, Toolbox.getCollection("lastName","firstName","middleName",
						"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.VETERAN_PERSN_UNDERLINE);
				loadAddress( CaretStrPool.VETERAN_PERSN, map, intent );
				((Veteran)intent).setVaHealthEnrolled(vcgAn.getVaHealthEnrolled());
				break;
			case PRIMARY:
				vcgAnId = Long.valueOf( map.get( CaretStrPool.VCGANID) );
				vcgApplication = vcgAnId > 0 ? VcgAnLocalServiceUtil.getVcgAn(vcgAnId) : new VcgAnImpl();
    			vcgAn = (VcgAn) CaretParam.loadModel(request, vcgApplication, vcgApplication.getModelAttributes().keySet(), "vcgAn_");
    			intent = new Primary ( PersnLocalServiceUtil.getLatest( userId ) );
				intent = (Primary) CaretParam.loadModel(request, intent, Toolbox.getCollection("lastName","firstName","middleName",
						"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.PRIMARY_PERSN + StringPool.UNDERLINE);
				loadPersnAddress( request, intent, CaretStrPool.PRIMARY_PERSN );
				intent.setRelationship(vcgAn.getPrimaryRelationship());
				((Person)intent).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
				((Person)intent).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
				break;
			case SECONDARY:
				vcgAnId = Long.valueOf( map.get( CaretStrPool.VCGANID) );
				vcgApplication = vcgAnId > 0 ? VcgAnLocalServiceUtil.getVcgAn(vcgAnId) : new VcgAnImpl();
    			vcgAn = (VcgAn) CaretParam.loadModel(request, vcgApplication, vcgApplication.getModelAttributes().keySet(), "vcgAn_");
    			intent = new Secondary(  PersnLocalServiceUtil.getLatest( userId ) );
				intent = (Person) CaretParam.loadModel(request, intent, Toolbox.getCollection("lastName","firstName","middleName",
						"birthDate","gender","ssn","phone","phone2","email","groupId"),  CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
				loadPersnAddress( request, intent, CaretStrPool.SECONDARY_PERSN );
				//controller.loadAddress( CaretStrPool.SECONDARY_PERSN, request, intent );
				intent.setRelationship(vcgAn.getSecondaryRelationship());
				((Person)intent).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
				((Person)intent).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
				break;
			case SECONDARYTWO:
				vcgAnId = Long.valueOf( map.get( CaretStrPool.VCGANID) );
				vcgApplication = vcgAnId > 0 ? VcgAnLocalServiceUtil.getVcgAn(vcgAnId) : new VcgAnImpl();
    			vcgAn = (VcgAn) CaretParam.loadModel(request, vcgApplication, vcgApplication.getModelAttributes().keySet(), "vcgAn_");
    			intent = new SecondaryTwo(  PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) ) );
				intent = (Person) CaretParam.loadModel(request, intent, Toolbox.getCollection("lastName","firstName","middleName",
						"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
				//OnlineViewController.get().loadAddress( CaretStrPool.SECONDARY_TWO_PERSN, request, intent );
				loadPersnAddress( request, intent, CaretStrPool.SECONDARY_TWO_PERSN );
				intent.setRelationship(vcgAn.getSecondaryTwoRelationship());
				((Person)intent).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
				((Person)intent).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
				break;
			default: return 0;
			
			}
			
			Docum docum = null;
			//long vcgAnId = 0;
			
			PDDocument pdfDoc = null;
			if ( intent.isVeteranRole() ){
				pdfDoc = PDDocument.load( PdfHandler.getSeedUrl() );
			} else {
				vcgAnId = Long.valueOf( map.get( CaretStrPool.VCGANID) );
				docum = DocumLocalServiceUtil.getAppByOwnerId( vcgAnId );
				if ( docum != null ) { 
					Blob blob = docum.getDocument();
					byte[] binaryData = blob.getBytes(1, (int) blob.length());
					InputStream inputStream = new ByteArrayInputStream(binaryData);
					pdfDoc = PDDocument.load(inputStream);
				}
			}
			
			VaForm1010cgSection form = new VaForm1010cgSection(intent, vcgApplication, pdfDoc );

			PdfHandler pdfHandler = new PdfHandler();
			pdfHandler.setFields(form);
			
			ByteArrayOutputStream outStream = new ByteArrayOutputStream();
			form.getPdfDoc().save( outStream );
			form.getPdfDoc().close();
			outStream.flush();
			
			if ( !pdfHandler.eSigForm( intent, outStream) ){
				_log.error("Could not sign document, there was an error...");
				return 0;
			} else {
				VcgUx vcgUx = null;
				List<VcgUx> applicationUserExperienceList;
				if ( role == Person.Role.VETERAN ) {
					applicationUserExperienceList = VcgUxLocalServiceUtil.findByTentenRole( PortalUtil.getUserId(request), new long[] {role.getId()}, false );
				} else {
					applicationUserExperienceList  = VcgUxLocalServiceUtil.findByApplication( PortalUtil.getUserId(request), vcgAnId);
				}
				if ( applicationUserExperienceList == null || applicationUserExperienceList.isEmpty() ) {
					vcgUx = new VcgUxImpl();
					vcgUx.setCreationDate(new Date());
					vcgUx.setUserId( PortalUtil.getUserId(request) );
					vcgUx.setTentenRoleId( role.getId() );
					vcgUx.setVcgAnId( vcgAnId );
				} else {
					vcgUx = applicationUserExperienceList.get(0);
				}
				
				CaretParam.setOnlineServiceContext(request);

				ByteArrayInputStream in = new ByteArrayInputStream(outStream.toByteArray());
				OutputBlob outputBlob = new OutputBlob ( in, in.available() );
				ServiceContext sc = CaretParam.setOnlineServiceContext(request);
				if ( intent.isVeteranRole() ){
					docum = DocumLocalServiceUtil.createDocum( CounterLocalServiceUtil.increment( Docum.class.getName() ) );
					docum.setDocument( outputBlob );
					docum.setNote( map.get( CaretStrPool.TRACKER ) );
					docum.setType( FileType.TEN_TEN_CG.name() );
					docum.setName( "1010CG_" + intent.getRootUserId() + ".pdf" );
					docum.setClassId( ClassNameLocalServiceUtil.getClassNameId( Dummy.class) );
					DocumLocalServiceUtil.addDocum( docum );
					_log.info("==========created pdf:" + docum.getDocumId() );
				} else {
					docum.setDocument( outputBlob );
					DocumLocalServiceUtil.updateDocum( docum );
					_log.info("==========updated pdf" + docum.getDocumId() );
					saveApplicationVcg(request, map, intent);
				}

				String lastUrl = vcgUx.getUxState();
				lastUrl.replaceAll("signed=false", "signed=true");
				if ( lastUrl.contains("&documId=") ){
					lastUrl = lastUrl.replaceAll(lastUrl.substring(lastUrl.indexOf("&documId="), lastUrl.indexOf("&", lastUrl.indexOf("documId="))), "&documId=" + docum.getDocumId());
					//lastUrl = lastUrl.substring(0, lastUrl.indexOf("&documId=")) + "&documId=" + docum.getDocumId();
				} else {
					lastUrl = lastUrl + "&documId=" + docum.getDocumId();
				}
				_log.info("lastUrl:" + lastUrl);
				vcgUx.setUxState(lastUrl);
				vcgUx.setSigned(true);
				vcgUx.setVcgAnId(vcgAnId);
				VcgUxLocalServiceUtil.updateVcgUx(vcgUx);
				
				return vcgUx.getVcgUxId();
			}
		} catch (COSVisitorException | IOException | PortalException | SystemException | SQLException e2) {
			e2.printStackTrace();
			_log.error("Error for sign");
			return 0;
		}
	}

	@SuppressWarnings({ "unused", "rawtypes", "unchecked" })
	public String loadRoleView ( PortletRequest request, MimeResponse response ) throws PortalException, SystemException{
		
		OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId( request );
		if ( dashboard == null ){
			return CaretBaseViewController.INVALID_ACCESS_VIEW;
		}
		
		long userId = PortalUtil.getUserId( request );
//		long siteId = PortalUtil.getScopeGroupId( request );
		request.setAttribute( "isDemoEnabled", StringPool.TRUE.equals( PortletProps.get(CaretStrPool.DEMO_FEATURES_ENABLED) ) ); 
		PortletSession session = request.getPortletSession();
		
		List<Long> persnRevisionIds = new ArrayList<Long>();
		long persnId = CaretParam.getPersnId(request);
		Person person = null;
		
		Set<Long> caregiverIds = new HashSet<Long>();
		if ( dashboard.isVeteran() ){
			person = new Veteran ( PersnLocalServiceUtil.getPersn( persnId ) );
			for ( Persn persn: person.getPersnSet() ){
				persnRevisionIds.add( persn.getPersnId() );
			}
			if ( !((Veteran)person).isPrimaryAvailable() ){
				caregiverIds.add( ((Veteran)person).getPrimaryId() );
			}
			if ( !((Veteran)person).isSecondaryAvailable() ){
				caregiverIds.add( ((Veteran)person).getSecondaryId() );
			}
			if ( !((Veteran)person).isSecondaryTwoAvailable() ){
				caregiverIds.add( ((Veteran)person).getSecondaryTwoId() );
			}
			OnlineViewController.get().getForm(request).put(CaretStrPool.CAREGIVER_IDS, caregiverIds.size() );
//			request.getPortletSession().setAttribute(CaretStrPool.CAREGIVER_IDS, caregiverIds);
		} else {
			person = new Person ( PersnLocalServiceUtil.getPersn( persnId ) );
			for ( Persn persn: person.getPersnSet() ){
				persnRevisionIds.add( persn.getPersnId() );
			}
		}
		
		Map persnIdMap = Collections.singletonMap(CaretStrPool.PERSN_ID, persnRevisionIds );
		
		int count = CaretLocalServiceUtil.getReportCount (dashboard.getDashboardReport(), persnIdMap);
		
		Map<String,List<?>> results = ResultMap.getResultListMap( request );
		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
		if ( response != null ) {
			Map<String,BaseURL> urlMap = ResultMap.getResultUrlMap( request, response.createRenderURL() );
		}

		request.setAttribute(CaretStrPool.VA_CG_HREF, PortletProps.get(CaretStrPool.VA_CAREGIVER_SITE) );
		
		if ( count == 0 ){
			getForm(request).put(CaretStrPool.SHOW_ALL_TABS, true);
			loadOnlineQuestionaire(request);
			OnlineViewController.get().getForm(request).put(CaretStrPool.CAREGIVER_IDS, 99 );//disables 
		} else {
			total.put( GenericReport.MY_APPLICATIONS, count );
			List[] myApplications = new List[]{CaretLocalServiceUtil.getReport( dashboard.getDashboardReport(), persnIdMap )};
			
			List myVcgStatus;
			if ( dashboard.isVeteran() ){
				myVcgStatus = OnlineUtil.myCaregivers( myApplications[0], request );
			} else {
				getForm(request).put(CaretStrPool.CAREGIVER, true);
				myVcgStatus = OnlineUtil.myVeterans( persnRevisionIds, myApplications, request);

				//results.put( GenericReport.MY_STIPENDS, CaretLocalServiceUtil.getReport( GenericReport.MY_STIPENDS, userId ) );
				//total.put( GenericReport.MY_STIPENDS, CaretLocalServiceUtil.getReportCount( GenericReport.MY_STIPENDS, userId ) );
			}
			
			results.put( GenericReport.MY_APPLICATIONS, myApplications[0] );
			results.put( GenericReport.MY_VCG_STATUS, myVcgStatus );
			total.put( GenericReport.MY_VCG_STATUS, myVcgStatus.size() );
			
			results.put( GenericReport.MY_MESSAGES, CaretLocalServiceUtil.getReport( GenericReport.MY_MESSAGES, Collections.singletonMap(CaretStrPool.PERSN_ID, person.getRootUserId() ) ) );
			total.put( GenericReport.MY_MESSAGES, CaretLocalServiceUtil.getReportCount( GenericReport.MY_MESSAGES , Collections.singletonMap(CaretStrPool.PERSN_ID, person.getRootUserId() ) ) );
		}
		
		return "/jsp/online/" + dashboard.getJsp();
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private void loadOnlineQuestionaire(PortletRequest request) throws ApplicationWorkFlowException {
		
		List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN);
		
		if ( groups.isEmpty() ){
			groups = new ArrayList<BoxGp>();
			int i = 0;
			for ( String subgroup: PortletProps.get( CaretStrPool.ONLINE_QUESTIONAIRE_YN ).split( StringPool.SEMICOLON ) ){
				CaretUtil.initYesNoBoxGp(subgroup, CaretStrPool.ONLINE_QUESTIONAIRE_YN, groups, i);
				i = i + 2;
			}
		}
		
		Map<String, Object> form =  getForm(request);
		
		form.put(CaretStrPool.BOX_GROUP, groups );
		
		Map boxGrp = new CaretMap( false );
		form.put(CaretStrPool.BOX_GROUP_ASSN, boxGrp);
		for ( BgAsn bgAsn0: BoxGpLocalServiceUtil.getBoxGroupAssociations( CaretParam.getPersnId(request), true ) ) {
			boxGrp.put( bgAsn0.getBoxGpId(), true );
		}
		Map<String,List<BoxGp>> boxGpMap = new HashMap<String,List<BoxGp>>();
		int i = 0;
		List boxGpList = new ArrayList(5);
		for ( BoxGp boxGp: groups ){
			boxGpList.add( boxGp );
			if ( i % 2 == 1 ){
				boxGpMap.put( boxGp.getBoxSubGroup(), boxGpList );
				boxGpList = new ArrayList(5);
			}
			i++;
		}
		form.put( CaretStrPool.BOX_GROUP, boxGpMap );
	}
	
	public void cancelApplication ( PortletRequest request ) throws PortalException, SystemException{
		long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID, 0);
		if ( vcgAnId == 0 && request.getAttribute(CaretStrPool.VCGANID) != null){
			vcgAnId = (Long) request.getAttribute(CaretStrPool.VCGANID);
		}
		VcgApplication vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAnId) );
		_log.info( "app status = " + vcgApp.getStatus( ) );
		if ( ApplicationStatus.NEED_SIGNATURE.name().equals( vcgApp.getStatus() ) ){
			vcgApp.setStatus( ApplicationStatus.CANCELLED.name() );
			CaretLocalServiceUtil.save(vcgApp);
			ServiceContext sc = CaretParam.setOnlineServiceContext(request);
			String onlineMessage = LanguageUtil.get( Locale.getDefault(), CaretStrPool.VETERAN_CANCELLED_ONLINE) ;
			if ( vcgApp.getPrimaryId() > 0 ){
				Person person = new Primary( PersnLocalServiceUtil.getPersn( vcgApp.getPrimaryId() ) );
				CaretLocalServiceUtil.addNote( CaretUtil.createNote(sc.getCreateDate(), vcgAnId, 0, 
					person.getRootUserId(), onlineMessage ) );
				vcgApp.setInvalidPerson( person.getPersnId(), onlineMessage );
			}
			if ( vcgApp.getSecondaryId() > 0 ){
				Person person = new Secondary( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryId() ) );
				CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgAnId, 0, 
						person.getRootUserId(), onlineMessage ) );
				vcgApp.setInvalidPerson( person.getPersnId(), onlineMessage );
			}
			if ( vcgApp.getSecondaryTwoId() > 0 ){
				Person person = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApp.getSecondaryTwoId() ) ); 
				CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgAnId, 0, 
						person.getRootUserId(), onlineMessage) );
				vcgApp.setInvalidPerson( person.getPersnId(), onlineMessage );
			}
			Person person = new Veteran( PersnLocalServiceUtil.getPersn( vcgApp.getVeteranId() ) ); 
			CaretLocalServiceUtil.addNote( CaretUtil.createNote( sc.getCreateDate(), vcgAnId, 0, 
					person.getRootUserId(), onlineMessage) );
		}
	}
	
	public void loadCaregiverApplication ( PortletRequest request ){
		try {
			Map<String, Object> form = getForm(request);
			long userId =  PortalUtil.getUserId(request);
			long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID, 0);
			
			VaForm1010cgSection vaForm1010cg = (VaForm1010cgSection)request.getAttribute(CaretStrPool.FORM);
			boolean reload = vaForm1010cg != null;
			
			Persn persn = null;
			persn = PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) );			
			Person formPerson = null;
			if ( reload ){
				formPerson = vaForm1010cg.getIntent();
				vcgAnId = vaForm1010cg.getApplicationId();
			}
			
			if ( vcgAnId == 0 ){ //is-new
				Veteran person;
				formPerson = person = new Veteran( persn );
				
				form.put(CaretStrPool.VETERAN_PERSN, formPerson);
				int slots = 0;
				
				if ( !person.isPrimaryAvailable() ){
					form.put( CaretStrPool.PRIMARY_PERSN, person.getPrimary() );
					slots++;
				}
				if ( !person.isSecondaryAvailable() ){
					form.put( CaretStrPool.SECONDARY_PERSN, person.getSecondary() );
					slots++;
				}
				if ( !person.isSecondaryTwoAvailable() ){
					form.put( CaretStrPool.SECONDARY_TWO_PERSN, person.getSecondaryTwo() );
					slots++;
				}
			}
			
			Map<String,Object> caret = ResultMap.getCaretMap(request);

			caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
			caret.put( CaretStrPool.GENDER_TYPES, PortletProps.get(CaretStrPool.PERSN_GENDER_TYPES).split(StringPool.COMMA) );
			try {
				caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
				caret.put(CaretStrPool.COUNTRIES, CaretUtil.getCountryMap() );
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			String prefix;
			VcgAn vcgApplication;
			form.put(CaretStrPool.VCGANID, vcgAnId);
			if ( reload ){
				vcgApplication = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
				form.put(CaretStrPool.VETERAN_PERSN, PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
				prefix = vaForm1010cg.getIntent().getRole().getLabel() + "Persn";
			} else {
				prefix = CaretStrPool.VETERAN_PERSN;
				if ( vcgAnId > 0 ){  // not-new
					vcgApplication = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
					
					form.put(CaretStrPool.VETERAN_PERSN, PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
					
					if ( vcgApplication.getPrimaryId() > 0 ){
						if ( new Person ( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) ).getRootUserId() == userId ){
							formPerson = new Primary ( PersnLocalServiceUtil.getLatest( userId ) );
						}
					} 
					if ( formPerson == null && vcgApplication.getSecondaryId() > 0 ){
						if ( new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) ).getRootUserId() == userId ){
							formPerson = new Secondary ( PersnLocalServiceUtil.getLatest( userId ) );
						}
					}
					if ( formPerson == null && vcgApplication.getSecondaryTwoId() > 0 ){
						if ( new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) ).getRootUserId() == userId ){
							formPerson = new SecondaryTwo ( PersnLocalServiceUtil.getLatest( userId ) );
						}
					}
					prefix = formPerson.getRole().getLabel() + "Persn";
					
				} else {
					vcgApplication = new VcgAnImpl();
					Object o = request.getAttribute(Veteran.ENROLLED_VA_HEALTH);
					if ( o != null ){
						vcgApplication.setVaHealthEnrolled((Boolean)o);
					}
				}
			}
			List<VcgUx> applicationUserExperienceList = VcgUxLocalServiceUtil.findByTentenRole( PortalUtil.getUserId(request), new long[] {1l}, false);
			VcgUx vcgUx = null;
			if ( applicationUserExperienceList == null || applicationUserExperienceList.isEmpty() ) {
			} else {
				String uxPage = applicationUserExperienceList.get(0).getUxPage();
				boolean reviewed = applicationUserExperienceList.get(0).getReviewed();
				boolean signed = applicationUserExperienceList.get(0).getSigned();
				boolean complete = applicationUserExperienceList.get(0).getComplete();
				vcgAnId = applicationUserExperienceList.get(0).getVcgAnId();
				caret.put("tabContext", uxPage.substring(uxPage.indexOf('_') + 1 ) );
				caret.put("reviewed", reviewed );
				caret.put("signed", signed );
				caret.put("complete", complete );
				caret.put(CaretStrPool.VCGANID,  Long.toString(vcgAnId));
				try {
					Map<String,String> map = Toolbox.getUrlQuery(applicationUserExperienceList.get(0).getUxState());
					caret.put("documId", map.get("documId"));					
					vcgApplication = (VcgApplication) 
							CaretParam.loadModel(map, 
									new VcgApplication( new VcgAnImpl() ), 
									Toolbox.getCollection("lastTreatmentPlace","hospital","clinic","vaHealthEnrolled","primaryId","secondaryId","secondaryTwoId"), 
									CaretStrPool.VCGAN_UNDERLINE);
					
					
					
					formPerson = (Veteran) CaretParam.loadModel(map, new Veteran( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
							"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.VETERAN_PERSN_UNDERLINE);
					loadAddress( CaretStrPool.VETERAN_PERSN, map, formPerson );
					((Veteran)formPerson).setVaHealthEnrolled( vcgApplication.getVaHealthEnrolled() );
					if (!map.get("vcgAn_primaryId").isEmpty()) {
						Persn primaryPersn = PersnLocalServiceUtil.getPersn(Long.parseLong(map.get("vcgAn_primaryId")));
						form.put( "primaryPersnSaved", primaryPersn );
					}
					if (!map.get("vcgAn_secondaryId").isEmpty()) {
						Persn secondaryPersn = PersnLocalServiceUtil.getPersn(Long.parseLong(map.get("vcgAn_secondaryId")));
						form.put( "secondaryPersnSaved", secondaryPersn );
					}
					if (!map.get("vcgAn_secondaryTwoId").isEmpty()) {
						Persn secondaryTwoPersn = PersnLocalServiceUtil.getPersn( Long.parseLong(map.get("vcgAn_secondaryTwoId") ) );
						form.put( "secondaryTwoPersnSaved", secondaryTwoPersn );
					}
						
				} catch (Exception e) {
					e.printStackTrace();
				}
				
			}
			
			form.put( prefix, formPerson );
			form.put( CaretStrPool.VCGAN, vcgApplication );
			if ( vcgAnId > 0 ){
				String relationshipNotFamily = PortletProps.get(CaretStrPool.RELATIONSHIP_NOT_FAMILY);
				String relationshipFamily = PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY);
				if ( !relationshipNotFamily.isEmpty() ){
					
					java.util.List c = Arrays.asList( (relationshipNotFamily + StringPool.COMMA + relationshipFamily).split(StringPool.COMMA) );
					Collections.sort( c );
					caret.put(CaretStrPool.RELATIONSHIP, c );
				}
			}
			loadRequiredInputs( prefix, form );
			loadAddress(caret, formPerson, prefix);
			loadFlexWidgetConfig(request);
			
			
			try {
				String extensions = StringUtil.merge(PrefsPropsUtil.getStringArray(PropsKeys.DL_FILE_EXTENSIONS, StringPool.COMMA));
//				dl.file.max.size
				long maxSize = Long.parseLong(PrefsPropsUtil.getString(PropsKeys.DL_FILE_MAX_SIZE)) / 1024;
				_log.info("extensions = " + extensions + ", maxSize=" + maxSize );
				form.put("extensions",  extensions );
				form.put("maxSize",  maxSize );
				
			} catch (NumberFormatException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			request.setAttribute(CaretStrPool.MVC_PATH, formPerson.getOnlineView() );
			caret.put( CaretStrPool.SEARCH_CSS, SearchController.getSearchCss() );
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	

	public void loadApplication ( PortletRequest request ){
		try {
			Map<String, Object> form = getForm(request);
			long userId =  PortalUtil.getUserId(request);
			long vcgAnId = ParamUtil.getLong(request, CaretStrPool.VCGANID, 0);
			
			VaForm1010cgSection vaForm1010cg = (VaForm1010cgSection)request.getAttribute(CaretStrPool.FORM);
			boolean reload = vaForm1010cg != null;
			
			Persn persn = null;
			persn = PersnLocalServiceUtil.getLatest( PortalUtil.getUserId(request) );			
			Person formPerson = null;
			if ( reload ){
				formPerson = vaForm1010cg.getIntent();
				vcgAnId = vaForm1010cg.getApplicationId();
			}
			
			if ( vcgAnId == 0 ){ //is-new
				Veteran person;
				formPerson = person = new Veteran( persn );
				
				form.put(CaretStrPool.VETERAN_PERSN, formPerson);
				int slots = 0;
				
				if ( !person.isPrimaryAvailable() ){
					form.put( CaretStrPool.PRIMARY_PERSN, person.getPrimary() );
					slots++;
				}
				if ( !person.isSecondaryAvailable() ){
					form.put( CaretStrPool.SECONDARY_PERSN, person.getSecondary() );
					slots++;
				}
				if ( !person.isSecondaryTwoAvailable() ){
					form.put( CaretStrPool.SECONDARY_TWO_PERSN, person.getSecondaryTwo() );
					slots++;
				}
			}
			
			Map<String,Object> caret = ResultMap.getCaretMap(request);

//			caret.put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
			caret.put( CaretStrPool.GENDER_TYPES, PortletProps.get(CaretStrPool.PERSN_GENDER_TYPES).split(StringPool.COMMA) );
			try {
				caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
				caret.put(CaretStrPool.COUNTRIES, CaretUtil.getCountryMap() );
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			String prefix;
			VcgAn vcgApplication;
			form.put(CaretStrPool.VCGANID, vcgAnId);
			if ( reload ){
				vcgApplication = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
				form.put(CaretStrPool.VETERAN_PERSN, PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
				prefix = vaForm1010cg.getIntent().getRole().getLabel() + "Persn";
			} else {
				prefix = CaretStrPool.VETERAN_PERSN;
				if ( vcgAnId > 0 ){  // not-new
					vcgApplication = VcgAnLocalServiceUtil.getVcgAn(vcgAnId);
					
					form.put(CaretStrPool.VETERAN_PERSN, PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
					
					if ( vcgApplication.getPrimaryId() > 0 ){
						if ( new Person ( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) ).getRootUserId() == userId ){
							formPerson = new Primary ( PersnLocalServiceUtil.getLatest( userId ) );
							form.put(CaretStrPool.CAREGIVER_CATEGORY, CaretStrPool.PRIMARY);
							form.put(CaretStrPool.ROLE_ID, Person.Role.PRIMARY.getId());
						}
					} 
					if ( formPerson == null && vcgApplication.getSecondaryId() > 0 ){
						if ( new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) ).getRootUserId() == userId ){
							formPerson = new Secondary ( PersnLocalServiceUtil.getLatest( userId ) );
							form.put(CaretStrPool.CAREGIVER_CATEGORY, CaretStrPool.SECONDARY);
							form.put(CaretStrPool.ROLE_ID, Person.Role.SECONDARY.getId());
						}
					}
					if ( formPerson == null && vcgApplication.getSecondaryTwoId() > 0 ){
						if ( new Person( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) ).getRootUserId() == userId ){
							formPerson = new SecondaryTwo ( PersnLocalServiceUtil.getLatest( userId ) );
							form.put(CaretStrPool.CAREGIVER_CATEGORY, CaretStrPool.SECONDARYTWO);
							form.put(CaretStrPool.ROLE_ID, Person.Role.SECONDARYTWO.getId());
						}
					}
					prefix = formPerson.getRole().getLabel() + "Persn";
					
				} else {
					vcgApplication = new VcgAnImpl();
					Object o = request.getAttribute(Veteran.ENROLLED_VA_HEALTH);
					if ( o != null ){
						vcgApplication.setVaHealthEnrolled((Boolean)o);
					}
				}
			}
			OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId(request );
			if (dashboard.isVeteran()) {
				List<VcgUx> applicationUserExperienceList = VcgUxLocalServiceUtil.findByTentenRole( PortalUtil.getUserId(request), new long[] {1l}, false);
				VcgUx vcgUx = null;
				if ( applicationUserExperienceList == null || applicationUserExperienceList.isEmpty() ) {
				} else {
					String uxPage = applicationUserExperienceList.get(0).getUxPage();
					boolean reviewed = applicationUserExperienceList.get(0).getReviewed();
					boolean signed = applicationUserExperienceList.get(0).getSigned();
					boolean complete = applicationUserExperienceList.get(0).getComplete();
					vcgAnId = applicationUserExperienceList.get(0).getVcgAnId();
					caret.put("tabContext", uxPage.substring(uxPage.indexOf('_') + 1 ) );
					caret.put("reviewed", reviewed );
					caret.put("signed", signed );
					caret.put("complete", complete );
					caret.put(CaretStrPool.VCGANID,  Long.toString(vcgAnId));
					try {
						Map<String,String> map = Toolbox.getUrlQuery(applicationUserExperienceList.get(0).getUxState());
						caret.put("documId", map.get("documId"));					
						vcgApplication = (VcgApplication) 
								CaretParam.loadModel(map, 
										new VcgApplication( new VcgAnImpl() ), 
										Toolbox.getCollection("lastTreatmentPlace","hospital","clinic","vaHealthEnrolled","primaryId","secondaryId","secondaryTwoId"), 
										CaretStrPool.VCGAN_UNDERLINE);
						
						
						
						formPerson = (Veteran) CaretParam.loadModel(map, new Veteran( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
								"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.VETERAN_PERSN_UNDERLINE);
						loadAddress( CaretStrPool.VETERAN_PERSN, map, formPerson );
						((Veteran)formPerson).setVaHealthEnrolled( vcgApplication.getVaHealthEnrolled() );
						if (!map.get("vcgAn_primaryId").isEmpty()) {
							Persn primaryPersn = PersnLocalServiceUtil.getPersn(Long.parseLong(map.get("vcgAn_primaryId")));
							form.put( "primaryPersnSaved", primaryPersn );
						}
						if (!map.get("vcgAn_secondaryId").isEmpty()) {
							Persn secondaryPersn = PersnLocalServiceUtil.getPersn(Long.parseLong(map.get("vcgAn_secondaryId")));
							form.put( "secondaryPersnSaved", secondaryPersn );
						}
						if (!map.get("vcgAn_secondaryTwoId").isEmpty()) {
							Persn secondaryTwoPersn = PersnLocalServiceUtil.getPersn( Long.parseLong(map.get("vcgAn_secondaryTwoId") ) );
							form.put( "secondaryTwoPersnSaved", secondaryTwoPersn );
						}
							
					} catch (Exception e) {
						e.printStackTrace();
					}
					
				}
			}		
			form.put( prefix, formPerson );
			form.put(CaretStrPool.NDX, prefix);
			form.put( CaretStrPool.VCGAN, vcgApplication );
			if ( vcgAnId > 0 ){
				loadRelationshipLists(request);
			}
			loadRequiredInputs( prefix, form );
			loadAddress(caret, formPerson, prefix);
			loadFlexWidgetConfig(request);
			
			
			try {
				String extensions = StringUtil.merge(PrefsPropsUtil.getStringArray(PropsKeys.DL_FILE_EXTENSIONS, StringPool.COMMA));
//				dl.file.max.size
				long maxSize = Long.parseLong(PrefsPropsUtil.getString(PropsKeys.DL_FILE_MAX_SIZE)) / 1024;
				_log.info("extensions = " + extensions + ", maxSize=" + maxSize );
				form.put("extensions",  extensions );
				form.put("maxSize",  maxSize );
				
			} catch (NumberFormatException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			
			request.setAttribute(CaretStrPool.MVC_PATH, formPerson.getOnlineView() );
			caret.put( CaretStrPool.SEARCH_CSS, SearchController.getSearchCss() );
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public void loadRelationshipLists ( PortletRequest request ) {
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		if ( CAction.canDoCaret( request, CAction.CaretCan.CSL_FAMILY_RELATIONSHIPS.name() ) ){
			caret.put( CaretStrPool.RELATIONSHIP_NOT_FAMILY, PortletProps.get(CaretStrPool.CSL_RELATIONSHIP_NOT_FAMILY).split(StringPool.COMMA) );
			caret.put( CaretStrPool.RELATIONSHIP_FAMILY, PortletProps.get(CaretStrPool.CSL_RELATIONSHIP_FAMILY).split(StringPool.COMMA) );
		} else {
			caret.put( CaretStrPool.RELATIONSHIP_NOT_FAMILY, PortletProps.get(CaretStrPool.RELATIONSHIP_NOT_FAMILY).split(StringPool.COMMA) );
			caret.put( CaretStrPool.RELATIONSHIP_FAMILY, PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY).split(StringPool.COMMA) );
		}
	}
	
	public void loadRequiredInputs( String persn, Map<String, Object> form) {
		
		Map<String,Object> required = new CaretMap<String,Object>(StringPool.BLANK);
		form.put("required", required);
		
		if ( CaretStrPool.VETERAN_PERSN.toString().equalsIgnoreCase(persn)){
			for ( String key : PortletProps.get("required.veteran.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.PRIMARY_PERSN.toString().equalsIgnoreCase(persn)){
			for ( String key : PortletProps.get("required.primary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};		
		} else if ( CaretStrPool.SECONDARY_PERSN.toString().equalsIgnoreCase(persn)){
			for ( String key : PortletProps.get("required.secondary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.SECONDARY_TWO_PERSN.toString().equalsIgnoreCase(persn)){
			for ( String key : PortletProps.get("required.secondaryTwo.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		}
	}
	
	public boolean validateRequired( String context, PortletRequest request ){
		return true;
	}

	
}
