package gov.va.caret.controller;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.AddressPerson;
import gov.va.caret.model.support.Person;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.ResultMap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;



public abstract class CaretBaseViewController {
	
	public static final String INVALID_ACCESS_VIEW = "/jsp/online/view.jsp";
	public static final String INVALID_ACCESS_CLIN = "/jsp/internal/view.jsp";
	public static final String VERSION_VIEW = "/jsp/version.jsp";
	public static final String PRINT_VIEW = "/jsp/tools/printInclude.jsp";
	public static final String ONLINE_VIEW = "/jsp/online/";
	public static final String INTERNAL_VIEW = "/jsp/internal/";
	public static final String JSP_EXT = ".jsp";

	public abstract String loadDefaultView( PortletRequest request, MimeResponse response );
	public abstract boolean validateRequired( String context, PortletRequest request );
	public abstract void loadRequiredInputs( String context, Map<String, Object> form );
	
	public Map<String,Object> getForm( PortletRequest request ) {
		return ResultMap.getForm (request);
	}
	
	public void loadPersnAddress(PortletRequest request, Person persn, String prefix) throws ApplicationWorkFlowException {

		if ( StringPool.FALSE.equals( persn.getCountry() ) || StringPool.BLANK.equals( persn.getCountry() ) ){ // USA
			CaretParam.loadModel(request, persn, Toolbox.getAddressCollection(), prefix + CaretStrPool.U_UNDERLINE);
			// persn.setValidAddress(false);
		} else { // World
			CaretParam.loadModel(request, persn, Toolbox.getAddressCollection(), prefix + CaretStrPool.G_UNDERLINE);
		}
		persn.setCountry( ParamUtil.get(request, prefix+"_country" , StringPool.BLANK) );
		persn.setAddress(request.getParameter(prefix +  CaretStrPool._ADDRESS));
	}
	
	public void loadPersnAddress(Map<String,String> map, Person persn, String prefix) throws ApplicationWorkFlowException {

		if ( StringPool.FALSE.equals( persn.getCountry() ) || StringPool.BLANK.equals( persn.getCountry() ) || "USA".equals( persn.getCountry() ) ){ // USA
			CaretParam.loadModel(map, persn, Toolbox.getAddressCollection(), prefix + CaretStrPool.U_UNDERLINE);
			persn.setValidAddress(false);
		} else { // World
			CaretParam.loadModel(map, persn, Toolbox.getAddressCollection(), prefix + CaretStrPool.G_UNDERLINE);
		}
		persn.setCountry( map.get( prefix+"_country" ) );
		persn.setAddress(map.get(prefix +  CaretStrPool._ADDRESS));
	}
	
	public void loadAddress ( Map<String, Object> caret, AddressPerson person, String prefix) throws ApplicationWorkFlowException {
		if ( person.getState() != null ){ //   veteranPersn_blsCities
			caret.put( prefix + CaretStrPool._BLS_CITIES, CaretLocalServiceUtil.getReport( CaretStrPool.CITY_REPORT, person.getState() ) );
			if ( person.getCity() != null ){
				List<Map<String, Object>> list = CaretLocalServiceUtil.getReport( CaretStrPool.ZIP_REPORT, person.getCity() );
				List<String> formatted = new ArrayList<String>();
				for ( Map<String, Object> cont : list ){
					formatted.add( Toolbox.formatZip( cont.get(CaretStrPool.NDX0) ) );
				}
				Collections.sort(formatted);
				
				caret.put( prefix + CaretStrPool._BLS_ZIPS, formatted );
			}
		}
	}
	
	private String caretVersion = null;
	
	public String getVersion( ) {
		
		if ( caretVersion == null ){
			try{
				caretVersion = MessageFormat.format(LanguageUtil.get( Locale.getDefault(), CaretStrPool.BUILD_INFO),
												PortletProps.get(CaretStrPool.BUILD_VERSION),
												PortletProps.get(CaretStrPool.CARET_DATE));
			} catch ( IllegalArgumentException e){
				ApplicationWorkFlowException.handleException(e, "Could not load version");
				caretVersion = StringPool.BLANK;
			}
		}
		return caretVersion;
		
	}
	
	
}
