package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.ZipFy;

/**
 * The persistence interface for the zip fy service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see ZipFyPersistenceImpl
 * @see ZipFyUtil
 * @generated
 */
public interface ZipFyPersistence extends BasePersistence<ZipFy> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link ZipFyUtil} to access the zip fy persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the zip fies where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @return the matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ZipFy> findByZip(
        java.lang.String facilZip)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the zip fies where facilZip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param facilZip the facil zip
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @return the range of matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ZipFy> findByZip(
        java.lang.String facilZip, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the zip fies where facilZip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param facilZip the facil zip
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ZipFy> findByZip(
        java.lang.String facilZip, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy findByZip_First(java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException;

    /**
    * Returns the first zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching zip fy, or <code>null</code> if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy fetchByZip_First(
        java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy findByZip_Last(java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException;

    /**
    * Returns the last zip fy in the ordered set where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching zip fy, or <code>null</code> if a matching zip fy could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy fetchByZip_Last(java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the zip fies before and after the current zip fy in the ordered set where facilZip = &#63;.
    *
    * @param zipFyId the primary key of the current zip fy
    * @param facilZip the facil zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy[] findByZip_PrevAndNext(long zipFyId,
        java.lang.String facilZip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException;

    /**
    * Removes all the zip fies where facilZip = &#63; from the database.
    *
    * @param facilZip the facil zip
    * @throws SystemException if a system exception occurred
    */
    public void removeByZip(java.lang.String facilZip)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of zip fies where facilZip = &#63;.
    *
    * @param facilZip the facil zip
    * @return the number of matching zip fies
    * @throws SystemException if a system exception occurred
    */
    public int countByZip(java.lang.String facilZip)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the zip fy in the entity cache if it is enabled.
    *
    * @param zipFy the zip fy
    */
    public void cacheResult(gov.va.caret.model.ZipFy zipFy);

    /**
    * Caches the zip fies in the entity cache if it is enabled.
    *
    * @param zipFies the zip fies
    */
    public void cacheResult(java.util.List<gov.va.caret.model.ZipFy> zipFies);

    /**
    * Creates a new zip fy with the primary key. Does not add the zip fy to the database.
    *
    * @param zipFyId the primary key for the new zip fy
    * @return the new zip fy
    */
    public gov.va.caret.model.ZipFy create(long zipFyId);

    /**
    * Removes the zip fy with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param zipFyId the primary key of the zip fy
    * @return the zip fy that was removed
    * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy remove(long zipFyId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException;

    public gov.va.caret.model.ZipFy updateImpl(gov.va.caret.model.ZipFy zipFy)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the zip fy with the primary key or throws a {@link gov.va.caret.NoSuchZipFyException} if it could not be found.
    *
    * @param zipFyId the primary key of the zip fy
    * @return the zip fy
    * @throws gov.va.caret.NoSuchZipFyException if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy findByPrimaryKey(long zipFyId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchZipFyException;

    /**
    * Returns the zip fy with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param zipFyId the primary key of the zip fy
    * @return the zip fy, or <code>null</code> if a zip fy with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ZipFy fetchByPrimaryKey(long zipFyId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the zip fies.
    *
    * @return the zip fies
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ZipFy> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the zip fies.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @return the range of zip fies
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ZipFy> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the zip fies.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ZipFyModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of zip fies
    * @param end the upper bound of the range of zip fies (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of zip fies
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ZipFy> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the zip fies from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of zip fies.
    *
    * @return the number of zip fies
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
