package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Vendr;

import java.util.List;

/**
 * The persistence utility for the vendr service. This utility wraps {@link VendrPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VendrPersistence
 * @see VendrPersistenceImpl
 * @generated
 */
public class VendrUtil {
    private static VendrPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Vendr vendr) {
        getPersistence().clearCache(vendr);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Vendr> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Vendr> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Vendr> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Vendr update(Vendr vendr) throws SystemException {
        return getPersistence().update(vendr);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Vendr update(Vendr vendr, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(vendr, serviceContext);
    }

    /**
    * Returns all the vendrs where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @return the matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByFedTaxId(
        java.lang.String fedTaxId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByFedTaxId(fedTaxId);
    }

    /**
    * Returns a range of all the vendrs where fedTaxId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param fedTaxId the fed tax ID
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByFedTaxId(
        java.lang.String fedTaxId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByFedTaxId(fedTaxId, start, end);
    }

    /**
    * Returns an ordered range of all the vendrs where fedTaxId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param fedTaxId the fed tax ID
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByFedTaxId(
        java.lang.String fedTaxId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByFedTaxId(fedTaxId, start, end, orderByComparator);
    }

    /**
    * Returns the first vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr findByFedTaxId_First(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence().findByFedTaxId_First(fedTaxId, orderByComparator);
    }

    /**
    * Returns the first vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr fetchByFedTaxId_First(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByFedTaxId_First(fedTaxId, orderByComparator);
    }

    /**
    * Returns the last vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr findByFedTaxId_Last(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence().findByFedTaxId_Last(fedTaxId, orderByComparator);
    }

    /**
    * Returns the last vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr fetchByFedTaxId_Last(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByFedTaxId_Last(fedTaxId, orderByComparator);
    }

    /**
    * Returns the vendrs before and after the current vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param vendrId the primary key of the current vendr
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr[] findByFedTaxId_PrevAndNext(
        long vendrId, java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence()
                   .findByFedTaxId_PrevAndNext(vendrId, fedTaxId,
            orderByComparator);
    }

    /**
    * Removes all the vendrs where fedTaxId = &#63; from the database.
    *
    * @param fedTaxId the fed tax ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByFedTaxId(java.lang.String fedTaxId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByFedTaxId(fedTaxId);
    }

    /**
    * Returns the number of vendrs where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @return the number of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static int countByFedTaxId(java.lang.String fedTaxId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByFedTaxId(fedTaxId);
    }

    /**
    * Returns all the vendrs where lastName = &#63;.
    *
    * @param lastName the last name
    * @return the matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByLastName(
        java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByLastName(lastName);
    }

    /**
    * Returns a range of all the vendrs where lastName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param lastName the last name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByLastName(
        java.lang.String lastName, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByLastName(lastName, start, end);
    }

    /**
    * Returns an ordered range of all the vendrs where lastName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param lastName the last name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByLastName(
        java.lang.String lastName, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByLastName(lastName, start, end, orderByComparator);
    }

    /**
    * Returns the first vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr findByLastName_First(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence().findByLastName_First(lastName, orderByComparator);
    }

    /**
    * Returns the first vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr fetchByLastName_First(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByLastName_First(lastName, orderByComparator);
    }

    /**
    * Returns the last vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr findByLastName_Last(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence().findByLastName_Last(lastName, orderByComparator);
    }

    /**
    * Returns the last vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr fetchByLastName_Last(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByLastName_Last(lastName, orderByComparator);
    }

    /**
    * Returns the vendrs before and after the current vendr in the ordered set where lastName = &#63;.
    *
    * @param vendrId the primary key of the current vendr
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr[] findByLastName_PrevAndNext(
        long vendrId, java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence()
                   .findByLastName_PrevAndNext(vendrId, lastName,
            orderByComparator);
    }

    /**
    * Removes all the vendrs where lastName = &#63; from the database.
    *
    * @param lastName the last name
    * @throws SystemException if a system exception occurred
    */
    public static void removeByLastName(java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByLastName(lastName);
    }

    /**
    * Returns the number of vendrs where lastName = &#63;.
    *
    * @param lastName the last name
    * @return the number of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static int countByLastName(java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByLastName(lastName);
    }

    /**
    * Returns all the vendrs where firstName = &#63;.
    *
    * @param firstName the first name
    * @return the matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByFirstName(
        java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByFirstName(firstName);
    }

    /**
    * Returns a range of all the vendrs where firstName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param firstName the first name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByFirstName(
        java.lang.String firstName, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByFirstName(firstName, start, end);
    }

    /**
    * Returns an ordered range of all the vendrs where firstName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param firstName the first name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findByFirstName(
        java.lang.String firstName, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByFirstName(firstName, start, end, orderByComparator);
    }

    /**
    * Returns the first vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr findByFirstName_First(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence()
                   .findByFirstName_First(firstName, orderByComparator);
    }

    /**
    * Returns the first vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr fetchByFirstName_First(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByFirstName_First(firstName, orderByComparator);
    }

    /**
    * Returns the last vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr findByFirstName_Last(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence()
                   .findByFirstName_Last(firstName, orderByComparator);
    }

    /**
    * Returns the last vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr fetchByFirstName_Last(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByFirstName_Last(firstName, orderByComparator);
    }

    /**
    * Returns the vendrs before and after the current vendr in the ordered set where firstName = &#63;.
    *
    * @param vendrId the primary key of the current vendr
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr[] findByFirstName_PrevAndNext(
        long vendrId, java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence()
                   .findByFirstName_PrevAndNext(vendrId, firstName,
            orderByComparator);
    }

    /**
    * Removes all the vendrs where firstName = &#63; from the database.
    *
    * @param firstName the first name
    * @throws SystemException if a system exception occurred
    */
    public static void removeByFirstName(java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByFirstName(firstName);
    }

    /**
    * Returns the number of vendrs where firstName = &#63;.
    *
    * @param firstName the first name
    * @return the number of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public static int countByFirstName(java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByFirstName(firstName);
    }

    /**
    * Caches the vendr in the entity cache if it is enabled.
    *
    * @param vendr the vendr
    */
    public static void cacheResult(gov.va.caret.model.Vendr vendr) {
        getPersistence().cacheResult(vendr);
    }

    /**
    * Caches the vendrs in the entity cache if it is enabled.
    *
    * @param vendrs the vendrs
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Vendr> vendrs) {
        getPersistence().cacheResult(vendrs);
    }

    /**
    * Creates a new vendr with the primary key. Does not add the vendr to the database.
    *
    * @param vendrId the primary key for the new vendr
    * @return the new vendr
    */
    public static gov.va.caret.model.Vendr create(long vendrId) {
        return getPersistence().create(vendrId);
    }

    /**
    * Removes the vendr with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param vendrId the primary key of the vendr
    * @return the vendr that was removed
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr remove(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence().remove(vendrId);
    }

    public static gov.va.caret.model.Vendr updateImpl(
        gov.va.caret.model.Vendr vendr)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(vendr);
    }

    /**
    * Returns the vendr with the primary key or throws a {@link gov.va.caret.NoSuchVendrException} if it could not be found.
    *
    * @param vendrId the primary key of the vendr
    * @return the vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr findByPrimaryKey(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException {
        return getPersistence().findByPrimaryKey(vendrId);
    }

    /**
    * Returns the vendr with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param vendrId the primary key of the vendr
    * @return the vendr, or <code>null</code> if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Vendr fetchByPrimaryKey(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(vendrId);
    }

    /**
    * Returns all the vendrs.
    *
    * @return the vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the vendrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the vendrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of vendrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Vendr> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the vendrs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of vendrs.
    *
    * @return the number of vendrs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static VendrPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (VendrPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    VendrPersistence.class.getName());

            ReferenceRegistry.registerReference(VendrUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(VendrPersistence persistence) {
    }
}
