package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.PayLg;

import java.util.List;

/**
 * The persistence utility for the pay lg service. This utility wraps {@link PayLgPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PayLgPersistence
 * @see PayLgPersistenceImpl
 * @generated
 */
public class PayLgUtil {
    private static PayLgPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(PayLg payLg) {
        getPersistence().clearCache(payLg);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<PayLg> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<PayLg> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<PayLg> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static PayLg update(PayLg payLg) throws SystemException {
        return getPersistence().update(payLg);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static PayLg update(PayLg payLg, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(payLg, serviceContext);
    }

    /**
    * Returns all the pay lgs where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @return the matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findByPaymentDate(
        java.util.Date paymentDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByPaymentDate(paymentDate);
    }

    /**
    * Returns a range of all the pay lgs where paymentDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param paymentDate the payment date
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @return the range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findByPaymentDate(
        java.util.Date paymentDate, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByPaymentDate(paymentDate, start, end);
    }

    /**
    * Returns an ordered range of all the pay lgs where paymentDate = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param paymentDate the payment date
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findByPaymentDate(
        java.util.Date paymentDate, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByPaymentDate(paymentDate, start, end, orderByComparator);
    }

    /**
    * Returns the first pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg findByPaymentDate_First(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence()
                   .findByPaymentDate_First(paymentDate, orderByComparator);
    }

    /**
    * Returns the first pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg fetchByPaymentDate_First(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByPaymentDate_First(paymentDate, orderByComparator);
    }

    /**
    * Returns the last pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg findByPaymentDate_Last(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence()
                   .findByPaymentDate_Last(paymentDate, orderByComparator);
    }

    /**
    * Returns the last pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg fetchByPaymentDate_Last(
        java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByPaymentDate_Last(paymentDate, orderByComparator);
    }

    /**
    * Returns the pay lgs before and after the current pay lg in the ordered set where paymentDate = &#63;.
    *
    * @param paymentLogId the primary key of the current pay lg
    * @param paymentDate the payment date
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg[] findByPaymentDate_PrevAndNext(
        long paymentLogId, java.util.Date paymentDate,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence()
                   .findByPaymentDate_PrevAndNext(paymentLogId, paymentDate,
            orderByComparator);
    }

    /**
    * Removes all the pay lgs where paymentDate = &#63; from the database.
    *
    * @param paymentDate the payment date
    * @throws SystemException if a system exception occurred
    */
    public static void removeByPaymentDate(java.util.Date paymentDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByPaymentDate(paymentDate);
    }

    /**
    * Returns the number of pay lgs where paymentDate = &#63;.
    *
    * @param paymentDate the payment date
    * @return the number of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static int countByPaymentDate(java.util.Date paymentDate)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByPaymentDate(paymentDate);
    }

    /**
    * Returns all the pay lgs where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @return the matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findByStiPtId(
        long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByStiPtId(stiPtId);
    }

    /**
    * Returns a range of all the pay lgs where stiPtId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiPtId the sti pt ID
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @return the range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findByStiPtId(
        long stiPtId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByStiPtId(stiPtId, start, end);
    }

    /**
    * Returns an ordered range of all the pay lgs where stiPtId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param stiPtId the sti pt ID
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findByStiPtId(
        long stiPtId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByStiPtId(stiPtId, start, end, orderByComparator);
    }

    /**
    * Returns the first pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg findByStiPtId_First(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence().findByStiPtId_First(stiPtId, orderByComparator);
    }

    /**
    * Returns the first pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg fetchByStiPtId_First(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByStiPtId_First(stiPtId, orderByComparator);
    }

    /**
    * Returns the last pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg findByStiPtId_Last(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence().findByStiPtId_Last(stiPtId, orderByComparator);
    }

    /**
    * Returns the last pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching pay lg, or <code>null</code> if a matching pay lg could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg fetchByStiPtId_Last(long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByStiPtId_Last(stiPtId, orderByComparator);
    }

    /**
    * Returns the pay lgs before and after the current pay lg in the ordered set where stiPtId = &#63;.
    *
    * @param paymentLogId the primary key of the current pay lg
    * @param stiPtId the sti pt ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg[] findByStiPtId_PrevAndNext(
        long paymentLogId, long stiPtId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence()
                   .findByStiPtId_PrevAndNext(paymentLogId, stiPtId,
            orderByComparator);
    }

    /**
    * Removes all the pay lgs where stiPtId = &#63; from the database.
    *
    * @param stiPtId the sti pt ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByStiPtId(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByStiPtId(stiPtId);
    }

    /**
    * Returns the number of pay lgs where stiPtId = &#63;.
    *
    * @param stiPtId the sti pt ID
    * @return the number of matching pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static int countByStiPtId(long stiPtId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByStiPtId(stiPtId);
    }

    /**
    * Caches the pay lg in the entity cache if it is enabled.
    *
    * @param payLg the pay lg
    */
    public static void cacheResult(gov.va.caret.model.PayLg payLg) {
        getPersistence().cacheResult(payLg);
    }

    /**
    * Caches the pay lgs in the entity cache if it is enabled.
    *
    * @param payLgs the pay lgs
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.PayLg> payLgs) {
        getPersistence().cacheResult(payLgs);
    }

    /**
    * Creates a new pay lg with the primary key. Does not add the pay lg to the database.
    *
    * @param paymentLogId the primary key for the new pay lg
    * @return the new pay lg
    */
    public static gov.va.caret.model.PayLg create(long paymentLogId) {
        return getPersistence().create(paymentLogId);
    }

    /**
    * Removes the pay lg with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param paymentLogId the primary key of the pay lg
    * @return the pay lg that was removed
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg remove(long paymentLogId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence().remove(paymentLogId);
    }

    public static gov.va.caret.model.PayLg updateImpl(
        gov.va.caret.model.PayLg payLg)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(payLg);
    }

    /**
    * Returns the pay lg with the primary key or throws a {@link gov.va.caret.NoSuchPayLgException} if it could not be found.
    *
    * @param paymentLogId the primary key of the pay lg
    * @return the pay lg
    * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg findByPrimaryKey(long paymentLogId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchPayLgException {
        return getPersistence().findByPrimaryKey(paymentLogId);
    }

    /**
    * Returns the pay lg with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param paymentLogId the primary key of the pay lg
    * @return the pay lg, or <code>null</code> if a pay lg with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.PayLg fetchByPrimaryKey(long paymentLogId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(paymentLogId);
    }

    /**
    * Returns all the pay lgs.
    *
    * @return the pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the pay lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @return the range of pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the pay lgs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of pay lgs
    * @param end the upper bound of the range of pay lgs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.PayLg> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the pay lgs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of pay lgs.
    *
    * @return the number of pay lgs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static PayLgPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (PayLgPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    PayLgPersistence.class.getName());

            ReferenceRegistry.registerReference(PayLgUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(PayLgPersistence persistence) {
    }
}
