package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Facil;

import java.util.List;

/**
 * The persistence utility for the facil service. This utility wraps {@link FacilPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see FacilPersistence
 * @see FacilPersistenceImpl
 * @generated
 */
public class FacilUtil {
    private static FacilPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Facil facil) {
        getPersistence().clearCache(facil);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Facil> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Facil> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Facil> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Facil update(Facil facil) throws SystemException {
        return getPersistence().update(facil);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Facil update(Facil facil, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(facil, serviceContext);
    }

    /**
    * Returns the facil where groupId = &#63; or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
    *
    * @param groupId the group ID
    * @return the matching facil
    * @throws gov.va.caret.NoSuchFacilException if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil findByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException {
        return getPersistence().findByGroupId(groupId);
    }

    /**
    * Returns the facil where groupId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param groupId the group ID
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil fetchByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByGroupId(groupId);
    }

    /**
    * Returns the facil where groupId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param groupId the group ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil fetchByGroupId(long groupId,
        boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByGroupId(groupId, retrieveFromCache);
    }

    /**
    * Removes the facil where groupId = &#63; from the database.
    *
    * @param groupId the group ID
    * @return the facil that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil removeByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException {
        return getPersistence().removeByGroupId(groupId);
    }

    /**
    * Returns the number of facils where groupId = &#63;.
    *
    * @param groupId the group ID
    * @return the number of matching facils
    * @throws SystemException if a system exception occurred
    */
    public static int countByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByGroupId(groupId);
    }

    /**
    * Returns the facil where facilityNumber = &#63; or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
    *
    * @param facilityNumber the facility number
    * @return the matching facil
    * @throws gov.va.caret.NoSuchFacilException if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil findByFacilityNumber(
        java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException {
        return getPersistence().findByFacilityNumber(facilityNumber);
    }

    /**
    * Returns the facil where facilityNumber = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param facilityNumber the facility number
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil fetchByFacilityNumber(
        java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByFacilityNumber(facilityNumber);
    }

    /**
    * Returns the facil where facilityNumber = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param facilityNumber the facility number
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil fetchByFacilityNumber(
        java.lang.String facilityNumber, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByFacilityNumber(facilityNumber, retrieveFromCache);
    }

    /**
    * Removes the facil where facilityNumber = &#63; from the database.
    *
    * @param facilityNumber the facility number
    * @return the facil that was removed
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil removeByFacilityNumber(
        java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException {
        return getPersistence().removeByFacilityNumber(facilityNumber);
    }

    /**
    * Returns the number of facils where facilityNumber = &#63;.
    *
    * @param facilityNumber the facility number
    * @return the number of matching facils
    * @throws SystemException if a system exception occurred
    */
    public static int countByFacilityNumber(java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByFacilityNumber(facilityNumber);
    }

    /**
    * Caches the facil in the entity cache if it is enabled.
    *
    * @param facil the facil
    */
    public static void cacheResult(gov.va.caret.model.Facil facil) {
        getPersistence().cacheResult(facil);
    }

    /**
    * Caches the facils in the entity cache if it is enabled.
    *
    * @param facils the facils
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Facil> facils) {
        getPersistence().cacheResult(facils);
    }

    /**
    * Creates a new facil with the primary key. Does not add the facil to the database.
    *
    * @param facilId the primary key for the new facil
    * @return the new facil
    */
    public static gov.va.caret.model.Facil create(long facilId) {
        return getPersistence().create(facilId);
    }

    /**
    * Removes the facil with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param facilId the primary key of the facil
    * @return the facil that was removed
    * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil remove(long facilId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException {
        return getPersistence().remove(facilId);
    }

    public static gov.va.caret.model.Facil updateImpl(
        gov.va.caret.model.Facil facil)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(facil);
    }

    /**
    * Returns the facil with the primary key or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
    *
    * @param facilId the primary key of the facil
    * @return the facil
    * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil findByPrimaryKey(long facilId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException {
        return getPersistence().findByPrimaryKey(facilId);
    }

    /**
    * Returns the facil with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param facilId the primary key of the facil
    * @return the facil, or <code>null</code> if a facil with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Facil fetchByPrimaryKey(long facilId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(facilId);
    }

    /**
    * Returns all the facils.
    *
    * @return the facils
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Facil> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the facils.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.FacilModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of facils
    * @param end the upper bound of the range of facils (not inclusive)
    * @return the range of facils
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Facil> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the facils.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.FacilModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of facils
    * @param end the upper bound of the range of facils (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of facils
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Facil> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the facils from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of facils.
    *
    * @return the number of facils
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static FacilPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (FacilPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    FacilPersistence.class.getName());

            ReferenceRegistry.registerReference(FacilUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(FacilPersistence persistence) {
    }
}
