package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.ClSoc;

/**
 * The persistence interface for the cl soc service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see ClSocPersistenceImpl
 * @see ClSocUtil
 * @generated
 */
public interface ClSocPersistence extends BasePersistence<ClSoc> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link ClSocUtil} to access the cl soc persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the cl socs where callId = &#63;.
    *
    * @param callId the call ID
    * @return the matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ClSoc> findByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the cl socs where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @return the range of matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ClSoc> findByCallId(long callId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the cl socs where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ClSoc> findByCallId(long callId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cl soc
    * @throws gov.va.caret.NoSuchClSocException if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc findByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException;

    /**
    * Returns the first cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cl soc, or <code>null</code> if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc fetchByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cl soc
    * @throws gov.va.caret.NoSuchClSocException if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc findByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException;

    /**
    * Returns the last cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cl soc, or <code>null</code> if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc fetchByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the cl socs before and after the current cl soc in the ordered set where callId = &#63;.
    *
    * @param clSocId the primary key of the current cl soc
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next cl soc
    * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc[] findByCallId_PrevAndNext(long clSocId,
        long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException;

    /**
    * Removes all the cl socs where callId = &#63; from the database.
    *
    * @param callId the call ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of cl socs where callId = &#63;.
    *
    * @param callId the call ID
    * @return the number of matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public int countByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the cl soc in the entity cache if it is enabled.
    *
    * @param clSoc the cl soc
    */
    public void cacheResult(gov.va.caret.model.ClSoc clSoc);

    /**
    * Caches the cl socs in the entity cache if it is enabled.
    *
    * @param clSocs the cl socs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.ClSoc> clSocs);

    /**
    * Creates a new cl soc with the primary key. Does not add the cl soc to the database.
    *
    * @param clSocId the primary key for the new cl soc
    * @return the new cl soc
    */
    public gov.va.caret.model.ClSoc create(long clSocId);

    /**
    * Removes the cl soc with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param clSocId the primary key of the cl soc
    * @return the cl soc that was removed
    * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc remove(long clSocId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException;

    public gov.va.caret.model.ClSoc updateImpl(gov.va.caret.model.ClSoc clSoc)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the cl soc with the primary key or throws a {@link gov.va.caret.NoSuchClSocException} if it could not be found.
    *
    * @param clSocId the primary key of the cl soc
    * @return the cl soc
    * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc findByPrimaryKey(long clSocId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException;

    /**
    * Returns the cl soc with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param clSocId the primary key of the cl soc
    * @return the cl soc, or <code>null</code> if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.ClSoc fetchByPrimaryKey(long clSocId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the cl socs.
    *
    * @return the cl socs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ClSoc> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the cl socs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @return the range of cl socs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ClSoc> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the cl socs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of cl socs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.ClSoc> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the cl socs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of cl socs.
    *
    * @return the number of cl socs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
