package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.BoxGp;

/**
 * The persistence interface for the box gp service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BoxGpPersistenceImpl
 * @see BoxGpUtil
 * @generated
 */
public interface BoxGpPersistence extends BasePersistence<BoxGp> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link BoxGpUtil} to access the box gp persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the box gps where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @return the matching box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findByBoxGroup(
        java.lang.String boxGroup)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the box gps where boxGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @return the range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findByBoxGroup(
        java.lang.String boxGroup, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the box gps where boxGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findByBoxGroup(
        java.lang.String boxGroup, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp findByBoxGroup_First(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp fetchByBoxGroup_First(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp findByBoxGroup_Last(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp fetchByBoxGroup_Last(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the box gps before and after the current box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGpId the primary key of the current box gp
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp[] findByBoxGroup_PrevAndNext(long boxGpId,
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    /**
    * Removes all the box gps where boxGroup = &#63; from the database.
    *
    * @param boxGroup the box group
    * @throws SystemException if a system exception occurred
    */
    public void removeByBoxGroup(java.lang.String boxGroup)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of box gps where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @return the number of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public int countByBoxGroup(java.lang.String boxGroup)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @return the matching box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findByBoxSubGroup(
        java.lang.String boxGroup, java.lang.String boxSubGroup)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @return the range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findByBoxSubGroup(
        java.lang.String boxGroup, java.lang.String boxSubGroup, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findByBoxSubGroup(
        java.lang.String boxGroup, java.lang.String boxSubGroup, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp findByBoxSubGroup_First(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp fetchByBoxSubGroup_First(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp findByBoxSubGroup_Last(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp fetchByBoxSubGroup_Last(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the box gps before and after the current box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGpId the primary key of the current box gp
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp[] findByBoxSubGroup_PrevAndNext(
        long boxGpId, java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    /**
    * Removes all the box gps where boxGroup = &#63; and boxSubGroup = &#63; from the database.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @throws SystemException if a system exception occurred
    */
    public void removeByBoxSubGroup(java.lang.String boxGroup,
        java.lang.String boxSubGroup)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @return the number of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public int countByBoxSubGroup(java.lang.String boxGroup,
        java.lang.String boxSubGroup)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the box gp in the entity cache if it is enabled.
    *
    * @param boxGp the box gp
    */
    public void cacheResult(gov.va.caret.model.BoxGp boxGp);

    /**
    * Caches the box gps in the entity cache if it is enabled.
    *
    * @param boxGps the box gps
    */
    public void cacheResult(java.util.List<gov.va.caret.model.BoxGp> boxGps);

    /**
    * Creates a new box gp with the primary key. Does not add the box gp to the database.
    *
    * @param boxGpId the primary key for the new box gp
    * @return the new box gp
    */
    public gov.va.caret.model.BoxGp create(long boxGpId);

    /**
    * Removes the box gp with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp that was removed
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp remove(long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    public gov.va.caret.model.BoxGp updateImpl(gov.va.caret.model.BoxGp boxGp)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the box gp with the primary key or throws a {@link gov.va.caret.NoSuchBoxGpException} if it could not be found.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp findByPrimaryKey(long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException;

    /**
    * Returns the box gp with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp, or <code>null</code> if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BoxGp fetchByPrimaryKey(long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the box gps.
    *
    * @return the box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the box gps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @return the range of box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the box gps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of box gps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BoxGp> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the box gps from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of box gps.
    *
    * @return the number of box gps
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
