package gov.va.caret.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link EERatedDisabilityLocalService}.
 *
 * @author caret
 * @see EERatedDisabilityLocalService
 * @generated
 */
public class EERatedDisabilityLocalServiceWrapper
    implements EERatedDisabilityLocalService,
        ServiceWrapper<EERatedDisabilityLocalService> {
    private EERatedDisabilityLocalService _eeRatedDisabilityLocalService;

    public EERatedDisabilityLocalServiceWrapper(
        EERatedDisabilityLocalService eeRatedDisabilityLocalService) {
        _eeRatedDisabilityLocalService = eeRatedDisabilityLocalService;
    }

    /**
    * Adds the e e rated disability to the database. Also notifies the appropriate model listeners.
    *
    * @param eeRatedDisability the e e rated disability
    * @return the e e rated disability that was added
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.EERatedDisability addEERatedDisability(
        gov.va.caret.model.EERatedDisability eeRatedDisability)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.addEERatedDisability(eeRatedDisability);
    }

    /**
    * Creates a new e e rated disability with the primary key. Does not add the e e rated disability to the database.
    *
    * @param eeRatedDisabId the primary key for the new e e rated disability
    * @return the new e e rated disability
    */
    @Override
    public gov.va.caret.model.EERatedDisability createEERatedDisability(
        long eeRatedDisabId) {
        return _eeRatedDisabilityLocalService.createEERatedDisability(eeRatedDisabId);
    }

    /**
    * Deletes the e e rated disability with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param eeRatedDisabId the primary key of the e e rated disability
    * @return the e e rated disability that was removed
    * @throws PortalException if a e e rated disability with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.EERatedDisability deleteEERatedDisability(
        long eeRatedDisabId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.deleteEERatedDisability(eeRatedDisabId);
    }

    /**
    * Deletes the e e rated disability from the database. Also notifies the appropriate model listeners.
    *
    * @param eeRatedDisability the e e rated disability
    * @return the e e rated disability that was removed
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.EERatedDisability deleteEERatedDisability(
        gov.va.caret.model.EERatedDisability eeRatedDisability)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.deleteEERatedDisability(eeRatedDisability);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return _eeRatedDisabilityLocalService.dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.dynamicQuery(dynamicQuery, start,
            end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.dynamicQuery(dynamicQuery, start,
            end, orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.dynamicQueryCount(dynamicQuery,
            projection);
    }

    @Override
    public gov.va.caret.model.EERatedDisability fetchEERatedDisability(
        long eeRatedDisabId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.fetchEERatedDisability(eeRatedDisabId);
    }

    /**
    * Returns the e e rated disability with the primary key.
    *
    * @param eeRatedDisabId the primary key of the e e rated disability
    * @return the e e rated disability
    * @throws PortalException if a e e rated disability with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.EERatedDisability getEERatedDisability(
        long eeRatedDisabId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.getEERatedDisability(eeRatedDisabId);
    }

    @Override
    public com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the e e rated disabilities.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EERatedDisabilityModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of e e rated disabilities
    * @param end the upper bound of the range of e e rated disabilities (not inclusive)
    * @return the range of e e rated disabilities
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.EERatedDisability> getEERatedDisabilities(
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.getEERatedDisabilities(start, end);
    }

    /**
    * Returns the number of e e rated disabilities.
    *
    * @return the number of e e rated disabilities
    * @throws SystemException if a system exception occurred
    */
    @Override
    public int getEERatedDisabilitiesCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.getEERatedDisabilitiesCount();
    }

    /**
    * Updates the e e rated disability in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param eeRatedDisability the e e rated disability
    * @return the e e rated disability that was updated
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.EERatedDisability updateEERatedDisability(
        gov.va.caret.model.EERatedDisability eeRatedDisability)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.updateEERatedDisability(eeRatedDisability);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    @Override
    public java.lang.String getBeanIdentifier() {
        return _eeRatedDisabilityLocalService.getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    @Override
    public void setBeanIdentifier(java.lang.String beanIdentifier) {
        _eeRatedDisabilityLocalService.setBeanIdentifier(beanIdentifier);
    }

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return _eeRatedDisabilityLocalService.invokeMethod(name,
            parameterTypes, arguments);
    }

    /**
    * Returns all the e e military records where eeLgId = &#63;.
    *
    * @param eeLgId the ee lg ID
    * @return the matching e e military records
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.EERatedDisability> findByeeLgId(
        long eeLgId) throws com.liferay.portal.kernel.exception.SystemException {
        return _eeRatedDisabilityLocalService.findByeeLgId(eeLgId);
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedService}
     */
    public EERatedDisabilityLocalService getWrappedEERatedDisabilityLocalService() {
        return _eeRatedDisabilityLocalService;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #setWrappedService}
     */
    public void setWrappedEERatedDisabilityLocalService(
        EERatedDisabilityLocalService eeRatedDisabilityLocalService) {
        _eeRatedDisabilityLocalService = eeRatedDisabilityLocalService;
    }

    @Override
    public EERatedDisabilityLocalService getWrappedService() {
        return _eeRatedDisabilityLocalService;
    }

    @Override
    public void setWrappedService(
        EERatedDisabilityLocalService eeRatedDisabilityLocalService) {
        _eeRatedDisabilityLocalService = eeRatedDisabilityLocalService;
    }
}
