package gov.va.caret.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link CryptoLocalService}.
 *
 * @author caret
 * @see CryptoLocalService
 * @generated
 */
public class CryptoLocalServiceWrapper implements CryptoLocalService,
    ServiceWrapper<CryptoLocalService> {
    private CryptoLocalService _cryptoLocalService;

    public CryptoLocalServiceWrapper(CryptoLocalService cryptoLocalService) {
        _cryptoLocalService = cryptoLocalService;
    }

    /**
    * Adds the crypto to the database. Also notifies the appropriate model listeners.
    *
    * @param crypto the crypto
    * @return the crypto that was added
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Crypto addCrypto(gov.va.caret.model.Crypto crypto)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.addCrypto(crypto);
    }

    /**
    * Creates a new crypto with the primary key. Does not add the crypto to the database.
    *
    * @param cryptoId the primary key for the new crypto
    * @return the new crypto
    */
    @Override
    public gov.va.caret.model.Crypto createCrypto(long cryptoId) {
        return _cryptoLocalService.createCrypto(cryptoId);
    }

    /**
    * Deletes the crypto with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param cryptoId the primary key of the crypto
    * @return the crypto that was removed
    * @throws PortalException if a crypto with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Crypto deleteCrypto(long cryptoId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.deleteCrypto(cryptoId);
    }

    /**
    * Deletes the crypto from the database. Also notifies the appropriate model listeners.
    *
    * @param crypto the crypto
    * @return the crypto that was removed
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Crypto deleteCrypto(
        gov.va.caret.model.Crypto crypto)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.deleteCrypto(crypto);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return _cryptoLocalService.dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CryptoModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CryptoModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.dynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.dynamicQueryCount(dynamicQuery, projection);
    }

    @Override
    public gov.va.caret.model.Crypto fetchCrypto(long cryptoId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.fetchCrypto(cryptoId);
    }

    /**
    * Returns the crypto with the primary key.
    *
    * @param cryptoId the primary key of the crypto
    * @return the crypto
    * @throws PortalException if a crypto with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Crypto getCrypto(long cryptoId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.getCrypto(cryptoId);
    }

    @Override
    public com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the cryptos.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CryptoModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cryptos
    * @param end the upper bound of the range of cryptos (not inclusive)
    * @return the range of cryptos
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.Crypto> getCryptos(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.getCryptos(start, end);
    }

    /**
    * Returns the number of cryptos.
    *
    * @return the number of cryptos
    * @throws SystemException if a system exception occurred
    */
    @Override
    public int getCryptosCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.getCryptosCount();
    }

    /**
    * Updates the crypto in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param crypto the crypto
    * @return the crypto that was updated
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Crypto updateCrypto(
        gov.va.caret.model.Crypto crypto)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _cryptoLocalService.updateCrypto(crypto);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    @Override
    public java.lang.String getBeanIdentifier() {
        return _cryptoLocalService.getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    @Override
    public void setBeanIdentifier(java.lang.String beanIdentifier) {
        _cryptoLocalService.setBeanIdentifier(beanIdentifier);
    }

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return _cryptoLocalService.invokeMethod(name, parameterTypes, arguments);
    }

    @Override
    public gov.va.caret.model.Crypto getCrypto(long ownerId,
        java.lang.String type) throws gov.va.caret.ApplicationWorkFlowException {
        return _cryptoLocalService.getCrypto(ownerId, type);
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedService}
     */
    public CryptoLocalService getWrappedCryptoLocalService() {
        return _cryptoLocalService;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #setWrappedService}
     */
    public void setWrappedCryptoLocalService(
        CryptoLocalService cryptoLocalService) {
        _cryptoLocalService = cryptoLocalService;
    }

    @Override
    public CryptoLocalService getWrappedService() {
        return _cryptoLocalService;
    }

    @Override
    public void setWrappedService(CryptoLocalService cryptoLocalService) {
        _cryptoLocalService = cryptoLocalService;
    }
}
