package gov.va.caret.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link BoxGpLocalService}.
 *
 * @author caret
 * @see BoxGpLocalService
 * @generated
 */
public class BoxGpLocalServiceWrapper implements BoxGpLocalService,
    ServiceWrapper<BoxGpLocalService> {
    private BoxGpLocalService _boxGpLocalService;

    public BoxGpLocalServiceWrapper(BoxGpLocalService boxGpLocalService) {
        _boxGpLocalService = boxGpLocalService;
    }

    /**
    * Adds the box gp to the database. Also notifies the appropriate model listeners.
    *
    * @param boxGp the box gp
    * @return the box gp that was added
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BoxGp addBoxGp(gov.va.caret.model.BoxGp boxGp)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.addBoxGp(boxGp);
    }

    /**
    * Creates a new box gp with the primary key. Does not add the box gp to the database.
    *
    * @param boxGpId the primary key for the new box gp
    * @return the new box gp
    */
    @Override
    public gov.va.caret.model.BoxGp createBoxGp(long boxGpId) {
        return _boxGpLocalService.createBoxGp(boxGpId);
    }

    /**
    * Deletes the box gp with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp that was removed
    * @throws PortalException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BoxGp deleteBoxGp(long boxGpId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.deleteBoxGp(boxGpId);
    }

    /**
    * Deletes the box gp from the database. Also notifies the appropriate model listeners.
    *
    * @param boxGp the box gp
    * @return the box gp that was removed
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BoxGp deleteBoxGp(gov.va.caret.model.BoxGp boxGp)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.deleteBoxGp(boxGp);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return _boxGpLocalService.dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.dynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.dynamicQueryCount(dynamicQuery, projection);
    }

    @Override
    public gov.va.caret.model.BoxGp fetchBoxGp(long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.fetchBoxGp(boxGpId);
    }

    /**
    * Returns the box gp with the primary key.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp
    * @throws PortalException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BoxGp getBoxGp(long boxGpId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.getBoxGp(boxGpId);
    }

    @Override
    public com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the box gps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @return the range of box gps
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.BoxGp> getBoxGps(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.getBoxGps(start, end);
    }

    /**
    * Returns the number of box gps.
    *
    * @return the number of box gps
    * @throws SystemException if a system exception occurred
    */
    @Override
    public int getBoxGpsCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.getBoxGpsCount();
    }

    /**
    * Updates the box gp in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param boxGp the box gp
    * @return the box gp that was updated
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.BoxGp updateBoxGp(gov.va.caret.model.BoxGp boxGp)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _boxGpLocalService.updateBoxGp(boxGp);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    @Override
    public java.lang.String getBeanIdentifier() {
        return _boxGpLocalService.getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    @Override
    public void setBeanIdentifier(java.lang.String beanIdentifier) {
        _boxGpLocalService.setBeanIdentifier(beanIdentifier);
    }

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return _boxGpLocalService.invokeMethod(name, parameterTypes, arguments);
    }

    @Override
    public java.util.List<gov.va.caret.model.BoxGp> getBoxGroups(
        java.lang.String name) throws gov.va.caret.ApplicationWorkFlowException {
        return _boxGpLocalService.getBoxGroups(name);
    }

    @Override
    public java.util.List<gov.va.caret.model.BoxGp> getBoxGroups(
        java.lang.String boxGroup, java.lang.String boxSubGroup)
        throws gov.va.caret.ApplicationWorkFlowException {
        return _boxGpLocalService.getBoxGroups(boxGroup, boxSubGroup);
    }

    @Override
    public java.util.List<gov.va.caret.model.BgAsn> getBoxGroupAssociations(
        long ownerId) throws gov.va.caret.ApplicationWorkFlowException {
        return _boxGpLocalService.getBoxGroupAssociations(ownerId);
    }

    @Override
    public java.util.List<gov.va.caret.model.BgAsn> getBoxGroupAssociations(
        long ownerId, boolean enabled)
        throws gov.va.caret.ApplicationWorkFlowException {
        return _boxGpLocalService.getBoxGroupAssociations(ownerId, enabled);
    }

    @Override
    public gov.va.caret.model.BgAsn getBoxGroupAssociation(long ownerId,
        long boxGpId) throws gov.va.caret.ApplicationWorkFlowException {
        return _boxGpLocalService.getBoxGroupAssociation(ownerId, boxGpId);
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedService}
     */
    public BoxGpLocalService getWrappedBoxGpLocalService() {
        return _boxGpLocalService;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #setWrappedService}
     */
    public void setWrappedBoxGpLocalService(BoxGpLocalService boxGpLocalService) {
        _boxGpLocalService = boxGpLocalService;
    }

    @Override
    public BoxGpLocalService getWrappedService() {
        return _boxGpLocalService;
    }

    @Override
    public void setWrappedService(BoxGpLocalService boxGpLocalService) {
        _boxGpLocalService = boxGpLocalService;
    }
}
