package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the WorIm service. Represents a row in the &quot;CARET_WORK_ITEM&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.WorImModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.WorImImpl}.
 * </p>
 *
 * @author caret
 * @see WorIm
 * @see gov.va.caret.model.impl.WorImImpl
 * @see gov.va.caret.model.impl.WorImModelImpl
 * @generated
 */
public interface WorImModel extends BaseModel<WorIm> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a wor im model instance should use the {@link WorIm} interface instead.
     */

    /**
     * Returns the primary key of this wor im.
     *
     * @return the primary key of this wor im
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this wor im.
     *
     * @param primaryKey the primary key of this wor im
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the wor im ID of this wor im.
     *
     * @return the wor im ID of this wor im
     */
    public long getWorImId();

    /**
     * Sets the wor im ID of this wor im.
     *
     * @param worImId the wor im ID of this wor im
     */
    public void setWorImId(long worImId);

    /**
     * Returns the type of this wor im.
     *
     * @return the type of this wor im
     */
    @AutoEscape
    public String getType();

    /**
     * Sets the type of this wor im.
     *
     * @param type the type of this wor im
     */
    public void setType(String type);

    /**
     * Returns the class ID of this wor im.
     *
     * @return the class ID of this wor im
     */
    public long getClassId();

    /**
     * Sets the class ID of this wor im.
     *
     * @param classId the class ID of this wor im
     */
    public void setClassId(long classId);

    /**
     * Returns the class pk of this wor im.
     *
     * @return the class pk of this wor im
     */
    public long getClassPk();

    /**
     * Sets the class pk of this wor im.
     *
     * @param classPk the class pk of this wor im
     */
    public void setClassPk(long classPk);

    /**
     * Returns the status of this wor im.
     *
     * @return the status of this wor im
     */
    @AutoEscape
    public String getStatus();

    /**
     * Sets the status of this wor im.
     *
     * @param status the status of this wor im
     */
    public void setStatus(String status);

    /**
     * Returns the creation date of this wor im.
     *
     * @return the creation date of this wor im
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this wor im.
     *
     * @param creationDate the creation date of this wor im
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the due date of this wor im.
     *
     * @return the due date of this wor im
     */
    public Date getDueDate();

    /**
     * Sets the due date of this wor im.
     *
     * @param dueDate the due date of this wor im
     */
    public void setDueDate(Date dueDate);

    /**
     * Returns the completion date of this wor im.
     *
     * @return the completion date of this wor im
     */
    public Date getCompletionDate();

    /**
     * Sets the completion date of this wor im.
     *
     * @param completionDate the completion date of this wor im
     */
    public void setCompletionDate(Date completionDate);

    /**
     * Returns the completion by of this wor im.
     *
     * @return the completion by of this wor im
     */
    public long getCompletionBy();

    /**
     * Sets the completion by of this wor im.
     *
     * @param completionBy the completion by of this wor im
     */
    public void setCompletionBy(long completionBy);

    /**
     * Returns the group ID of this wor im.
     *
     * @return the group ID of this wor im
     */
    public long getGroupId();

    /**
     * Sets the group ID of this wor im.
     *
     * @param groupId the group ID of this wor im
     */
    public void setGroupId(long groupId);

    /**
     * Returns the user ID of this wor im.
     *
     * @return the user ID of this wor im
     */
    public long getUserId();

    /**
     * Sets the user ID of this wor im.
     *
     * @param userId the user ID of this wor im
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this wor im.
     *
     * @return the user uuid of this wor im
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this wor im.
     *
     * @param userUuid the user uuid of this wor im
     */
    public void setUserUuid(String userUuid);

    /**
     * Returns the caregiver ID of this wor im.
     *
     * @return the caregiver ID of this wor im
     */
    public long getCaregiverId();

    /**
     * Sets the caregiver ID of this wor im.
     *
     * @param caregiverId the caregiver ID of this wor im
     */
    public void setCaregiverId(long caregiverId);

    /**
     * Returns the persn ID of this wor im.
     *
     * @return the persn ID of this wor im
     */
    public long getPersnId();

    /**
     * Sets the persn ID of this wor im.
     *
     * @param persnId the persn ID of this wor im
     */
    public void setPersnId(long persnId);

    /**
     * Returns the que ID of this wor im.
     *
     * @return the que ID of this wor im
     */
    public long getQueId();

    /**
     * Sets the que ID of this wor im.
     *
     * @param queId the que ID of this wor im
     */
    public void setQueId(long queId);

    /**
     * Returns the vcg ID of this wor im.
     *
     * @return the vcg ID of this wor im
     */
    public long getVcgId();

    /**
     * Sets the vcg ID of this wor im.
     *
     * @param vcgId the vcg ID of this wor im
     */
    public void setVcgId(long vcgId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.WorIm worIm);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.WorIm> toCacheModel();

    @Override
    public gov.va.caret.model.WorIm toEscapedModel();

    @Override
    public gov.va.caret.model.WorIm toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
