package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class WaivrSoap implements Serializable {
    private long _waivrId;
    private long _classPk;
    private String _adjudication;
    private String _reason;
    private String _note;
    private Date _creationDate;
    private Date _completionDate;
    private long _userId;

    public WaivrSoap() {
    }

    public static WaivrSoap toSoapModel(Waivr model) {
        WaivrSoap soapModel = new WaivrSoap();

        soapModel.setWaivrId(model.getWaivrId());
        soapModel.setClassPk(model.getClassPk());
        soapModel.setAdjudication(model.getAdjudication());
        soapModel.setReason(model.getReason());
        soapModel.setNote(model.getNote());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setCompletionDate(model.getCompletionDate());
        soapModel.setUserId(model.getUserId());

        return soapModel;
    }

    public static WaivrSoap[] toSoapModels(Waivr[] models) {
        WaivrSoap[] soapModels = new WaivrSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static WaivrSoap[][] toSoapModels(Waivr[][] models) {
        WaivrSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new WaivrSoap[models.length][models[0].length];
        } else {
            soapModels = new WaivrSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static WaivrSoap[] toSoapModels(List<Waivr> models) {
        List<WaivrSoap> soapModels = new ArrayList<WaivrSoap>(models.size());

        for (Waivr model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new WaivrSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _waivrId;
    }

    public void setPrimaryKey(long pk) {
        setWaivrId(pk);
    }

    public long getWaivrId() {
        return _waivrId;
    }

    public void setWaivrId(long waivrId) {
        _waivrId = waivrId;
    }

    public long getClassPk() {
        return _classPk;
    }

    public void setClassPk(long classPk) {
        _classPk = classPk;
    }

    public String getAdjudication() {
        return _adjudication;
    }

    public void setAdjudication(String adjudication) {
        _adjudication = adjudication;
    }

    public String getReason() {
        return _reason;
    }

    public void setReason(String reason) {
        _reason = reason;
    }

    public String getNote() {
        return _note;
    }

    public void setNote(String note) {
        _note = note;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public Date getCompletionDate() {
        return _completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;
    }

    public long getUserId() {
        return _userId;
    }

    public void setUserId(long userId) {
        _userId = userId;
    }
}
