package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class VetVrSoap implements Serializable {
    private long _vetVrId;
    private long _vendrId;
    private long _cgId;
    private long _veteranId;
    private long _groupId;

    public VetVrSoap() {
    }

    public static VetVrSoap toSoapModel(VetVr model) {
        VetVrSoap soapModel = new VetVrSoap();

        soapModel.setVetVrId(model.getVetVrId());
        soapModel.setVendrId(model.getVendrId());
        soapModel.setCgId(model.getCgId());
        soapModel.setVeteranId(model.getVeteranId());
        soapModel.setGroupId(model.getGroupId());

        return soapModel;
    }

    public static VetVrSoap[] toSoapModels(VetVr[] models) {
        VetVrSoap[] soapModels = new VetVrSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static VetVrSoap[][] toSoapModels(VetVr[][] models) {
        VetVrSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new VetVrSoap[models.length][models[0].length];
        } else {
            soapModels = new VetVrSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static VetVrSoap[] toSoapModels(List<VetVr> models) {
        List<VetVrSoap> soapModels = new ArrayList<VetVrSoap>(models.size());

        for (VetVr model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new VetVrSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _vetVrId;
    }

    public void setPrimaryKey(long pk) {
        setVetVrId(pk);
    }

    public long getVetVrId() {
        return _vetVrId;
    }

    public void setVetVrId(long vetVrId) {
        _vetVrId = vetVrId;
    }

    public long getVendrId() {
        return _vendrId;
    }

    public void setVendrId(long vendrId) {
        _vendrId = vendrId;
    }

    public long getCgId() {
        return _cgId;
    }

    public void setCgId(long cgId) {
        _cgId = cgId;
    }

    public long getVeteranId() {
        return _veteranId;
    }

    public void setVeteranId(long veteranId) {
        _veteranId = veteranId;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }
}
