package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the StiRd service. Represents a row in the &quot;CARET_STIPEND&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.StiRdModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.StiRdImpl}.
 * </p>
 *
 * @author caret
 * @see StiRd
 * @see gov.va.caret.model.impl.StiRdImpl
 * @see gov.va.caret.model.impl.StiRdModelImpl
 * @generated
 */
public interface StiRdModel extends BaseModel<StiRd> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a sti rd model instance should use the {@link StiRd} interface instead.
     */

    /**
     * Returns the primary key of this sti rd.
     *
     * @return the primary key of this sti rd
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this sti rd.
     *
     * @param primaryKey the primary key of this sti rd
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the sti rd ID of this sti rd.
     *
     * @return the sti rd ID of this sti rd
     */
    public long getStiRdId();

    /**
     * Sets the sti rd ID of this sti rd.
     *
     * @param stiRdId the sti rd ID of this sti rd
     */
    public void setStiRdId(long stiRdId);

    /**
     * Returns the vcg an ID of this sti rd.
     *
     * @return the vcg an ID of this sti rd
     */
    public long getVcgAnId();

    /**
     * Sets the vcg an ID of this sti rd.
     *
     * @param vcgAnId the vcg an ID of this sti rd
     */
    public void setVcgAnId(long vcgAnId);

    /**
     * Returns the csc status of this sti rd.
     *
     * @return the csc status of this sti rd
     */
    @AutoEscape
    public String getCscStatus();

    /**
     * Sets the csc status of this sti rd.
     *
     * @param cscStatus the csc status of this sti rd
     */
    public void setCscStatus(String cscStatus);

    /**
     * Returns the csc status date of this sti rd.
     *
     * @return the csc status date of this sti rd
     */
    public Date getCscStatusDate();

    /**
     * Sets the csc status date of this sti rd.
     *
     * @param cscStatusDate the csc status date of this sti rd
     */
    public void setCscStatusDate(Date cscStatusDate);

    /**
     * Returns the cbopc status of this sti rd.
     *
     * @return the cbopc status of this sti rd
     */
    @AutoEscape
    public String getCbopcStatus();

    /**
     * Sets the cbopc status of this sti rd.
     *
     * @param cbopcStatus the cbopc status of this sti rd
     */
    public void setCbopcStatus(String cbopcStatus);

    /**
     * Returns the cbopc status date of this sti rd.
     *
     * @return the cbopc status date of this sti rd
     */
    public Date getCbopcStatusDate();

    /**
     * Sets the cbopc status date of this sti rd.
     *
     * @param cbopcStatusDate the cbopc status date of this sti rd
     */
    public void setCbopcStatusDate(Date cbopcStatusDate);

    /**
     * Returns the creation date of this sti rd.
     *
     * @return the creation date of this sti rd
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this sti rd.
     *
     * @param creationDate the creation date of this sti rd
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the user ID of this sti rd.
     *
     * @return the user ID of this sti rd
     */
    public long getUserId();

    /**
     * Sets the user ID of this sti rd.
     *
     * @param userId the user ID of this sti rd
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this sti rd.
     *
     * @return the user uuid of this sti rd
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this sti rd.
     *
     * @param userUuid the user uuid of this sti rd
     */
    public void setUserUuid(String userUuid);

    /**
     * Returns the group ID of this sti rd.
     *
     * @return the group ID of this sti rd
     */
    public long getGroupId();

    /**
     * Sets the group ID of this sti rd.
     *
     * @param groupId the group ID of this sti rd
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.StiRd stiRd);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.StiRd> toCacheModel();

    @Override
    public gov.va.caret.model.StiRd toEscapedModel();

    @Override
    public gov.va.caret.model.StiRd toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
