/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link PMReadMessage}.
 * </p>
 *
 * @author caret
 * @see PMReadMessage
 * @generated
 */
public class PMReadMessageWrapper implements PMReadMessage,
	ModelWrapper<PMReadMessage> {
	public PMReadMessageWrapper(PMReadMessage pmReadMessage) {
		_pmReadMessage = pmReadMessage;
	}

	@Override
	public Class<?> getModelClass() {
		return PMReadMessage.class;
	}

	@Override
	public String getModelClassName() {
		return PMReadMessage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("readMessageId", getReadMessageId());
		attributes.put("messageId", getMessageId());
		attributes.put("readDate", getReadDate());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long readMessageId = (Long)attributes.get("readMessageId");

		if (readMessageId != null) {
			setReadMessageId(readMessageId);
		}

		Long messageId = (Long)attributes.get("messageId");

		if (messageId != null) {
			setMessageId(messageId);
		}

		Date readDate = (Date)attributes.get("readDate");

		if (readDate != null) {
			setReadDate(readDate);
		}
	}

	/**
	* Returns the primary key of this p m read message.
	*
	* @return the primary key of this p m read message
	*/
	@Override
	public long getPrimaryKey() {
		return _pmReadMessage.getPrimaryKey();
	}

	/**
	* Sets the primary key of this p m read message.
	*
	* @param primaryKey the primary key of this p m read message
	*/
	@Override
	public void setPrimaryKey(long primaryKey) {
		_pmReadMessage.setPrimaryKey(primaryKey);
	}

	/**
	* Returns the read message ID of this p m read message.
	*
	* @return the read message ID of this p m read message
	*/
	@Override
	public long getReadMessageId() {
		return _pmReadMessage.getReadMessageId();
	}

	/**
	* Sets the read message ID of this p m read message.
	*
	* @param readMessageId the read message ID of this p m read message
	*/
	@Override
	public void setReadMessageId(long readMessageId) {
		_pmReadMessage.setReadMessageId(readMessageId);
	}

	/**
	* Returns the message ID of this p m read message.
	*
	* @return the message ID of this p m read message
	*/
	@Override
	public long getMessageId() {
		return _pmReadMessage.getMessageId();
	}

	/**
	* Sets the message ID of this p m read message.
	*
	* @param messageId the message ID of this p m read message
	*/
	@Override
	public void setMessageId(long messageId) {
		_pmReadMessage.setMessageId(messageId);
	}

	/**
	* Returns the read date of this p m read message.
	*
	* @return the read date of this p m read message
	*/
	@Override
	public java.util.Date getReadDate() {
		return _pmReadMessage.getReadDate();
	}

	/**
	* Sets the read date of this p m read message.
	*
	* @param readDate the read date of this p m read message
	*/
	@Override
	public void setReadDate(java.util.Date readDate) {
		_pmReadMessage.setReadDate(readDate);
	}

	@Override
	public boolean isNew() {
		return _pmReadMessage.isNew();
	}

	@Override
	public void setNew(boolean n) {
		_pmReadMessage.setNew(n);
	}

	@Override
	public boolean isCachedModel() {
		return _pmReadMessage.isCachedModel();
	}

	@Override
	public void setCachedModel(boolean cachedModel) {
		_pmReadMessage.setCachedModel(cachedModel);
	}

	@Override
	public boolean isEscapedModel() {
		return _pmReadMessage.isEscapedModel();
	}

	@Override
	public java.io.Serializable getPrimaryKeyObj() {
		return _pmReadMessage.getPrimaryKeyObj();
	}

	@Override
	public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
		_pmReadMessage.setPrimaryKeyObj(primaryKeyObj);
	}

	@Override
	public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
		return _pmReadMessage.getExpandoBridge();
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.model.BaseModel<?> baseModel) {
		_pmReadMessage.setExpandoBridgeAttributes(baseModel);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
		_pmReadMessage.setExpandoBridgeAttributes(expandoBridge);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.service.ServiceContext serviceContext) {
		_pmReadMessage.setExpandoBridgeAttributes(serviceContext);
	}

	@Override
	public java.lang.Object clone() {
		return new PMReadMessageWrapper((PMReadMessage)_pmReadMessage.clone());
	}

	@Override
	public int compareTo(gov.va.caret.model.PMReadMessage pmReadMessage) {
		return _pmReadMessage.compareTo(pmReadMessage);
	}

	@Override
	public int hashCode() {
		return _pmReadMessage.hashCode();
	}

	@Override
	public com.liferay.portal.model.CacheModel<gov.va.caret.model.PMReadMessage> toCacheModel() {
		return _pmReadMessage.toCacheModel();
	}

	@Override
	public gov.va.caret.model.PMReadMessage toEscapedModel() {
		return new PMReadMessageWrapper(_pmReadMessage.toEscapedModel());
	}

	@Override
	public gov.va.caret.model.PMReadMessage toUnescapedModel() {
		return new PMReadMessageWrapper(_pmReadMessage.toUnescapedModel());
	}

	@Override
	public java.lang.String toString() {
		return _pmReadMessage.toString();
	}

	@Override
	public java.lang.String toXmlString() {
		return _pmReadMessage.toXmlString();
	}

	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		_pmReadMessage.persist();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof PMReadMessageWrapper)) {
			return false;
		}

		PMReadMessageWrapper pmReadMessageWrapper = (PMReadMessageWrapper)obj;

		if (Validator.equals(_pmReadMessage, pmReadMessageWrapper._pmReadMessage)) {
			return true;
		}

		return false;
	}

	/**
	 * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
	 */
	public PMReadMessage getWrappedPMReadMessage() {
		return _pmReadMessage;
	}

	@Override
	public PMReadMessage getWrappedModel() {
		return _pmReadMessage;
	}

	@Override
	public void resetOriginalValues() {
		_pmReadMessage.resetOriginalValues();
	}

	private PMReadMessage _pmReadMessage;
}