/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.PMReadMessageLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author caret
 */
public class PMReadMessageClp extends BaseModelImpl<PMReadMessage>
	implements PMReadMessage {
	public PMReadMessageClp() {
	}

	@Override
	public Class<?> getModelClass() {
		return PMReadMessage.class;
	}

	@Override
	public String getModelClassName() {
		return PMReadMessage.class.getName();
	}

	@Override
	public long getPrimaryKey() {
		return _readMessageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setReadMessageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _readMessageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("readMessageId", getReadMessageId());
		attributes.put("messageId", getMessageId());
		attributes.put("readDate", getReadDate());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long readMessageId = (Long)attributes.get("readMessageId");

		if (readMessageId != null) {
			setReadMessageId(readMessageId);
		}

		Long messageId = (Long)attributes.get("messageId");

		if (messageId != null) {
			setMessageId(messageId);
		}

		Date readDate = (Date)attributes.get("readDate");

		if (readDate != null) {
			setReadDate(readDate);
		}
	}

	@Override
	public long getReadMessageId() {
		return _readMessageId;
	}

	@Override
	public void setReadMessageId(long readMessageId) {
		_readMessageId = readMessageId;

		if (_pmReadMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmReadMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setReadMessageId", long.class);

				method.invoke(_pmReadMessageRemoteModel, readMessageId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public long getMessageId() {
		return _messageId;
	}

	@Override
	public void setMessageId(long messageId) {
		_messageId = messageId;

		if (_pmReadMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmReadMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setMessageId", long.class);

				method.invoke(_pmReadMessageRemoteModel, messageId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public Date getReadDate() {
		return _readDate;
	}

	@Override
	public void setReadDate(Date readDate) {
		_readDate = readDate;

		if (_pmReadMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmReadMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setReadDate", Date.class);

				method.invoke(_pmReadMessageRemoteModel, readDate);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	public BaseModel<?> getPMReadMessageRemoteModel() {
		return _pmReadMessageRemoteModel;
	}

	public void setPMReadMessageRemoteModel(
		BaseModel<?> pmReadMessageRemoteModel) {
		_pmReadMessageRemoteModel = pmReadMessageRemoteModel;
	}

	public Object invokeOnRemoteModel(String methodName,
		Class<?>[] parameterTypes, Object[] parameterValues)
		throws Exception {
		Object[] remoteParameterValues = new Object[parameterValues.length];

		for (int i = 0; i < parameterValues.length; i++) {
			if (parameterValues[i] != null) {
				remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
			}
		}

		Class<?> remoteModelClass = _pmReadMessageRemoteModel.getClass();

		ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

		Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

		for (int i = 0; i < parameterTypes.length; i++) {
			if (parameterTypes[i].isPrimitive()) {
				remoteParameterTypes[i] = parameterTypes[i];
			}
			else {
				String parameterTypeName = parameterTypes[i].getName();

				remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
			}
		}

		Method method = remoteModelClass.getMethod(methodName,
				remoteParameterTypes);

		Object returnValue = method.invoke(_pmReadMessageRemoteModel,
				remoteParameterValues);

		if (returnValue != null) {
			returnValue = ClpSerializer.translateOutput(returnValue);
		}

		return returnValue;
	}

	@Override
	public void persist() throws SystemException {
		if (this.isNew()) {
			PMReadMessageLocalServiceUtil.addPMReadMessage(this);
		}
		else {
			PMReadMessageLocalServiceUtil.updatePMReadMessage(this);
		}
	}

	@Override
	public PMReadMessage toEscapedModel() {
		return (PMReadMessage)ProxyUtil.newProxyInstance(PMReadMessage.class.getClassLoader(),
			new Class[] { PMReadMessage.class }, new AutoEscapeBeanHandler(this));
	}

	@Override
	public Object clone() {
		PMReadMessageClp clone = new PMReadMessageClp();

		clone.setReadMessageId(getReadMessageId());
		clone.setMessageId(getMessageId());
		clone.setReadDate(getReadDate());

		return clone;
	}

	@Override
	public int compareTo(PMReadMessage pmReadMessage) {
		int value = 0;

		value = DateUtil.compareTo(getReadDate(), pmReadMessage.getReadDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof PMReadMessageClp)) {
			return false;
		}

		PMReadMessageClp pmReadMessage = (PMReadMessageClp)obj;

		long primaryKey = pmReadMessage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	public Class<?> getClpSerializerClass() {
		return _clpSerializerClass;
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(7);

		sb.append("{readMessageId=");
		sb.append(getReadMessageId());
		sb.append(", messageId=");
		sb.append(getMessageId());
		sb.append(", readDate=");
		sb.append(getReadDate());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(13);

		sb.append("<model><model-name>");
		sb.append("gov.va.caret.model.PMReadMessage");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>readMessageId</column-name><column-value><![CDATA[");
		sb.append(getReadMessageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>messageId</column-name><column-value><![CDATA[");
		sb.append(getMessageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>readDate</column-name><column-value><![CDATA[");
		sb.append(getReadDate());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private long _readMessageId;
	private long _messageId;
	private Date _readDate;
	private BaseModel<?> _pmReadMessageRemoteModel;
	private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;
}