/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.PMMessageLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author caret
 */
public class PMMessageClp extends BaseModelImpl<PMMessage> implements PMMessage {
	public PMMessageClp() {
	}

	@Override
	public Class<?> getModelClass() {
		return PMMessage.class;
	}

	@Override
	public String getModelClassName() {
		return PMMessage.class.getName();
	}

	@Override
	public long getPrimaryKey() {
		return _messageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setMessageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _messageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("messageId", getMessageId());
		attributes.put("subject", getSubject());
		attributes.put("body", getBody());
		attributes.put("url", getUrl());
		attributes.put("parentMessageId", getParentMessageId());
		attributes.put("ownerId", getOwnerId());
		attributes.put("ownerName", getOwnerName());
		attributes.put("postedDate", getPostedDate());
		attributes.put("recepients", getRecepients());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long messageId = (Long)attributes.get("messageId");

		if (messageId != null) {
			setMessageId(messageId);
		}

		String subject = (String)attributes.get("subject");

		if (subject != null) {
			setSubject(subject);
		}

		String body = (String)attributes.get("body");

		if (body != null) {
			setBody(body);
		}

		String url = (String)attributes.get("url");

		if (url != null) {
			setUrl(url);
		}

		Long parentMessageId = (Long)attributes.get("parentMessageId");

		if (parentMessageId != null) {
			setParentMessageId(parentMessageId);
		}

		Long ownerId = (Long)attributes.get("ownerId");

		if (ownerId != null) {
			setOwnerId(ownerId);
		}

		String ownerName = (String)attributes.get("ownerName");

		if (ownerName != null) {
			setOwnerName(ownerName);
		}

		Date postedDate = (Date)attributes.get("postedDate");

		if (postedDate != null) {
			setPostedDate(postedDate);
		}

		String recepients = (String)attributes.get("recepients");

		if (recepients != null) {
			setRecepients(recepients);
		}
	}

	@Override
	public long getMessageId() {
		return _messageId;
	}

	@Override
	public void setMessageId(long messageId) {
		_messageId = messageId;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setMessageId", long.class);

				method.invoke(_pmMessageRemoteModel, messageId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public String getSubject() {
		return _subject;
	}

	@Override
	public void setSubject(String subject) {
		_subject = subject;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setSubject", String.class);

				method.invoke(_pmMessageRemoteModel, subject);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public String getBody() {
		return _body;
	}

	@Override
	public void setBody(String body) {
		_body = body;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setBody", String.class);

				method.invoke(_pmMessageRemoteModel, body);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public String getUrl() {
		return _url;
	}

	@Override
	public void setUrl(String url) {
		_url = url;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setUrl", String.class);

				method.invoke(_pmMessageRemoteModel, url);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public long getParentMessageId() {
		return _parentMessageId;
	}

	@Override
	public void setParentMessageId(long parentMessageId) {
		_parentMessageId = parentMessageId;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setParentMessageId", long.class);

				method.invoke(_pmMessageRemoteModel, parentMessageId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public long getOwnerId() {
		return _ownerId;
	}

	@Override
	public void setOwnerId(long ownerId) {
		_ownerId = ownerId;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setOwnerId", long.class);

				method.invoke(_pmMessageRemoteModel, ownerId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public String getOwnerName() {
		return _ownerName;
	}

	@Override
	public void setOwnerName(String ownerName) {
		_ownerName = ownerName;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setOwnerName", String.class);

				method.invoke(_pmMessageRemoteModel, ownerName);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public Date getPostedDate() {
		return _postedDate;
	}

	@Override
	public void setPostedDate(Date postedDate) {
		_postedDate = postedDate;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setPostedDate", Date.class);

				method.invoke(_pmMessageRemoteModel, postedDate);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public String getRecepients() {
		return _recepients;
	}

	@Override
	public void setRecepients(String recepients) {
		_recepients = recepients;

		if (_pmMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setRecepients", String.class);

				method.invoke(_pmMessageRemoteModel, recepients);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	public BaseModel<?> getPMMessageRemoteModel() {
		return _pmMessageRemoteModel;
	}

	public void setPMMessageRemoteModel(BaseModel<?> pmMessageRemoteModel) {
		_pmMessageRemoteModel = pmMessageRemoteModel;
	}

	public Object invokeOnRemoteModel(String methodName,
		Class<?>[] parameterTypes, Object[] parameterValues)
		throws Exception {
		Object[] remoteParameterValues = new Object[parameterValues.length];

		for (int i = 0; i < parameterValues.length; i++) {
			if (parameterValues[i] != null) {
				remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
			}
		}

		Class<?> remoteModelClass = _pmMessageRemoteModel.getClass();

		ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

		Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

		for (int i = 0; i < parameterTypes.length; i++) {
			if (parameterTypes[i].isPrimitive()) {
				remoteParameterTypes[i] = parameterTypes[i];
			}
			else {
				String parameterTypeName = parameterTypes[i].getName();

				remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
			}
		}

		Method method = remoteModelClass.getMethod(methodName,
				remoteParameterTypes);

		Object returnValue = method.invoke(_pmMessageRemoteModel,
				remoteParameterValues);

		if (returnValue != null) {
			returnValue = ClpSerializer.translateOutput(returnValue);
		}

		return returnValue;
	}

	@Override
	public void persist() throws SystemException {
		if (this.isNew()) {
			PMMessageLocalServiceUtil.addPMMessage(this);
		}
		else {
			PMMessageLocalServiceUtil.updatePMMessage(this);
		}
	}

	@Override
	public PMMessage toEscapedModel() {
		return (PMMessage)ProxyUtil.newProxyInstance(PMMessage.class.getClassLoader(),
			new Class[] { PMMessage.class }, new AutoEscapeBeanHandler(this));
	}

	@Override
	public Object clone() {
		PMMessageClp clone = new PMMessageClp();

		clone.setMessageId(getMessageId());
		clone.setSubject(getSubject());
		clone.setBody(getBody());
		clone.setUrl(getUrl());
		clone.setParentMessageId(getParentMessageId());
		clone.setOwnerId(getOwnerId());
		clone.setOwnerName(getOwnerName());
		clone.setPostedDate(getPostedDate());
		clone.setRecepients(getRecepients());

		return clone;
	}

	@Override
	public int compareTo(PMMessage pmMessage) {
		int value = 0;

		value = DateUtil.compareTo(getPostedDate(), pmMessage.getPostedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof PMMessageClp)) {
			return false;
		}

		PMMessageClp pmMessage = (PMMessageClp)obj;

		long primaryKey = pmMessage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	public Class<?> getClpSerializerClass() {
		return _clpSerializerClass;
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(19);

		sb.append("{messageId=");
		sb.append(getMessageId());
		sb.append(", subject=");
		sb.append(getSubject());
		sb.append(", body=");
		sb.append(getBody());
		sb.append(", url=");
		sb.append(getUrl());
		sb.append(", parentMessageId=");
		sb.append(getParentMessageId());
		sb.append(", ownerId=");
		sb.append(getOwnerId());
		sb.append(", ownerName=");
		sb.append(getOwnerName());
		sb.append(", postedDate=");
		sb.append(getPostedDate());
		sb.append(", recepients=");
		sb.append(getRecepients());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(31);

		sb.append("<model><model-name>");
		sb.append("gov.va.caret.model.PMMessage");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>messageId</column-name><column-value><![CDATA[");
		sb.append(getMessageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subject</column-name><column-value><![CDATA[");
		sb.append(getSubject());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>body</column-name><column-value><![CDATA[");
		sb.append(getBody());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>url</column-name><column-value><![CDATA[");
		sb.append(getUrl());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>parentMessageId</column-name><column-value><![CDATA[");
		sb.append(getParentMessageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ownerId</column-name><column-value><![CDATA[");
		sb.append(getOwnerId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ownerName</column-name><column-value><![CDATA[");
		sb.append(getOwnerName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>postedDate</column-name><column-value><![CDATA[");
		sb.append(getPostedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>recepients</column-name><column-value><![CDATA[");
		sb.append(getRecepients());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private long _messageId;
	private String _subject;
	private String _body;
	private String _url;
	private long _parentMessageId;
	private long _ownerId;
	private String _ownerName;
	private Date _postedDate;
	private String _recepients;
	private BaseModel<?> _pmMessageRemoteModel;
	private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;
}