/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class PMDeletedMessageSoap implements Serializable {
	public static PMDeletedMessageSoap toSoapModel(PMDeletedMessage model) {
		PMDeletedMessageSoap soapModel = new PMDeletedMessageSoap();

		soapModel.setDeletedMessageId(model.getDeletedMessageId());
		soapModel.setMessageId(model.getMessageId());
		soapModel.setOwnerId(model.getOwnerId());
		soapModel.setDeletedDate(model.getDeletedDate());

		return soapModel;
	}

	public static PMDeletedMessageSoap[] toSoapModels(PMDeletedMessage[] models) {
		PMDeletedMessageSoap[] soapModels = new PMDeletedMessageSoap[models.length];

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModel(models[i]);
		}

		return soapModels;
	}

	public static PMDeletedMessageSoap[][] toSoapModels(
		PMDeletedMessage[][] models) {
		PMDeletedMessageSoap[][] soapModels = null;

		if (models.length > 0) {
			soapModels = new PMDeletedMessageSoap[models.length][models[0].length];
		}
		else {
			soapModels = new PMDeletedMessageSoap[0][0];
		}

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModels(models[i]);
		}

		return soapModels;
	}

	public static PMDeletedMessageSoap[] toSoapModels(
		List<PMDeletedMessage> models) {
		List<PMDeletedMessageSoap> soapModels = new ArrayList<PMDeletedMessageSoap>(models.size());

		for (PMDeletedMessage model : models) {
			soapModels.add(toSoapModel(model));
		}

		return soapModels.toArray(new PMDeletedMessageSoap[soapModels.size()]);
	}

	public PMDeletedMessageSoap() {
	}

	public long getPrimaryKey() {
		return _deletedMessageId;
	}

	public void setPrimaryKey(long pk) {
		setDeletedMessageId(pk);
	}

	public long getDeletedMessageId() {
		return _deletedMessageId;
	}

	public void setDeletedMessageId(long deletedMessageId) {
		_deletedMessageId = deletedMessageId;
	}

	public long getMessageId() {
		return _messageId;
	}

	public void setMessageId(long messageId) {
		_messageId = messageId;
	}

	public long getOwnerId() {
		return _ownerId;
	}

	public void setOwnerId(long ownerId) {
		_ownerId = ownerId;
	}

	public Date getDeletedDate() {
		return _deletedDate;
	}

	public void setDeletedDate(Date deletedDate) {
		_deletedDate = deletedDate;
	}

	private long _deletedMessageId;
	private long _messageId;
	private long _ownerId;
	private Date _deletedDate;
}