package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.NotifLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class NotifClp extends BaseModelImpl<Notif> implements Notif {
    private long _notifId;
    private long _ownerId;
    private String _type;
    private Date _discontinueDate;
    private BaseModel<?> _notifRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public NotifClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Notif.class;
    }

    @Override
    public String getModelClassName() {
        return Notif.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _notifId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setNotifId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _notifId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("notifId", getNotifId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("type", getType());
        attributes.put("discontinueDate", getDiscontinueDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long notifId = (Long) attributes.get("notifId");

        if (notifId != null) {
            setNotifId(notifId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date discontinueDate = (Date) attributes.get("discontinueDate");

        if (discontinueDate != null) {
            setDiscontinueDate(discontinueDate);
        }
    }

    @Override
    public long getNotifId() {
        return _notifId;
    }

    @Override
    public void setNotifId(long notifId) {
        _notifId = notifId;

        if (_notifRemoteModel != null) {
            try {
                Class<?> clazz = _notifRemoteModel.getClass();

                Method method = clazz.getMethod("setNotifId", long.class);

                method.invoke(_notifRemoteModel, notifId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;

        if (_notifRemoteModel != null) {
            try {
                Class<?> clazz = _notifRemoteModel.getClass();

                Method method = clazz.getMethod("setOwnerId", long.class);

                method.invoke(_notifRemoteModel, ownerId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getType() {
        return _type;
    }

    @Override
    public void setType(String type) {
        _type = type;

        if (_notifRemoteModel != null) {
            try {
                Class<?> clazz = _notifRemoteModel.getClass();

                Method method = clazz.getMethod("setType", String.class);

                method.invoke(_notifRemoteModel, type);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getDiscontinueDate() {
        return _discontinueDate;
    }

    @Override
    public void setDiscontinueDate(Date discontinueDate) {
        _discontinueDate = discontinueDate;

        if (_notifRemoteModel != null) {
            try {
                Class<?> clazz = _notifRemoteModel.getClass();

                Method method = clazz.getMethod("setDiscontinueDate", Date.class);

                method.invoke(_notifRemoteModel, discontinueDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getNotifRemoteModel() {
        return _notifRemoteModel;
    }

    public void setNotifRemoteModel(BaseModel<?> notifRemoteModel) {
        _notifRemoteModel = notifRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _notifRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_notifRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            NotifLocalServiceUtil.addNotif(this);
        } else {
            NotifLocalServiceUtil.updateNotif(this);
        }
    }

    @Override
    public Notif toEscapedModel() {
        return (Notif) ProxyUtil.newProxyInstance(Notif.class.getClassLoader(),
            new Class[] { Notif.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        NotifClp clone = new NotifClp();

        clone.setNotifId(getNotifId());
        clone.setOwnerId(getOwnerId());
        clone.setType(getType());
        clone.setDiscontinueDate(getDiscontinueDate());

        return clone;
    }

    @Override
    public int compareTo(Notif notif) {
        long primaryKey = notif.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof NotifClp)) {
            return false;
        }

        NotifClp notif = (NotifClp) obj;

        long primaryKey = notif.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{notifId=");
        sb.append(getNotifId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", discontinueDate=");
        sb.append(getDiscontinueDate());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Notif");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>notifId</column-name><column-value><![CDATA[");
        sb.append(getNotifId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>discontinueDate</column-name><column-value><![CDATA[");
        sb.append(getDiscontinueDate());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
