package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Note}.
 * </p>
 *
 * @author caret
 * @see Note
 * @generated
 */
public class NoteWrapper implements Note, ModelWrapper<Note> {
    private Note _note;

    public NoteWrapper(Note note) {
        _note = note;
    }

    @Override
    public Class<?> getModelClass() {
        return Note.class;
    }

    @Override
    public String getModelClassName() {
        return Note.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("uuid", getUuid());
        attributes.put("noteId", getNoteId());
        attributes.put("value", getValue());
        attributes.put("userId", getUserId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("groupId", getGroupId());
        attributes.put("chainId", getChainId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        String uuid = (String) attributes.get("uuid");

        if (uuid != null) {
            setUuid(uuid);
        }

        Long noteId = (Long) attributes.get("noteId");

        if (noteId != null) {
            setNoteId(noteId);
        }

        String value = (String) attributes.get("value");

        if (value != null) {
            setValue(value);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }

        Long chainId = (Long) attributes.get("chainId");

        if (chainId != null) {
            setChainId(chainId);
        }
    }

    /**
    * Returns the primary key of this note.
    *
    * @return the primary key of this note
    */
    @Override
    public long getPrimaryKey() {
        return _note.getPrimaryKey();
    }

    /**
    * Sets the primary key of this note.
    *
    * @param primaryKey the primary key of this note
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _note.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the uuid of this note.
    *
    * @return the uuid of this note
    */
    @Override
    public java.lang.String getUuid() {
        return _note.getUuid();
    }

    /**
    * Sets the uuid of this note.
    *
    * @param uuid the uuid of this note
    */
    @Override
    public void setUuid(java.lang.String uuid) {
        _note.setUuid(uuid);
    }

    /**
    * Returns the note ID of this note.
    *
    * @return the note ID of this note
    */
    @Override
    public long getNoteId() {
        return _note.getNoteId();
    }

    /**
    * Sets the note ID of this note.
    *
    * @param noteId the note ID of this note
    */
    @Override
    public void setNoteId(long noteId) {
        _note.setNoteId(noteId);
    }

    /**
    * Returns the value of this note.
    *
    * @return the value of this note
    */
    @Override
    public java.lang.String getValue() {
        return _note.getValue();
    }

    /**
    * Sets the value of this note.
    *
    * @param value the value of this note
    */
    @Override
    public void setValue(java.lang.String value) {
        _note.setValue(value);
    }

    /**
    * Returns the user ID of this note.
    *
    * @return the user ID of this note
    */
    @Override
    public long getUserId() {
        return _note.getUserId();
    }

    /**
    * Sets the user ID of this note.
    *
    * @param userId the user ID of this note
    */
    @Override
    public void setUserId(long userId) {
        _note.setUserId(userId);
    }

    /**
    * Returns the user uuid of this note.
    *
    * @return the user uuid of this note
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.lang.String getUserUuid()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _note.getUserUuid();
    }

    /**
    * Sets the user uuid of this note.
    *
    * @param userUuid the user uuid of this note
    */
    @Override
    public void setUserUuid(java.lang.String userUuid) {
        _note.setUserUuid(userUuid);
    }

    /**
    * Returns the creation date of this note.
    *
    * @return the creation date of this note
    */
    @Override
    public java.util.Date getCreationDate() {
        return _note.getCreationDate();
    }

    /**
    * Sets the creation date of this note.
    *
    * @param creationDate the creation date of this note
    */
    @Override
    public void setCreationDate(java.util.Date creationDate) {
        _note.setCreationDate(creationDate);
    }

    /**
    * Returns the group ID of this note.
    *
    * @return the group ID of this note
    */
    @Override
    public long getGroupId() {
        return _note.getGroupId();
    }

    /**
    * Sets the group ID of this note.
    *
    * @param groupId the group ID of this note
    */
    @Override
    public void setGroupId(long groupId) {
        _note.setGroupId(groupId);
    }

    /**
    * Returns the chain ID of this note.
    *
    * @return the chain ID of this note
    */
    @Override
    public long getChainId() {
        return _note.getChainId();
    }

    /**
    * Sets the chain ID of this note.
    *
    * @param chainId the chain ID of this note
    */
    @Override
    public void setChainId(long chainId) {
        _note.setChainId(chainId);
    }

    @Override
    public boolean isNew() {
        return _note.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _note.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _note.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _note.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _note.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _note.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _note.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _note.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _note.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _note.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _note.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new NoteWrapper((Note) _note.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Note note) {
        return _note.compareTo(note);
    }

    @Override
    public int hashCode() {
        return _note.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Note> toCacheModel() {
        return _note.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Note toEscapedModel() {
        return new NoteWrapper(_note.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Note toUnescapedModel() {
        return new NoteWrapper(_note.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _note.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _note.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _note.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof NoteWrapper)) {
            return false;
        }

        NoteWrapper noteWrapper = (NoteWrapper) obj;

        if (Validator.equals(_note, noteWrapper._note)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Note getWrappedNote() {
        return _note;
    }

    @Override
    public Note getWrappedModel() {
        return _note;
    }

    @Override
    public void resetOriginalValues() {
        _note.resetOriginalValues();
    }
}
