package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.NoteLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class NoteClp extends BaseModelImpl<Note> implements Note {
    private String _uuid;
    private long _noteId;
    private String _value;
    private long _userId;
    private String _userUuid;
    private Date _creationDate;
    private long _groupId;
    private long _chainId;
    private BaseModel<?> _noteRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public NoteClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Note.class;
    }

    @Override
    public String getModelClassName() {
        return Note.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _noteId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setNoteId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _noteId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("uuid", getUuid());
        attributes.put("noteId", getNoteId());
        attributes.put("value", getValue());
        attributes.put("userId", getUserId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("groupId", getGroupId());
        attributes.put("chainId", getChainId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        String uuid = (String) attributes.get("uuid");

        if (uuid != null) {
            setUuid(uuid);
        }

        Long noteId = (Long) attributes.get("noteId");

        if (noteId != null) {
            setNoteId(noteId);
        }

        String value = (String) attributes.get("value");

        if (value != null) {
            setValue(value);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }

        Long chainId = (Long) attributes.get("chainId");

        if (chainId != null) {
            setChainId(chainId);
        }
    }

    @Override
    public String getUuid() {
        return _uuid;
    }

    @Override
    public void setUuid(String uuid) {
        _uuid = uuid;

        if (_noteRemoteModel != null) {
            try {
                Class<?> clazz = _noteRemoteModel.getClass();

                Method method = clazz.getMethod("setUuid", String.class);

                method.invoke(_noteRemoteModel, uuid);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getNoteId() {
        return _noteId;
    }

    @Override
    public void setNoteId(long noteId) {
        _noteId = noteId;

        if (_noteRemoteModel != null) {
            try {
                Class<?> clazz = _noteRemoteModel.getClass();

                Method method = clazz.getMethod("setNoteId", long.class);

                method.invoke(_noteRemoteModel, noteId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getValue() {
        return _value;
    }

    @Override
    public void setValue(String value) {
        _value = value;

        if (_noteRemoteModel != null) {
            try {
                Class<?> clazz = _noteRemoteModel.getClass();

                Method method = clazz.getMethod("setValue", String.class);

                method.invoke(_noteRemoteModel, value);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_noteRemoteModel != null) {
            try {
                Class<?> clazz = _noteRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_noteRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_noteRemoteModel != null) {
            try {
                Class<?> clazz = _noteRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_noteRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_noteRemoteModel != null) {
            try {
                Class<?> clazz = _noteRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_noteRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getChainId() {
        return _chainId;
    }

    @Override
    public void setChainId(long chainId) {
        _chainId = chainId;

        if (_noteRemoteModel != null) {
            try {
                Class<?> clazz = _noteRemoteModel.getClass();

                Method method = clazz.getMethod("setChainId", long.class);

                method.invoke(_noteRemoteModel, chainId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getNoteRemoteModel() {
        return _noteRemoteModel;
    }

    public void setNoteRemoteModel(BaseModel<?> noteRemoteModel) {
        _noteRemoteModel = noteRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _noteRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_noteRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            NoteLocalServiceUtil.addNote(this);
        } else {
            NoteLocalServiceUtil.updateNote(this);
        }
    }

    @Override
    public Note toEscapedModel() {
        return (Note) ProxyUtil.newProxyInstance(Note.class.getClassLoader(),
            new Class[] { Note.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        NoteClp clone = new NoteClp();

        clone.setUuid(getUuid());
        clone.setNoteId(getNoteId());
        clone.setValue(getValue());
        clone.setUserId(getUserId());
        clone.setCreationDate(getCreationDate());
        clone.setGroupId(getGroupId());
        clone.setChainId(getChainId());

        return clone;
    }

    @Override
    public int compareTo(Note note) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), note.getCreationDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof NoteClp)) {
            return false;
        }

        NoteClp note = (NoteClp) obj;

        long primaryKey = note.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(15);

        sb.append("{uuid=");
        sb.append(getUuid());
        sb.append(", noteId=");
        sb.append(getNoteId());
        sb.append(", value=");
        sb.append(getValue());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append(", chainId=");
        sb.append(getChainId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(25);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Note");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>uuid</column-name><column-value><![CDATA[");
        sb.append(getUuid());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>noteId</column-name><column-value><![CDATA[");
        sb.append(getNoteId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>value</column-name><column-value><![CDATA[");
        sb.append(getValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>chainId</column-name><column-value><![CDATA[");
        sb.append(getChainId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
