package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Facil}.
 * </p>
 *
 * @author caret
 * @see Facil
 * @generated
 */
public class FacilWrapper implements Facil, ModelWrapper<Facil> {
    private Facil _facil;

    public FacilWrapper(Facil facil) {
        _facil = facil;
    }

    @Override
    public Class<?> getModelClass() {
        return Facil.class;
    }

    @Override
    public String getModelClassName() {
        return Facil.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("facilId", getFacilId());
        attributes.put("facilityNumber", getFacilityNumber());
        attributes.put("location", getLocation());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long facilId = (Long) attributes.get("facilId");

        if (facilId != null) {
            setFacilId(facilId);
        }

        String facilityNumber = (String) attributes.get("facilityNumber");

        if (facilityNumber != null) {
            setFacilityNumber(facilityNumber);
        }

        String location = (String) attributes.get("location");

        if (location != null) {
            setLocation(location);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    /**
    * Returns the primary key of this facil.
    *
    * @return the primary key of this facil
    */
    @Override
    public long getPrimaryKey() {
        return _facil.getPrimaryKey();
    }

    /**
    * Sets the primary key of this facil.
    *
    * @param primaryKey the primary key of this facil
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _facil.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the facil ID of this facil.
    *
    * @return the facil ID of this facil
    */
    @Override
    public long getFacilId() {
        return _facil.getFacilId();
    }

    /**
    * Sets the facil ID of this facil.
    *
    * @param facilId the facil ID of this facil
    */
    @Override
    public void setFacilId(long facilId) {
        _facil.setFacilId(facilId);
    }

    /**
    * Returns the facility number of this facil.
    *
    * @return the facility number of this facil
    */
    @Override
    public java.lang.String getFacilityNumber() {
        return _facil.getFacilityNumber();
    }

    /**
    * Sets the facility number of this facil.
    *
    * @param facilityNumber the facility number of this facil
    */
    @Override
    public void setFacilityNumber(java.lang.String facilityNumber) {
        _facil.setFacilityNumber(facilityNumber);
    }

    /**
    * Returns the location of this facil.
    *
    * @return the location of this facil
    */
    @Override
    public java.lang.String getLocation() {
        return _facil.getLocation();
    }

    /**
    * Sets the location of this facil.
    *
    * @param location the location of this facil
    */
    @Override
    public void setLocation(java.lang.String location) {
        _facil.setLocation(location);
    }

    /**
    * Returns the group ID of this facil.
    *
    * @return the group ID of this facil
    */
    @Override
    public long getGroupId() {
        return _facil.getGroupId();
    }

    /**
    * Sets the group ID of this facil.
    *
    * @param groupId the group ID of this facil
    */
    @Override
    public void setGroupId(long groupId) {
        _facil.setGroupId(groupId);
    }

    @Override
    public boolean isNew() {
        return _facil.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _facil.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _facil.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _facil.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _facil.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _facil.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _facil.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _facil.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _facil.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _facil.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _facil.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new FacilWrapper((Facil) _facil.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Facil facil) {
        return _facil.compareTo(facil);
    }

    @Override
    public int hashCode() {
        return _facil.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Facil> toCacheModel() {
        return _facil.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Facil toEscapedModel() {
        return new FacilWrapper(_facil.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Facil toUnescapedModel() {
        return new FacilWrapper(_facil.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _facil.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _facil.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _facil.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof FacilWrapper)) {
            return false;
        }

        FacilWrapper facilWrapper = (FacilWrapper) obj;

        if (Validator.equals(_facil, facilWrapper._facil)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Facil getWrappedFacil() {
        return _facil;
    }

    @Override
    public Facil getWrappedModel() {
        return _facil;
    }

    @Override
    public void resetOriginalValues() {
        _facil.resetOriginalValues();
    }
}
