package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.FacilLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class FacilClp extends BaseModelImpl<Facil> implements Facil {
    private long _facilId;
    private String _facilityNumber;
    private String _location;
    private long _groupId;
    private BaseModel<?> _facilRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public FacilClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Facil.class;
    }

    @Override
    public String getModelClassName() {
        return Facil.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _facilId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setFacilId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _facilId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("facilId", getFacilId());
        attributes.put("facilityNumber", getFacilityNumber());
        attributes.put("location", getLocation());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long facilId = (Long) attributes.get("facilId");

        if (facilId != null) {
            setFacilId(facilId);
        }

        String facilityNumber = (String) attributes.get("facilityNumber");

        if (facilityNumber != null) {
            setFacilityNumber(facilityNumber);
        }

        String location = (String) attributes.get("location");

        if (location != null) {
            setLocation(location);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getFacilId() {
        return _facilId;
    }

    @Override
    public void setFacilId(long facilId) {
        _facilId = facilId;

        if (_facilRemoteModel != null) {
            try {
                Class<?> clazz = _facilRemoteModel.getClass();

                Method method = clazz.getMethod("setFacilId", long.class);

                method.invoke(_facilRemoteModel, facilId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getFacilityNumber() {
        return _facilityNumber;
    }

    @Override
    public void setFacilityNumber(String facilityNumber) {
        _facilityNumber = facilityNumber;

        if (_facilRemoteModel != null) {
            try {
                Class<?> clazz = _facilRemoteModel.getClass();

                Method method = clazz.getMethod("setFacilityNumber",
                        String.class);

                method.invoke(_facilRemoteModel, facilityNumber);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLocation() {
        return _location;
    }

    @Override
    public void setLocation(String location) {
        _location = location;

        if (_facilRemoteModel != null) {
            try {
                Class<?> clazz = _facilRemoteModel.getClass();

                Method method = clazz.getMethod("setLocation", String.class);

                method.invoke(_facilRemoteModel, location);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_facilRemoteModel != null) {
            try {
                Class<?> clazz = _facilRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_facilRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getFacilRemoteModel() {
        return _facilRemoteModel;
    }

    public void setFacilRemoteModel(BaseModel<?> facilRemoteModel) {
        _facilRemoteModel = facilRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _facilRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_facilRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            FacilLocalServiceUtil.addFacil(this);
        } else {
            FacilLocalServiceUtil.updateFacil(this);
        }
    }

    @Override
    public Facil toEscapedModel() {
        return (Facil) ProxyUtil.newProxyInstance(Facil.class.getClassLoader(),
            new Class[] { Facil.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        FacilClp clone = new FacilClp();

        clone.setFacilId(getFacilId());
        clone.setFacilityNumber(getFacilityNumber());
        clone.setLocation(getLocation());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(Facil facil) {
        long primaryKey = facil.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof FacilClp)) {
            return false;
        }

        FacilClp facil = (FacilClp) obj;

        long primaryKey = facil.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{facilId=");
        sb.append(getFacilId());
        sb.append(", facilityNumber=");
        sb.append(getFacilityNumber());
        sb.append(", location=");
        sb.append(getLocation());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(16);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Facil");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>facilId</column-name><column-value><![CDATA[");
        sb.append(getFacilId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>facilityNumber</column-name><column-value><![CDATA[");
        sb.append(getFacilityNumber());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>location</column-name><column-value><![CDATA[");
        sb.append(getLocation());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
