package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.EELgLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class EELgClp extends BaseModelImpl<EELg> implements EELg {
    private long _eeLgId;
    private String _ICN;
    private Date _dateOfDeath;
    private String _priorityGroup;
    private Long _scTotDisabRating;
    private Boolean _scIndicator;
    private Boolean _medicaidEligibility;
    private Date _createdDate;
    private BaseModel<?> _eeLgRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public EELgClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return EELg.class;
    }

    @Override
    public String getModelClassName() {
        return EELg.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _eeLgId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setEeLgId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _eeLgId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("eeLgId", getEeLgId());
        attributes.put("ICN", getICN());
        attributes.put("dateOfDeath", getDateOfDeath());
        attributes.put("priorityGroup", getPriorityGroup());
        attributes.put("scTotDisabRating", getScTotDisabRating());
        attributes.put("scIndicator", getScIndicator());
        attributes.put("medicaidEligibility", getMedicaidEligibility());
        attributes.put("createdDate", getCreatedDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long eeLgId = (Long) attributes.get("eeLgId");

        if (eeLgId != null) {
            setEeLgId(eeLgId);
        }

        String ICN = (String) attributes.get("ICN");

        if (ICN != null) {
            setICN(ICN);
        }

        Date dateOfDeath = (Date) attributes.get("dateOfDeath");

        if (dateOfDeath != null) {
            setDateOfDeath(dateOfDeath);
        }

        String priorityGroup = (String) attributes.get("priorityGroup");

        if (priorityGroup != null) {
            setPriorityGroup(priorityGroup);
        }

        Long scTotDisabRating = (Long) attributes.get("scTotDisabRating");

        if (scTotDisabRating != null) {
            setScTotDisabRating(scTotDisabRating);
        }

        Boolean scIndicator = (Boolean) attributes.get("scIndicator");

        if (scIndicator != null) {
            setScIndicator(scIndicator);
        }

        Boolean medicaidEligibility = (Boolean) attributes.get(
                "medicaidEligibility");

        if (medicaidEligibility != null) {
            setMedicaidEligibility(medicaidEligibility);
        }

        Date createdDate = (Date) attributes.get("createdDate");

        if (createdDate != null) {
            setCreatedDate(createdDate);
        }
    }

    @Override
    public long getEeLgId() {
        return _eeLgId;
    }

    @Override
    public void setEeLgId(long eeLgId) {
        _eeLgId = eeLgId;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setEeLgId", long.class);

                method.invoke(_eeLgRemoteModel, eeLgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getICN() {
        return _ICN;
    }

    @Override
    public void setICN(String ICN) {
        _ICN = ICN;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setICN", String.class);

                method.invoke(_eeLgRemoteModel, ICN);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getDateOfDeath() {
        return _dateOfDeath;
    }

    @Override
    public void setDateOfDeath(Date dateOfDeath) {
        _dateOfDeath = dateOfDeath;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setDateOfDeath", Date.class);

                method.invoke(_eeLgRemoteModel, dateOfDeath);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPriorityGroup() {
        return _priorityGroup;
    }

    @Override
    public void setPriorityGroup(String priorityGroup) {
        _priorityGroup = priorityGroup;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setPriorityGroup", String.class);

                method.invoke(_eeLgRemoteModel, priorityGroup);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Long getScTotDisabRating() {
        return _scTotDisabRating;
    }

    @Override
    public void setScTotDisabRating(Long scTotDisabRating) {
        _scTotDisabRating = scTotDisabRating;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setScTotDisabRating",
                        Long.class);

                method.invoke(_eeLgRemoteModel, scTotDisabRating);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Boolean getScIndicator() {
        return _scIndicator;
    }

    @Override
    public void setScIndicator(Boolean scIndicator) {
        _scIndicator = scIndicator;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setScIndicator", Boolean.class);

                method.invoke(_eeLgRemoteModel, scIndicator);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Boolean getMedicaidEligibility() {
        return _medicaidEligibility;
    }

    @Override
    public void setMedicaidEligibility(Boolean medicaidEligibility) {
        _medicaidEligibility = medicaidEligibility;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setMedicaidEligibility",
                        Boolean.class);

                method.invoke(_eeLgRemoteModel, medicaidEligibility);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreatedDate() {
        return _createdDate;
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        _createdDate = createdDate;

        if (_eeLgRemoteModel != null) {
            try {
                Class<?> clazz = _eeLgRemoteModel.getClass();

                Method method = clazz.getMethod("setCreatedDate", Date.class);

                method.invoke(_eeLgRemoteModel, createdDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getEELgRemoteModel() {
        return _eeLgRemoteModel;
    }

    public void setEELgRemoteModel(BaseModel<?> eeLgRemoteModel) {
        _eeLgRemoteModel = eeLgRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _eeLgRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_eeLgRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            EELgLocalServiceUtil.addEELg(this);
        } else {
            EELgLocalServiceUtil.updateEELg(this);
        }
    }

    @Override
    public EELg toEscapedModel() {
        return (EELg) ProxyUtil.newProxyInstance(EELg.class.getClassLoader(),
            new Class[] { EELg.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        EELgClp clone = new EELgClp();

        clone.setEeLgId(getEeLgId());
        clone.setICN(getICN());
        clone.setDateOfDeath(getDateOfDeath());
        clone.setPriorityGroup(getPriorityGroup());
        clone.setScTotDisabRating(getScTotDisabRating());
        clone.setScIndicator(getScIndicator());
        clone.setMedicaidEligibility(getMedicaidEligibility());
        clone.setCreatedDate(getCreatedDate());

        return clone;
    }

    @Override
    public int compareTo(EELg eeLg) {
        int value = 0;

        value = DateUtil.compareTo(getCreatedDate(), eeLg.getCreatedDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof EELgClp)) {
            return false;
        }

        EELgClp eeLg = (EELgClp) obj;

        long primaryKey = eeLg.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{eeLgId=");
        sb.append(getEeLgId());
        sb.append(", ICN=");
        sb.append(getICN());
        sb.append(", dateOfDeath=");
        sb.append(getDateOfDeath());
        sb.append(", priorityGroup=");
        sb.append(getPriorityGroup());
        sb.append(", scTotDisabRating=");
        sb.append(getScTotDisabRating());
        sb.append(", scIndicator=");
        sb.append(getScIndicator());
        sb.append(", medicaidEligibility=");
        sb.append(getMedicaidEligibility());
        sb.append(", createdDate=");
        sb.append(getCreatedDate());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(28);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.EELg");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>eeLgId</column-name><column-value><![CDATA[");
        sb.append(getEeLgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ICN</column-name><column-value><![CDATA[");
        sb.append(getICN());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dateOfDeath</column-name><column-value><![CDATA[");
        sb.append(getDateOfDeath());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>priorityGroup</column-name><column-value><![CDATA[");
        sb.append(getPriorityGroup());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>scTotDisabRating</column-name><column-value><![CDATA[");
        sb.append(getScTotDisabRating());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>scIndicator</column-name><column-value><![CDATA[");
        sb.append(getScIndicator());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>medicaidEligibility</column-name><column-value><![CDATA[");
        sb.append(getMedicaidEligibility());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>createdDate</column-name><column-value><![CDATA[");
        sb.append(getCreatedDate());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
