package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.CryptoLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class CryptoClp extends BaseModelImpl<Crypto> implements Crypto {
    private long _cryptoId;
    private long _ownerId;
    private String _type;
    private String _value;
    private int _hcode;
    private BaseModel<?> _cryptoRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public CryptoClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Crypto.class;
    }

    @Override
    public String getModelClassName() {
        return Crypto.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _cryptoId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCryptoId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _cryptoId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("cryptoId", getCryptoId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("type", getType());
        attributes.put("value", getValue());
        attributes.put("hcode", getHcode());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long cryptoId = (Long) attributes.get("cryptoId");

        if (cryptoId != null) {
            setCryptoId(cryptoId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        String value = (String) attributes.get("value");

        if (value != null) {
            setValue(value);
        }

        Integer hcode = (Integer) attributes.get("hcode");

        if (hcode != null) {
            setHcode(hcode);
        }
    }

    @Override
    public long getCryptoId() {
        return _cryptoId;
    }

    @Override
    public void setCryptoId(long cryptoId) {
        _cryptoId = cryptoId;

        if (_cryptoRemoteModel != null) {
            try {
                Class<?> clazz = _cryptoRemoteModel.getClass();

                Method method = clazz.getMethod("setCryptoId", long.class);

                method.invoke(_cryptoRemoteModel, cryptoId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getOwnerId() {
        return _ownerId;
    }

    @Override
    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;

        if (_cryptoRemoteModel != null) {
            try {
                Class<?> clazz = _cryptoRemoteModel.getClass();

                Method method = clazz.getMethod("setOwnerId", long.class);

                method.invoke(_cryptoRemoteModel, ownerId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getType() {
        return _type;
    }

    @Override
    public void setType(String type) {
        _type = type;

        if (_cryptoRemoteModel != null) {
            try {
                Class<?> clazz = _cryptoRemoteModel.getClass();

                Method method = clazz.getMethod("setType", String.class);

                method.invoke(_cryptoRemoteModel, type);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getValue() {
        return _value;
    }

    @Override
    public void setValue(String value) {
        _value = value;

        if (_cryptoRemoteModel != null) {
            try {
                Class<?> clazz = _cryptoRemoteModel.getClass();

                Method method = clazz.getMethod("setValue", String.class);

                method.invoke(_cryptoRemoteModel, value);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public int getHcode() {
        return _hcode;
    }

    @Override
    public void setHcode(int hcode) {
        _hcode = hcode;

        if (_cryptoRemoteModel != null) {
            try {
                Class<?> clazz = _cryptoRemoteModel.getClass();

                Method method = clazz.getMethod("setHcode", int.class);

                method.invoke(_cryptoRemoteModel, hcode);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getCryptoRemoteModel() {
        return _cryptoRemoteModel;
    }

    public void setCryptoRemoteModel(BaseModel<?> cryptoRemoteModel) {
        _cryptoRemoteModel = cryptoRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _cryptoRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_cryptoRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CryptoLocalServiceUtil.addCrypto(this);
        } else {
            CryptoLocalServiceUtil.updateCrypto(this);
        }
    }

    @Override
    public Crypto toEscapedModel() {
        return (Crypto) ProxyUtil.newProxyInstance(Crypto.class.getClassLoader(),
            new Class[] { Crypto.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        CryptoClp clone = new CryptoClp();

        clone.setCryptoId(getCryptoId());
        clone.setOwnerId(getOwnerId());
        clone.setType(getType());
        clone.setValue(getValue());
        clone.setHcode(getHcode());

        return clone;
    }

    @Override
    public int compareTo(Crypto crypto) {
        long primaryKey = crypto.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CryptoClp)) {
            return false;
        }

        CryptoClp crypto = (CryptoClp) obj;

        long primaryKey = crypto.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{cryptoId=");
        sb.append(getCryptoId());
        sb.append(", ownerId=");
        sb.append(getOwnerId());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", value=");
        sb.append(getValue());
        sb.append(", hcode=");
        sb.append(getHcode());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Crypto");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>cryptoId</column-name><column-value><![CDATA[");
        sb.append(getCryptoId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>ownerId</column-name><column-value><![CDATA[");
        sb.append(getOwnerId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>value</column-name><column-value><![CDATA[");
        sb.append(getValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>hcode</column-name><column-value><![CDATA[");
        sb.append(getHcode());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
