package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class CespSoap implements Serializable {
    private long _cespId;
    private long _callId;
    private long _createdByPersnId;
    private Date _creationDate;
    private String _step;
    private String _status;
    private String _referredBy;
    private String _assignedCslPersnId;
    private String _goals;
    private String _planProgressBarrier;
    private String _cespClosed;
    private String _cespClosedReason;
    private String _goalsReached;

    public CespSoap() {
    }

    public static CespSoap toSoapModel(Cesp model) {
        CespSoap soapModel = new CespSoap();

        soapModel.setCespId(model.getCespId());
        soapModel.setCallId(model.getCallId());
        soapModel.setCreatedByPersnId(model.getCreatedByPersnId());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setStep(model.getStep());
        soapModel.setStatus(model.getStatus());
        soapModel.setReferredBy(model.getReferredBy());
        soapModel.setAssignedCslPersnId(model.getAssignedCslPersnId());
        soapModel.setGoals(model.getGoals());
        soapModel.setPlanProgressBarrier(model.getPlanProgressBarrier());
        soapModel.setCespClosed(model.getCespClosed());
        soapModel.setCespClosedReason(model.getCespClosedReason());
        soapModel.setGoalsReached(model.getGoalsReached());

        return soapModel;
    }

    public static CespSoap[] toSoapModels(Cesp[] models) {
        CespSoap[] soapModels = new CespSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static CespSoap[][] toSoapModels(Cesp[][] models) {
        CespSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new CespSoap[models.length][models[0].length];
        } else {
            soapModels = new CespSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static CespSoap[] toSoapModels(List<Cesp> models) {
        List<CespSoap> soapModels = new ArrayList<CespSoap>(models.size());

        for (Cesp model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new CespSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _cespId;
    }

    public void setPrimaryKey(long pk) {
        setCespId(pk);
    }

    public long getCespId() {
        return _cespId;
    }

    public void setCespId(long cespId) {
        _cespId = cespId;
    }

    public long getCallId() {
        return _callId;
    }

    public void setCallId(long callId) {
        _callId = callId;
    }

    public long getCreatedByPersnId() {
        return _createdByPersnId;
    }

    public void setCreatedByPersnId(long createdByPersnId) {
        _createdByPersnId = createdByPersnId;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public String getStep() {
        return _step;
    }

    public void setStep(String step) {
        _step = step;
    }

    public String getStatus() {
        return _status;
    }

    public void setStatus(String status) {
        _status = status;
    }

    public String getReferredBy() {
        return _referredBy;
    }

    public void setReferredBy(String referredBy) {
        _referredBy = referredBy;
    }

    public String getAssignedCslPersnId() {
        return _assignedCslPersnId;
    }

    public void setAssignedCslPersnId(String assignedCslPersnId) {
        _assignedCslPersnId = assignedCslPersnId;
    }

    public String getGoals() {
        return _goals;
    }

    public void setGoals(String goals) {
        _goals = goals;
    }

    public String getPlanProgressBarrier() {
        return _planProgressBarrier;
    }

    public void setPlanProgressBarrier(String planProgressBarrier) {
        _planProgressBarrier = planProgressBarrier;
    }

    public String getCespClosed() {
        return _cespClosed;
    }

    public void setCespClosed(String cespClosed) {
        _cespClosed = cespClosed;
    }

    public String getCespClosedReason() {
        return _cespClosedReason;
    }

    public void setCespClosedReason(String cespClosedReason) {
        _cespClosedReason = cespClosedReason;
    }

    public String getGoalsReached() {
        return _goalsReached;
    }

    public void setGoalsReached(String goalsReached) {
        _goalsReached = goalsReached;
    }
}
