package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class AudLgSoap implements Serializable {
    private long _audLgId;
    private long _classPk;
    private long _classId;
    private String _attribute;
    private String _oldValue;
    private String _newValue;
    private long _coverUserId;
    private long _modifiedById;
    private Date _modifiedDate;
    private long _groupId;
    private String _roleName;
    private long _sysDateTime;

    public AudLgSoap() {
    }

    public static AudLgSoap toSoapModel(AudLg model) {
        AudLgSoap soapModel = new AudLgSoap();

        soapModel.setAudLgId(model.getAudLgId());
        soapModel.setClassPk(model.getClassPk());
        soapModel.setClassId(model.getClassId());
        soapModel.setAttribute(model.getAttribute());
        soapModel.setOldValue(model.getOldValue());
        soapModel.setNewValue(model.getNewValue());
        soapModel.setCoverUserId(model.getCoverUserId());
        soapModel.setModifiedById(model.getModifiedById());
        soapModel.setModifiedDate(model.getModifiedDate());
        soapModel.setGroupId(model.getGroupId());
        soapModel.setRoleName(model.getRoleName());
        soapModel.setSysDateTime(model.getSysDateTime());

        return soapModel;
    }

    public static AudLgSoap[] toSoapModels(AudLg[] models) {
        AudLgSoap[] soapModels = new AudLgSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static AudLgSoap[][] toSoapModels(AudLg[][] models) {
        AudLgSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new AudLgSoap[models.length][models[0].length];
        } else {
            soapModels = new AudLgSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static AudLgSoap[] toSoapModels(List<AudLg> models) {
        List<AudLgSoap> soapModels = new ArrayList<AudLgSoap>(models.size());

        for (AudLg model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new AudLgSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _audLgId;
    }

    public void setPrimaryKey(long pk) {
        setAudLgId(pk);
    }

    public long getAudLgId() {
        return _audLgId;
    }

    public void setAudLgId(long audLgId) {
        _audLgId = audLgId;
    }

    public long getClassPk() {
        return _classPk;
    }

    public void setClassPk(long classPk) {
        _classPk = classPk;
    }

    public long getClassId() {
        return _classId;
    }

    public void setClassId(long classId) {
        _classId = classId;
    }

    public String getAttribute() {
        return _attribute;
    }

    public void setAttribute(String attribute) {
        _attribute = attribute;
    }

    public String getOldValue() {
        return _oldValue;
    }

    public void setOldValue(String oldValue) {
        _oldValue = oldValue;
    }

    public String getNewValue() {
        return _newValue;
    }

    public void setNewValue(String newValue) {
        _newValue = newValue;
    }

    public long getCoverUserId() {
        return _coverUserId;
    }

    public void setCoverUserId(long coverUserId) {
        _coverUserId = coverUserId;
    }

    public long getModifiedById() {
        return _modifiedById;
    }

    public void setModifiedById(long modifiedById) {
        _modifiedById = modifiedById;
    }

    public Date getModifiedDate() {
        return _modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        _modifiedDate = modifiedDate;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public String getRoleName() {
        return _roleName;
    }

    public void setRoleName(String roleName) {
        _roleName = roleName;
    }

    public long getSysDateTime() {
        return _sysDateTime;
    }

    public void setSysDateTime(long sysDateTime) {
        _sysDateTime = sysDateTime;
    }
}
