package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.AudLgLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class AudLgClp extends BaseModelImpl<AudLg> implements AudLg {
    private long _audLgId;
    private long _classPk;
    private long _classId;
    private String _attribute;
    private String _oldValue;
    private String _newValue;
    private long _coverUserId;
    private String _coverUserUuid;
    private long _modifiedById;
    private Date _modifiedDate;
    private long _groupId;
    private String _roleName;
    private long _sysDateTime;
    private BaseModel<?> _audLgRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public AudLgClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return AudLg.class;
    }

    @Override
    public String getModelClassName() {
        return AudLg.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _audLgId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setAudLgId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _audLgId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("audLgId", getAudLgId());
        attributes.put("classPk", getClassPk());
        attributes.put("classId", getClassId());
        attributes.put("attribute", getAttribute());
        attributes.put("oldValue", getOldValue());
        attributes.put("newValue", getNewValue());
        attributes.put("coverUserId", getCoverUserId());
        attributes.put("modifiedById", getModifiedById());
        attributes.put("modifiedDate", getModifiedDate());
        attributes.put("groupId", getGroupId());
        attributes.put("roleName", getRoleName());
        attributes.put("sysDateTime", getSysDateTime());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long audLgId = (Long) attributes.get("audLgId");

        if (audLgId != null) {
            setAudLgId(audLgId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        Long classId = (Long) attributes.get("classId");

        if (classId != null) {
            setClassId(classId);
        }

        String attribute = (String) attributes.get("attribute");

        if (attribute != null) {
            setAttribute(attribute);
        }

        String oldValue = (String) attributes.get("oldValue");

        if (oldValue != null) {
            setOldValue(oldValue);
        }

        String newValue = (String) attributes.get("newValue");

        if (newValue != null) {
            setNewValue(newValue);
        }

        Long coverUserId = (Long) attributes.get("coverUserId");

        if (coverUserId != null) {
            setCoverUserId(coverUserId);
        }

        Long modifiedById = (Long) attributes.get("modifiedById");

        if (modifiedById != null) {
            setModifiedById(modifiedById);
        }

        Date modifiedDate = (Date) attributes.get("modifiedDate");

        if (modifiedDate != null) {
            setModifiedDate(modifiedDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }

        String roleName = (String) attributes.get("roleName");

        if (roleName != null) {
            setRoleName(roleName);
        }

        Long sysDateTime = (Long) attributes.get("sysDateTime");

        if (sysDateTime != null) {
            setSysDateTime(sysDateTime);
        }
    }

    @Override
    public long getAudLgId() {
        return _audLgId;
    }

    @Override
    public void setAudLgId(long audLgId) {
        _audLgId = audLgId;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setAudLgId", long.class);

                method.invoke(_audLgRemoteModel, audLgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _classPk = classPk;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setClassPk", long.class);

                method.invoke(_audLgRemoteModel, classPk);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getClassId() {
        return _classId;
    }

    @Override
    public void setClassId(long classId) {
        _classId = classId;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setClassId", long.class);

                method.invoke(_audLgRemoteModel, classId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAttribute() {
        return _attribute;
    }

    @Override
    public void setAttribute(String attribute) {
        _attribute = attribute;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setAttribute", String.class);

                method.invoke(_audLgRemoteModel, attribute);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getOldValue() {
        return _oldValue;
    }

    @Override
    public void setOldValue(String oldValue) {
        _oldValue = oldValue;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setOldValue", String.class);

                method.invoke(_audLgRemoteModel, oldValue);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getNewValue() {
        return _newValue;
    }

    @Override
    public void setNewValue(String newValue) {
        _newValue = newValue;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setNewValue", String.class);

                method.invoke(_audLgRemoteModel, newValue);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCoverUserId() {
        return _coverUserId;
    }

    @Override
    public void setCoverUserId(long coverUserId) {
        _coverUserId = coverUserId;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setCoverUserId", long.class);

                method.invoke(_audLgRemoteModel, coverUserId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCoverUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getCoverUserId(), "uuid", _coverUserUuid);
    }

    @Override
    public void setCoverUserUuid(String coverUserUuid) {
        _coverUserUuid = coverUserUuid;
    }

    @Override
    public long getModifiedById() {
        return _modifiedById;
    }

    @Override
    public void setModifiedById(long modifiedById) {
        _modifiedById = modifiedById;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setModifiedById", long.class);

                method.invoke(_audLgRemoteModel, modifiedById);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getModifiedDate() {
        return _modifiedDate;
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        _modifiedDate = modifiedDate;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setModifiedDate", Date.class);

                method.invoke(_audLgRemoteModel, modifiedDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_audLgRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getRoleName() {
        return _roleName;
    }

    @Override
    public void setRoleName(String roleName) {
        _roleName = roleName;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setRoleName", String.class);

                method.invoke(_audLgRemoteModel, roleName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getSysDateTime() {
        return _sysDateTime;
    }

    @Override
    public void setSysDateTime(long sysDateTime) {
        _sysDateTime = sysDateTime;

        if (_audLgRemoteModel != null) {
            try {
                Class<?> clazz = _audLgRemoteModel.getClass();

                Method method = clazz.getMethod("setSysDateTime", long.class);

                method.invoke(_audLgRemoteModel, sysDateTime);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getAudLgRemoteModel() {
        return _audLgRemoteModel;
    }

    public void setAudLgRemoteModel(BaseModel<?> audLgRemoteModel) {
        _audLgRemoteModel = audLgRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _audLgRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_audLgRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            AudLgLocalServiceUtil.addAudLg(this);
        } else {
            AudLgLocalServiceUtil.updateAudLg(this);
        }
    }

    @Override
    public AudLg toEscapedModel() {
        return (AudLg) ProxyUtil.newProxyInstance(AudLg.class.getClassLoader(),
            new Class[] { AudLg.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        AudLgClp clone = new AudLgClp();

        clone.setAudLgId(getAudLgId());
        clone.setClassPk(getClassPk());
        clone.setClassId(getClassId());
        clone.setAttribute(getAttribute());
        clone.setOldValue(getOldValue());
        clone.setNewValue(getNewValue());
        clone.setCoverUserId(getCoverUserId());
        clone.setModifiedById(getModifiedById());
        clone.setModifiedDate(getModifiedDate());
        clone.setGroupId(getGroupId());
        clone.setRoleName(getRoleName());
        clone.setSysDateTime(getSysDateTime());

        return clone;
    }

    @Override
    public int compareTo(AudLg audLg) {
        int value = 0;

        value = DateUtil.compareTo(getModifiedDate(), audLg.getModifiedDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof AudLgClp)) {
            return false;
        }

        AudLgClp audLg = (AudLgClp) obj;

        long primaryKey = audLg.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(25);

        sb.append("{audLgId=");
        sb.append(getAudLgId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", classId=");
        sb.append(getClassId());
        sb.append(", attribute=");
        sb.append(getAttribute());
        sb.append(", oldValue=");
        sb.append(getOldValue());
        sb.append(", newValue=");
        sb.append(getNewValue());
        sb.append(", coverUserId=");
        sb.append(getCoverUserId());
        sb.append(", modifiedById=");
        sb.append(getModifiedById());
        sb.append(", modifiedDate=");
        sb.append(getModifiedDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append(", roleName=");
        sb.append(getRoleName());
        sb.append(", sysDateTime=");
        sb.append(getSysDateTime());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(40);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.AudLg");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>audLgId</column-name><column-value><![CDATA[");
        sb.append(getAudLgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classId</column-name><column-value><![CDATA[");
        sb.append(getClassId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>attribute</column-name><column-value><![CDATA[");
        sb.append(getAttribute());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>oldValue</column-name><column-value><![CDATA[");
        sb.append(getOldValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>newValue</column-name><column-value><![CDATA[");
        sb.append(getNewValue());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>coverUserId</column-name><column-value><![CDATA[");
        sb.append(getCoverUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>modifiedById</column-name><column-value><![CDATA[");
        sb.append(getModifiedById());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
        sb.append(getModifiedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>roleName</column-name><column-value><![CDATA[");
        sb.append(getRoleName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>sysDateTime</column-name><column-value><![CDATA[");
        sb.append(getSysDateTime());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
