package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class AssmtClp extends BaseModelImpl<Assmt> implements Assmt {
    private long _assmtId;
    private long _vcgId;
    private long _noteId;
    private Date _completionDate;
    private String _type;
    private Date _scheduleDate;
    private long _userId;
    private String _userUuid;
    private String _comment;
    private boolean _active;
    private long _caregiverId;
    private BaseModel<?> _assmtRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public AssmtClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Assmt.class;
    }

    @Override
    public String getModelClassName() {
        return Assmt.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _assmtId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setAssmtId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _assmtId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("assmtId", getAssmtId());
        attributes.put("vcgId", getVcgId());
        attributes.put("noteId", getNoteId());
        attributes.put("completionDate", getCompletionDate());
        attributes.put("type", getType());
        attributes.put("scheduleDate", getScheduleDate());
        attributes.put("userId", getUserId());
        attributes.put("comment", getComment());
        attributes.put("active", getActive());
        attributes.put("caregiverId", getCaregiverId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long assmtId = (Long) attributes.get("assmtId");

        if (assmtId != null) {
            setAssmtId(assmtId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long noteId = (Long) attributes.get("noteId");

        if (noteId != null) {
            setNoteId(noteId);
        }

        Date completionDate = (Date) attributes.get("completionDate");

        if (completionDate != null) {
            setCompletionDate(completionDate);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date scheduleDate = (Date) attributes.get("scheduleDate");

        if (scheduleDate != null) {
            setScheduleDate(scheduleDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        String comment = (String) attributes.get("comment");

        if (comment != null) {
            setComment(comment);
        }

        Boolean active = (Boolean) attributes.get("active");

        if (active != null) {
            setActive(active);
        }

        Long caregiverId = (Long) attributes.get("caregiverId");

        if (caregiverId != null) {
            setCaregiverId(caregiverId);
        }
    }

    @Override
    public long getAssmtId() {
        return _assmtId;
    }

    @Override
    public void setAssmtId(long assmtId) {
        _assmtId = assmtId;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setAssmtId", long.class);

                method.invoke(_assmtRemoteModel, assmtId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _vcgId = vcgId;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setVcgId", long.class);

                method.invoke(_assmtRemoteModel, vcgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getNoteId() {
        return _noteId;
    }

    @Override
    public void setNoteId(long noteId) {
        _noteId = noteId;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setNoteId", long.class);

                method.invoke(_assmtRemoteModel, noteId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCompletionDate() {
        return _completionDate;
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setCompletionDate", Date.class);

                method.invoke(_assmtRemoteModel, completionDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getType() {
        return _type;
    }

    @Override
    public void setType(String type) {
        _type = type;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setType", String.class);

                method.invoke(_assmtRemoteModel, type);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getScheduleDate() {
        return _scheduleDate;
    }

    @Override
    public void setScheduleDate(Date scheduleDate) {
        _scheduleDate = scheduleDate;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setScheduleDate", Date.class);

                method.invoke(_assmtRemoteModel, scheduleDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_assmtRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public String getComment() {
        return _comment;
    }

    @Override
    public void setComment(String comment) {
        _comment = comment;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setComment", String.class);

                method.invoke(_assmtRemoteModel, comment);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getActive() {
        return _active;
    }

    @Override
    public boolean isActive() {
        return _active;
    }

    @Override
    public void setActive(boolean active) {
        _active = active;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setActive", boolean.class);

                method.invoke(_assmtRemoteModel, active);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCaregiverId() {
        return _caregiverId;
    }

    @Override
    public void setCaregiverId(long caregiverId) {
        _caregiverId = caregiverId;

        if (_assmtRemoteModel != null) {
            try {
                Class<?> clazz = _assmtRemoteModel.getClass();

                Method method = clazz.getMethod("setCaregiverId", long.class);

                method.invoke(_assmtRemoteModel, caregiverId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getAssmtRemoteModel() {
        return _assmtRemoteModel;
    }

    public void setAssmtRemoteModel(BaseModel<?> assmtRemoteModel) {
        _assmtRemoteModel = assmtRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _assmtRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_assmtRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            AssmtLocalServiceUtil.addAssmt(this);
        } else {
            AssmtLocalServiceUtil.updateAssmt(this);
        }
    }

    @Override
    public Assmt toEscapedModel() {
        return (Assmt) ProxyUtil.newProxyInstance(Assmt.class.getClassLoader(),
            new Class[] { Assmt.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        AssmtClp clone = new AssmtClp();

        clone.setAssmtId(getAssmtId());
        clone.setVcgId(getVcgId());
        clone.setNoteId(getNoteId());
        clone.setCompletionDate(getCompletionDate());
        clone.setType(getType());
        clone.setScheduleDate(getScheduleDate());
        clone.setUserId(getUserId());
        clone.setComment(getComment());
        clone.setActive(getActive());
        clone.setCaregiverId(getCaregiverId());

        return clone;
    }

    @Override
    public int compareTo(Assmt assmt) {
        int value = 0;

        value = DateUtil.compareTo(getScheduleDate(), assmt.getScheduleDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof AssmtClp)) {
            return false;
        }

        AssmtClp assmt = (AssmtClp) obj;

        long primaryKey = assmt.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(21);

        sb.append("{assmtId=");
        sb.append(getAssmtId());
        sb.append(", vcgId=");
        sb.append(getVcgId());
        sb.append(", noteId=");
        sb.append(getNoteId());
        sb.append(", completionDate=");
        sb.append(getCompletionDate());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", scheduleDate=");
        sb.append(getScheduleDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", comment=");
        sb.append(getComment());
        sb.append(", active=");
        sb.append(getActive());
        sb.append(", caregiverId=");
        sb.append(getCaregiverId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(34);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Assmt");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>assmtId</column-name><column-value><![CDATA[");
        sb.append(getAssmtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>noteId</column-name><column-value><![CDATA[");
        sb.append(getNoteId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionDate</column-name><column-value><![CDATA[");
        sb.append(getCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>scheduleDate</column-name><column-value><![CDATA[");
        sb.append(getScheduleDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>comment</column-name><column-value><![CDATA[");
        sb.append(getComment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>active</column-name><column-value><![CDATA[");
        sb.append(getActive());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>caregiverId</column-name><column-value><![CDATA[");
        sb.append(getCaregiverId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
