package gov.va.caret.util.test;

import java.util.Calendar;
import java.util.Date;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import gov.va.caret.model.BgLae;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.support.BgLaeJUnit;
import gov.va.caret.model.support.StiPtJUnit;
import gov.va.caret.service.thread.Monitor;
import gov.va.caret.util.Toolbox;
import junit.framework.TestResult;

public class PaymentStagingTest extends org.junit.Assert implements junit.framework.Test  {

	
	@Test
	public void paymentStagingTest() {
		
		//OCC Admin "submits" daily
		long originalStaging = Monitor.lock( payments.getBgLaeId(), payments.getOwnerId() );
		assertTrue ( payments.getLargeText().startsWith("PENDING-REQUESTED-") );
		boolean locked = originalStaging == payments.getOwnerId();
		assertTrue ( locked );

		StiPt payment = new StiPtJUnit();
		payment.setCycleId( payments.getBgLaeId() );
		//save payment...
		
		long newPayments = 33345;
		long paymentdBusy = Monitor.lock( payments.getBgLaeId(), newPayments );
		assertTrue ( paymentdBusy == originalStaging );
		
		String paymentState = payments.getLargeText();
		
		
		
	}

	
	
//-----------------------------------------------------------------------------------------------------------	
	@Before
	public void setUp() {
	}
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		try{
			System.out.println(">>>PaymentStagingTest SET UP");
			testDate1 = (Date)Toolbox.getDateFormatVaafi().parseObject( testDateHeader1 );
			payments = new BgLaeJUnit();
			payments.setBgLaeId(12345);
			payments.setOwnerId(100000);
			payments.setLargeText( "PENDING-REQUESTED-" + Toolbox.formatDate( new Date() ) );
			
		}catch(Exception ex){
			ex.printStackTrace();
			fail("Init failed...");
		}
	}

	static String testDateHeader1 = "2018-03-3T00:00:00-00:00";
	static Date testDate1;
	static BgLae payments;
	
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}
	public int countTestCases() {
		return 1;
	}
	public void run(TestResult result) {
	}

}
