package gov.va.caret.util.test;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import gov.va.caret.model.support.Person;
import gov.va.caret.util.Toolbox;
import junit.framework.TestResult;

public class CaretUtilTest extends org.junit.Assert implements junit.framework.Test  {

	@Test
	public void testDecode() {
		assertTrue ( "130 Metairie Rd".equals( Toolbox.decode("130%20METAIRIE%20RD", true) ) );
		assertTrue ( "TX".equals( Toolbox.decode("TX", false) ) );
		assertTrue ( "USA".equals( Toolbox.decode("USA", false) ) );
		assertTrue ( "Aiden".equals( Toolbox.decode("AIDEN", true) ) );
		assertTrue ( "Los Angeles".equals( Toolbox.decode("LOS%20ANGELES", true) ) );
		assertTrue ( "".equals( Toolbox.decode("NOT_FOUND", true) ) );
	}
	@Test
	public void testFormatDatePdf() {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "03-03-1988".equals( Toolbox.formatDatePdf( birthday ) ) );
	}
	@Test
	public void testParseHeaderDate() throws ParseException {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "03/03/88".equals( Toolbox.formatDate( birthday ) ) );
	}
	@Test
	public void testFormatDateOrient() {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "19680730".equals( Toolbox.formatDateOrient( birthday2 ) ) );
	}
	@Test
	public void testFormatDateCprs() {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "07/30/1968".equals( Toolbox.formatDateCprs( birthday2 ) ) );
		assertTrue ( "01/01/1950".equals( Toolbox.formatDateCprs( birthday3 ) ) );
		Calendar c = Calendar.getInstance();
		c.setTime( birthday3 );
		int[] bDay = new int[]{c.get(Calendar.MONTH), c.get(Calendar.DAY_OF_MONTH), c.get(Calendar.YEAR)};
		assertTrue ( 0 == bDay[0] );
		assertTrue ( 1 == bDay[1] );
		assertTrue ( 1950 == bDay[2] );
	}
	@Test
	public void testFormatZip() {
		String zip = Toolbox.formatBigZip( "392" );
		assertTrue("00392".equals(zip));
	}
	@Test
	public void testFormatBigZip() {
		String zip = Toolbox.formatBigZip( "77743-0092" );
		assertTrue("77743".equals(zip));
		zip = Toolbox.formatBigZip( "6674392" );
		assertTrue("66743".equals(zip));
	}
	@Test
	public void testFormatSsn() {
		String ssn = "999887766";
		assertTrue ( "999-88-7766".equals( Toolbox.formatSsn(ssn) ) );
		assertTrue ( "".equals( Toolbox.formatSsn("") ) );
	}
	@Test
	public void testIsEmpty() {
		assertTrue( Toolbox.isEmpty( ( Toolbox.decode("NOT_FOUND", true) ) ) );
		assertTrue( Toolbox.isEmpty( ( Toolbox.decode("NOT_FOUND_EMAIL", true) ) ) );
		assertTrue( Toolbox.isEmpty( ( Toolbox.decode("NAME_NOT_FOUND", true) ) ) );
		assertTrue( Toolbox.isEmpty( Toolbox.parseEmail( Person.EMAIL_FORMAT ) ) );
		assertTrue( Toolbox.isEmpty( Toolbox.parsePhone( Person.PHONE_FORMAT ) ) );
	}
	@Test
	public void testParsePhone() {
		assertTrue( Toolbox.isEmpty( Toolbox.parsePhone( Person.PHONE_FORMAT ) ) );
		assertTrue( "(666) 777-9900".equals( Toolbox.parsePhone( "6667779900" ) ) );
	}
	@Test
	public void testParseEmail() {
		assertTrue( Toolbox.parseEmail( Person.EMAIL_FORMAT ).equals( "" ) );
		assertTrue( Toolbox.parseEmail( "first.last@a.gov" ).equals( "first.last@a.gov" ) );
		
		
//		Calendar c = Calendar.getInstance();
//		c.set(Calendar.YEAR, 2050);
//		System.out.println( Toolbox.getWeekRange( c.getTime() ) + " ... c.getTime()=" + c.getTime().getTime() ); //
//		Calendar calendar = Calendar.getInstance();
//		int months = 5;
//		List<Date> list = new ArrayList<Date> ();
//		list.add( calendar.getTime() );
//		for ( int i = months; i > 1; i-- ) {
//			calendar.roll(Calendar.MONTH, false);
//			if ( calendar.get(Calendar.MONTH) == Calendar.DECEMBER ) {
//				calendar.roll(Calendar.YEAR, false);
//			}
//			list.add( calendar.getTime() );
//		}
//		for ( int i = list.size()-1; i >= 0; i-- ) {
//			System.out.println( Toolbox.formatDate( list.get(i) ) );
//		}
		
		
	}
	
	@Test
	public void testWeeklyDates() {
		
		assertTrue ( "03/03/2018".equals( Toolbox.formatDateCprs( testDate1 ) ) );
		assertTrue ( "12/30/2017".equals( Toolbox.formatDateCprs( testDate2 ) ) );
		assertTrue ( "01/01/2018".equals( Toolbox.formatDateCprs( testDate3 ) ) );
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(testDate1);
		assertTrue ( "03/03/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
		assertTrue ( "02/25/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.DAY_OF_WEEK, Calendar.SATURDAY);
		assertTrue ( "03/03/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.WEEK_OF_YEAR, 11);
		assertTrue ( "03/17/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.WEEK_OF_YEAR, 1);
		assertTrue ( "01/06/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
		assertTrue ( "12/31/2017".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		

	}
	
	@Test
	public void testMonthlyDates() {
		
		assertTrue ( "03/03/2018".equals( Toolbox.formatDateCprs( testDate1 ) ) );
		assertTrue ( "12/30/2017".equals( Toolbox.formatDateCprs( testDate2 ) ) );
		assertTrue ( "01/01/2018".equals( Toolbox.formatDateCprs( testDate3 ) ) );
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(testDate1);
		assertTrue ( "03/03/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.DAY_OF_MONTH, 1);
		assertTrue ( "03/01/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.roll(Calendar.DAY_OF_MONTH, false);
		assertTrue ( "03/31/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.setTime(testDate2);
		assertTrue ( "12/30/2017".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.DAY_OF_MONTH, 1);
		assertTrue ( "12/01/2017".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.roll(Calendar.DAY_OF_MONTH, false);
		assertTrue ( "12/31/2017".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.setTime(testDate3);
		assertTrue ( "01/01/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.DAY_OF_MONTH, 1);
		assertTrue ( "01/01/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.roll(Calendar.DAY_OF_MONTH, false);
		assertTrue ( "01/31/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
	}
	
	@Test
	public void testDateIds() {
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(testDate1);
		assertTrue ( "03/03/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
		calendar.set(Calendar.DAY_OF_WEEK, Calendar.SATURDAY);
		calendar.set(Calendar.WEEK_OF_YEAR, 11);
		assertTrue ( "03/17/2018".equals( Toolbox.formatDateCprs( calendar.getTime() ) ) );
		
//		calendar.set(Calendar.WEEK_OF_YEAR, 1);
//		System.out.println( Toolbox.formatDateCprs( calendar.getTime() ) ) ;
//		
//		calendar.setTime(Toolbox.parseDate("01/13/18"));
//		System.out.println( calendar.get(Calendar.WEEK_OF_YEAR) ) ;
//		System.out.println( 2018 * 52 + calendar.get(Calendar.WEEK_OF_YEAR) ) ;
//		
//		System.out.println( 2018 * 12 + calendar.get(Calendar.MONTH) ) ;
		
	}
	
	@Test
	public void testEndDate() {
		assertTrue( Toolbox.isEmpty( Toolbox.parsePhone( Person.PHONE_FORMAT ) ) );
		assertTrue( "(666) 777-9900".equals( Toolbox.parsePhone( "6667779900" ) ) );
	}
	
	
//-----------------------------------------------------------------------------------------------------------	
	@Before
	public void setUp() {
	}
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		try{
			System.out.println(">>>CaretUtilTest SET UP");
			
			birthday = (Date)Toolbox.getDateFormatVaafi().parseObject( birthdayHeader1 );
			birthday2 = (Date)Toolbox.getDateFormatVaafi().parseObject( birthdayHeader2 );
			birthday3 = (Date)Toolbox.getDateFormatVaafi().parseObject( birthdayHeader3 );
			
			testDate1 = (Date)Toolbox.getDateFormatVaafi().parseObject( testDateHeader1 );
			testDate2 = (Date)Toolbox.getDateFormatVaafi().parseObject( testDateHeader2 );
			testDate3 = (Date)Toolbox.getDateFormatVaafi().parseObject( testDateHeader3 );
			
		}catch(Exception ex){
			ex.printStackTrace();
			fail("Init failed...");
		}
	}

	static String birthdayHeader1 = "1988-03-3T00:00:00-00:00";
	static String birthdayHeader2 = "1968-07-30T00:00:00-00:00";
	static String birthdayHeader3 = "1950-01-01T00:00:00-00:00";
	static String testDateHeader1 = "2018-03-3T00:00:00-00:00";
	static String testDateHeader2 = "2017-12-30T00:00:00-00:00";
	static String testDateHeader3 = "2018-01-01T00:00:00-00:00";
	static Date birthday;
	static Date birthday2;
	static Date birthday3;
	static Date testDate1;
	static Date testDate2;
	static Date testDate3;
	
	
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}
	public int countTestCases() {
		return 11;
	}
	public void run(TestResult result) {
	}
// TODO: more functions to test...
//	@Test
//	public void testGetUrlQuery() {
//		assertTrue(true);
//	}
//	@Test
//	public void testAdjustDate() {
//		assertTrue(true);
//	}
//
//	@Test
//	public void testAdjustBusinessDate() {
//		assertTrue(true);
//	}
	
//
}
