package gov.va.caret.util.test;

import java.util.Calendar;
import java.util.Date;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.StiPtJUnit;
import gov.va.caret.model.support.WorImJUnit;
import gov.va.caret.model.support.occ.AddressChange;
import gov.va.caret.model.support.occ.CalculationChange;
import gov.va.caret.model.support.occ.CalculationInfo;
import gov.va.caret.model.support.occ.FinalPayment;
import gov.va.caret.model.support.occ.InitialPayment;
import gov.va.caret.model.support.occ.Reinstatement;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.model.support.occ.TierChange;
import gov.va.caret.util.Toolbox;
import junit.framework.TestResult;

public class CalculationInfoTest extends org.junit.Assert implements junit.framework.Test  {

	static boolean debugEnabled = false;
	
	@Test
	public void testPaymentDate() {
		
		assertTrue( Toolbox.parseDate("04/01/2018").equals( applicationApproval_sameMonth.getPaymentDate() ) );
		assertTrue( Toolbox.parseDate("04/01/2018").equals( applicationApproval_1stDaySameMonth.getPaymentDate() ) );
		assertTrue( Toolbox.parseDate("04/01/2018").equals( applicationApproval_priorMonth.getPaymentDate() ) );
		assertTrue( Toolbox.parseDate("04/01/2018").equals( applicationApproval_2MonthsBack.getPaymentDate() ) );
	}
	
	@Test
	public void testRetroactiveMonths() {
		assertTrue( applicationApproval_sameMonth.getRetroactiveMonths() == 0 );
		assertTrue( applicationApproval_1stDaySameMonth.getRetroactiveMonths() == 0 );
		assertTrue( applicationApproval_priorMonth.getRetroactiveMonths() == 0 );
		assertTrue( applicationApproval_2MonthsBack.getRetroactiveMonths() == 1 );
	}
	
	@Test
	public void testBackPayAmount() {
		assertTrue( applicationApproval_sameMonth.getBackPayAmount().toString().equals("0.00")  );
		assertTrue( applicationApproval_1stDaySameMonth.getBackPayAmount().toString().equals("0.00") );
		assertTrue( applicationApproval_priorMonth.getBackPayAmount().toString().equals("0.00")  );
		assertTrue( applicationApproval_2MonthsBack.getBackPayAmount().toString().equals("545.49") );
	}
	
	@Test
	public void testTotalDays() {
		assertTrue( applicationApproval_sameMonth.getTotalDays( ) == 12 );
		assertTrue( applicationApproval_1stDaySameMonth.getTotalDays() == 0 );
		assertTrue( applicationApproval_priorMonth.getTotalDays() == 14 );
		assertTrue( applicationApproval_2MonthsBack.getTotalDays() == 17 );
	}
	
	@Test
	public void testProratedAmount() {
		
		assertTrue( applicationApproval_sameMonth.getProratedAmount().toString().equals("537.96") );
		assertTrue( applicationApproval_1stDaySameMonth.getProratedAmount().toString().equals( "1090.98" ) );
		assertTrue( applicationApproval_priorMonth.getProratedAmount().toString().equals("1004.36") );
		assertTrue( applicationApproval_2MonthsBack.getProratedAmount().toString().equals("304.81") );
		
	}

	@Test
	public void testInitialPayment() {
		assertTrue( applicationApproval_sameMonth.getFinalAmount().toString().equals("537.96") );
		assertTrue( applicationApproval_1stDaySameMonth.getFinalAmount().toString().equals("1090.98") );
		assertTrue( applicationApproval_priorMonth.getFinalAmount().toString().equals("3186.32") );
		assertTrue( applicationApproval_2MonthsBack.getFinalAmount().toString().equals("1395.79") );
	}
	
	
	@Test
	public void testRecoupmentAmount() {
		
		
		assertTrue( tierChange_DecrPay.getTotalDays() == 26 );
		assertTrue( tierChange_DecrPay2.getTotalDays() == 14 );
		
//		System.out.println( tierChange_DecrPay2.getTotalDays()  );
//		System.out.println( tierChange_DecrPay2.getRecoupmentAmount()  );//
//		
//		System.out.println( tierChange_DecrPay2.getStipendPaymentConfig().getTierHours() );
//		System.out.println( tierChange_DecrPay2.getOldStipendPaymentConfig().getTierHours() );
//		
//
//		System.out.println( tierChange_DecrPay2.getOldHourlyRate() );
//		System.out.println( tierChange_DecrPay2.getHourlyRate() );
//		
//		System.out.println( tierChange_DecrPay2.getDailyRate() );
//		System.out.println( tierChange_DecrPay2.getOldDailyRate() );//
//		
//		System.out.println( tierChange_DecrPay2.getOldMonthlyRate() );
//		System.out.println( tierChange_DecrPay2.getMonthlyRate() );
//		
//		
//		System.out.println( tierChange_DecrPay2.getOldStipendPaymentConfig().getPayslipDate() );
//		
//		System.out.println( tierChange_DecrPay2.getOneTimePayment() );
	
//		assertTrue( applicationApproval_priorMonth.getRetroactiveMonths() == 1 );
//		assertTrue( applicationApproval_1stDaySameMonth.getRetroactiveMonths() == 0 );
		
	}
//	
//	@Test
//	public void testCalculationChange() {
//		
//		assertTrue( applicationApproval_sameMonth.getRetroactiveMonths() == 0 );
//		assertTrue( applicationApproval_priorMonth.getRetroactiveMonths() == 1 );
//		assertTrue( applicationApproval_1stDaySameMonth.getRetroactiveMonths() == 0 );
//		
//	}	
//	
//	@Test
//	public void testRecoupable() {
//		
//		assertTrue( applicationApproval_sameMonth.getRetroactiveMonths() == 0 );
//		assertTrue( applicationApproval_priorMonth.getRetroactiveMonths() == 1 );
//		assertTrue( applicationApproval_1stDaySameMonth.getRetroactiveMonths() == 0 );
//		
//	}	
//	
//	@Test
//	public void testDailyRate() {
//		
//		assertTrue( applicationApproval_sameMonth.getRetroactiveMonths() == 0 );
//		assertTrue( applicationApproval_priorMonth.getRetroactiveMonths() == 1 );
//		assertTrue( applicationApproval_1stDaySameMonth.getRetroactiveMonths() == 0 );
//		
//	}
//	
	@Test
	public void testPaymentSchedule() {
		
		int monthKey = 2018 * 12 + 4; //May 
		
		long vendrId1 = 101l;
		long vendrId2 = 102l;
		
		
		
		StiPt recurring1 = new StiPtJUnit();
		recurring1.setStipendType(StipendConfig.RECURRING);
		recurring1.setStipendStatus(StipendConfig.PAYMENT_FINANCE);
		recurring1.setVendrId( vendrId1 );
		recurring1.setCycleId( monthKey );
		recurring1.setPayment("500.0");
		
		
		
		
	}
	
	@Override
	public int countTestCases() {
		return 0;
	}

	@Override
	public void run(TestResult result) {
		
	}
	
	@Before
	public void setUp() {
		try{
			
			
			
		}catch(Exception ex){
			ex.printStackTrace();
			fail("Init failed...");
		}
	}
	
	static CalculationInfo applicationApproval_sameMonth,
							applicationApproval_priorMonth,
							applicationApproval_1stDaySameMonth,
							applicationApproval_2MonthsBack,
							
							revocation_MediumEntitledDays,
							
							reinstatement;
							
	
	static CalculationChange addressChange_DecrPay,
							addressChange_IncrPay,
							
							tierChange_DecrPay,
							tierChange_DecrPay2,
							tierChange_IncrPay,
							tierChange_IncrPay2;
	
	
	static Date paymentDate = Toolbox.parseDate("04/01/2018");

	static StiPt lowTierHighBlsNoEntitledDaysNov30 = new StiPtJUnit();
	static StiPt mediumTierHighBlsNoEntitledDaysNov30 = new StiPtJUnit();
	static StiPt highTierHighBlsNoEntitledDaysNov30 = new StiPtJUnit();
	
	static StiPt lowTierMedBlsMediumEntitledDaysJan15 = new StiPtJUnit();
	static StiPt medTierMedBlsMediumEntitledDaysJan15 = new StiPtJUnit();
	static StiPt highTierMedBlsMediumEntitledDaysJan15 = new StiPtJUnit();
	
	static StiPt lowTierMedBlsLowEntitledDaysFeb15 = new StiPtJUnit();
	static StiPt mediumTierMedBlsLowEntitledDaysFeb15 = new StiPtJUnit();
	static StiPt highTierMedBlsLowEntitledDaysFeb15 = new StiPtJUnit();
	
	static StiPt lowTierlowBlsHighEntitledDaysMar01 = new StiPtJUnit();
	static StiPt highTierlowBlsHighEntitledDaysMar01 = new StiPtJUnit();
	static StiPt mediumTierMedBlsNoEntitledDaysMar20 = new StiPtJUnit();

	static StiPt lowTierLowBlsMediumEntitledDaysApr05 = new StiPtJUnit();
	static StiPt lowTierMedBlsLowEntitledDaysApr05 = new StiPtJUnit();
	static StiPt highTierMedBlsLowEntitledDaysApr05 = new StiPtJUnit();
	static StiPt mediumTierLowBlsNoEntitledDaysMay10 = new StiPtJUnit();
	
	static {
		
		lowTierHighBlsNoEntitledDaysNov30.setBlsRateHourly("25.08");
		lowTierHighBlsNoEntitledDaysNov30.setEntitledDays(0);
		lowTierHighBlsNoEntitledDaysNov30.setTier("1");
		lowTierHighBlsNoEntitledDaysNov30.setPayment("1087.85");
		lowTierHighBlsNoEntitledDaysNov30.setStipendStartDate( Toolbox.parseDate("11/30/2017") );
		lowTierHighBlsNoEntitledDaysNov30.setTierHours("43.50");
		
		mediumTierHighBlsNoEntitledDaysNov30.setBlsRateHourly("25.08");
		mediumTierHighBlsNoEntitledDaysNov30.setEntitledDays(0);
		mediumTierHighBlsNoEntitledDaysNov30.setTier("2");
		mediumTierHighBlsNoEntitledDaysNov30.setPayment("2727.46");
		mediumTierHighBlsNoEntitledDaysNov30.setStipendStartDate( Toolbox.parseDate("11/30/2017") );
		mediumTierHighBlsNoEntitledDaysNov30.setTierHours("108.75");
		
		highTierHighBlsNoEntitledDaysNov30.setBlsRateHourly("25.08");
		highTierHighBlsNoEntitledDaysNov30.setEntitledDays(0);
		highTierHighBlsNoEntitledDaysNov30.setTier("3");
		highTierHighBlsNoEntitledDaysNov30.setPayment("4351.39");
		highTierHighBlsNoEntitledDaysNov30.setStipendStartDate( Toolbox.parseDate("11/30/2017") );
		highTierHighBlsNoEntitledDaysNov30.setTierHours("174.00");
		
		lowTierMedBlsMediumEntitledDaysJan15.setBlsRateHourly("12.54");
		lowTierMedBlsMediumEntitledDaysJan15.setEntitledDays(60);
		lowTierMedBlsMediumEntitledDaysJan15.setTier("1");
		lowTierMedBlsMediumEntitledDaysJan15.setPayment("545.49");
		lowTierMedBlsMediumEntitledDaysJan15.setStipendStartDate(Toolbox.parseDate("01/15/2018"));
		lowTierMedBlsMediumEntitledDaysJan15.setTierHours("43.50");
		
		medTierMedBlsMediumEntitledDaysJan15.setBlsRateHourly("12.54");
		medTierMedBlsMediumEntitledDaysJan15.setEntitledDays(60);
		medTierMedBlsMediumEntitledDaysJan15.setTier("2");
		medTierMedBlsMediumEntitledDaysJan15.setPayment("1363.73");
		medTierMedBlsMediumEntitledDaysJan15.setStipendStartDate(Toolbox.parseDate("01/15/2018"));
		medTierMedBlsMediumEntitledDaysJan15.setTierHours("108.75");
		
		highTierMedBlsMediumEntitledDaysJan15.setBlsRateHourly("12.54");
		highTierMedBlsMediumEntitledDaysJan15.setEntitledDays(60);
		highTierMedBlsMediumEntitledDaysJan15.setTier("3");
		highTierMedBlsMediumEntitledDaysJan15.setPayment("2181.96");
		highTierMedBlsMediumEntitledDaysJan15.setStipendStartDate(Toolbox.parseDate("01/15/2018"));
		highTierMedBlsMediumEntitledDaysJan15.setTierHours("174.00");
		
		lowTierMedBlsLowEntitledDaysFeb15.setBlsRateHourly("12.54");
		lowTierMedBlsLowEntitledDaysFeb15.setEntitledDays(30);
		lowTierMedBlsLowEntitledDaysFeb15.setTier("1");
		lowTierMedBlsLowEntitledDaysFeb15.setPayment("545.49");
		lowTierMedBlsLowEntitledDaysFeb15.setStipendStartDate(Toolbox.parseDate("02/15/2018"));
		lowTierMedBlsLowEntitledDaysFeb15.setTierHours("43.50");
		
		mediumTierMedBlsLowEntitledDaysFeb15.setBlsRateHourly("12.54");//old
		mediumTierMedBlsLowEntitledDaysFeb15.setEntitledDays(30);
		mediumTierMedBlsLowEntitledDaysFeb15.setTier("2");
		mediumTierMedBlsLowEntitledDaysFeb15.setPayment("1363.73");
		mediumTierMedBlsLowEntitledDaysFeb15.setStipendStartDate(Toolbox.parseDate("02/15/2018"));
		mediumTierMedBlsLowEntitledDaysFeb15.setTierHours("108.75");
		
		highTierMedBlsLowEntitledDaysFeb15.setBlsRateHourly("12.54");
		highTierMedBlsLowEntitledDaysFeb15.setEntitledDays(30);
		highTierMedBlsLowEntitledDaysFeb15.setTier("3");
		highTierMedBlsLowEntitledDaysFeb15.setPayment("2181.96");
		highTierMedBlsLowEntitledDaysFeb15.setStipendStartDate(Toolbox.parseDate("02/15/2018"));
		highTierMedBlsLowEntitledDaysFeb15.setTierHours("174.00");
		
		lowTierlowBlsHighEntitledDaysMar01.setBlsRateHourly("6.27");
		lowTierlowBlsHighEntitledDaysMar01.setEntitledDays(90);
		lowTierlowBlsHighEntitledDaysMar01.setTier("1");
		lowTierlowBlsHighEntitledDaysMar01.setPayment("272.75");
		lowTierlowBlsHighEntitledDaysMar01.setStipendStartDate(Toolbox.parseDate("03/01/2018"));
		lowTierlowBlsHighEntitledDaysMar01.setTierHours("43.50");
		
		highTierlowBlsHighEntitledDaysMar01.setBlsRateHourly("6.27");
		highTierlowBlsHighEntitledDaysMar01.setEntitledDays(90);
		highTierlowBlsHighEntitledDaysMar01.setTier("3");
		highTierlowBlsHighEntitledDaysMar01.setPayment("1090.98");
		highTierlowBlsHighEntitledDaysMar01.setStipendStartDate(Toolbox.parseDate("03/01/2018"));
		highTierlowBlsHighEntitledDaysMar01.setTierHours("174.00");
		
		mediumTierMedBlsNoEntitledDaysMar20.setBlsRateHourly("12.54");
		mediumTierMedBlsNoEntitledDaysMar20.setEntitledDays(0);
		mediumTierMedBlsNoEntitledDaysMar20.setTier("2");
		mediumTierMedBlsNoEntitledDaysMar20.setPayment("1363.73");
		mediumTierMedBlsNoEntitledDaysMar20.setStipendStartDate( Toolbox.parseDate("03/20/2018") );
		mediumTierMedBlsNoEntitledDaysMar20.setTierHours("108.75");
		
		lowTierLowBlsMediumEntitledDaysApr05.setBlsRateHourly("6.27");
		lowTierLowBlsMediumEntitledDaysApr05.setEntitledDays(60);
		lowTierLowBlsMediumEntitledDaysApr05.setTier("1");
		lowTierLowBlsMediumEntitledDaysApr05.setPayment("272.75");
		lowTierLowBlsMediumEntitledDaysApr05.setStipendStartDate(Toolbox.parseDate("04/05/2018"));
		lowTierLowBlsMediumEntitledDaysApr05.setTierHours("43.50");
		
		lowTierMedBlsLowEntitledDaysApr05.setBlsRateHourly("12.54");
		lowTierMedBlsLowEntitledDaysApr05.setEntitledDays(30);
		lowTierMedBlsLowEntitledDaysApr05.setTier("1");
		lowTierMedBlsLowEntitledDaysApr05.setPayment("545.49");
		lowTierMedBlsLowEntitledDaysApr05.setStipendStartDate(Toolbox.parseDate("04/05/2018"));
		lowTierMedBlsLowEntitledDaysApr05.setTierHours("43.50");
		
		highTierMedBlsLowEntitledDaysApr05.setBlsRateHourly("12.54");
		highTierMedBlsLowEntitledDaysApr05.setEntitledDays(30);
		highTierMedBlsLowEntitledDaysApr05.setTier("3");
		highTierMedBlsLowEntitledDaysApr05.setPayment("2181.96");
		highTierMedBlsLowEntitledDaysApr05.setStipendStartDate(Toolbox.parseDate("04/05/2018"));
		highTierMedBlsLowEntitledDaysApr05.setTierHours("174.00");
		
		mediumTierLowBlsNoEntitledDaysMay10.setBlsRateHourly("6.27");
		mediumTierLowBlsNoEntitledDaysMay10.setEntitledDays(0);
		mediumTierLowBlsNoEntitledDaysMay10.setTier("2");
		mediumTierLowBlsNoEntitledDaysMay10.setPayment("1363.73");
		mediumTierLowBlsNoEntitledDaysMay10.setStipendStartDate( Toolbox.parseDate("05/10/2018") );
		mediumTierLowBlsNoEntitledDaysMay10.setTierHours("108.75");
	}
	
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println(">>>CalculationInfoTest SET UP");
		
		Calendar calendar = Calendar.getInstance();
		WorIm workItem = new WorImJUnit();
		StiPt caret0 = new StiPtJUnit();
		caret0.setBlsRateHourly("12.54");
		caret0.setEntitledDays(60);
		caret0.setTier("2");
		caret0.setPayment("1363.73");
		caret0.setStipendStartDate(Toolbox.parseDate("01/05/2018"));
		caret0.setTierHours("108.75");
		calendar.setTime( Toolbox.parseDate("02/01/2018") );
		if ( debugEnabled ) {
			System.out.println(new InitialPayment(workItem, caret0, calendar));
		}

		
		StiPt caret = new StiPtJUnit();
		caret.setBlsRateHourly("12.54");
		caret.setEntitledDays(60);
		caret.setTier("2");
		caret.setPayment("1363.73");
		caret.setStipendStartDate(Toolbox.parseDate("01/11/2018"));
		caret.setTierHours("108.75");
		caret.setPayslipDate(Toolbox.parseDate( "02/01/2018") );
		calendar.setTime( Toolbox.parseDate("03/01/2018") );
//		if ( debugEnabled ) {
//			System.out.println(new InitialPayment(workItem, caret, calendar));
//		}
//		
		
		
		/*
		mediumTierHighBlsNoEntitledDays.setBlsRateHourly("12.54");
		mediumTierHighBlsNoEntitledDays.setTier("2");
		mediumTierHighBlsNoEntitledDays.setPayment("1363.73");
		mediumTierHighBlsNoEntitledDays.setStipendStartDate(new Date());
		mediumTierHighBlsNoEntitledDays.setTierHours("108.75");
		 */
		
		calendar.setTime( paymentDate );
		
		applicationApproval_1stDaySameMonth = new InitialPayment(workItem, highTierlowBlsHighEntitledDaysMar01, calendar);
		applicationApproval_priorMonth = new InitialPayment(workItem, highTierMedBlsLowEntitledDaysFeb15, calendar);
		applicationApproval_sameMonth = new InitialPayment(workItem, mediumTierMedBlsNoEntitledDaysMar20, calendar);
		applicationApproval_2MonthsBack = new InitialPayment(workItem, lowTierMedBlsMediumEntitledDaysJan15, calendar);
		
		addressChange_DecrPay = new AddressChange(workItem, highTierlowBlsHighEntitledDaysMar01, highTierMedBlsLowEntitledDaysFeb15, calendar);
		addressChange_IncrPay = new AddressChange(workItem, highTierMedBlsLowEntitledDaysFeb15, highTierlowBlsHighEntitledDaysMar01, calendar);
		
		tierChange_DecrPay = new TierChange(workItem, lowTierMedBlsLowEntitledDaysApr05, mediumTierMedBlsLowEntitledDaysFeb15, calendar);
		tierChange_DecrPay2 = new TierChange(workItem, lowTierMedBlsLowEntitledDaysFeb15, highTierMedBlsMediumEntitledDaysJan15, calendar);
		
		tierChange_IncrPay = new TierChange(workItem, mediumTierMedBlsNoEntitledDaysMar20, lowTierMedBlsMediumEntitledDaysJan15, calendar);
		tierChange_IncrPay2 = new TierChange(workItem, highTierMedBlsLowEntitledDaysApr05, mediumTierMedBlsLowEntitledDaysFeb15, calendar);
		
		revocation_MediumEntitledDays = new FinalPayment(workItem, lowTierMedBlsMediumEntitledDaysJan15, calendar);
		
		reinstatement = new Reinstatement(workItem, highTierlowBlsHighEntitledDaysMar01, calendar);
		
		
		
		if ( debugEnabled ) {
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& application-Approval &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(applicationApproval_sameMonth.toString());
			
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& application-Approval &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(applicationApproval_priorMonth.toString());
			
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& application-Approval &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(applicationApproval_1stDaySameMonth.toString());
			
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& application-Approval &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(applicationApproval_2MonthsBack.toString());
			
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& address-Change-Decreased-Pay &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(addressChange_DecrPay.toString());
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& address-Change-Increased-Pay &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(addressChange_IncrPay.toString());
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& tier-Change-Decreased-Pay &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(tierChange_DecrPay.toString());
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& tier-Change-Decreased-Pay2 &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(tierChange_DecrPay2.toString());
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& tier-Change-Increased-Pay &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(tierChange_IncrPay.toString());
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& revocation-Medium-Entitled-Days &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(revocation_MediumEntitledDays.toString());
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& Reinstatement &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			System.out.println(reinstatement.toString());
		}
	}
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}
}
