<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>


	<portlet:actionURL var="new1010">
		<portlet:param name="javax.portlet.action" value="doAction"/>
		<portlet:param name="action" value="loadApplication"/>
		<portlet:param name="context" value="onlineQuestionaire"/>
	</portlet:actionURL>

   <form id="<portlet:namespace/>onlineQue_fm" action="${new1010}" method="post" >
	
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="boxGrp_" value="${form_['boxGrp_']}" />
	<c:set var="bgAsn_" value="${form_['bgAsn_']}" />
	      
<div class="outer-pane">
   	<div class="outer-pane-note"><h4><liferay-ui:message key="online-questionaire-header" /></h4></div>

	<div class="online-questionaire">
		<div class="questionaire-completion"><liferay-ui:message key="completed-by-veteran" /></div>
		<hr>
		<br class="clear-both" />
		
		<div class="questionaire-table">
			<table>
				<tr class="is-veteran-in-military">
					<td class="online-question"><liferay-ui:message key="is-veteran-in-military" /></td>
					<c:forEach var="boxGrp" items="${boxGrp_['is-veteran-in-military']}" >
						<td class="online-answer">
							<aui:input label="${boxGrp.label}" cssClass="online-radio" name="${boxGrp.boxSubGroup}" 
								type="radio" value="${boxGrp.primaryKey}" checked="${bgAsn_[boxGrp.primaryKey]}"  />
						</td>
					</c:forEach>
				</tr>
				<tr class="military-discharged-date">
					<td class="online-question"><liferay-ui:message key="military-discharged-date" /></td>
				
					<c:forEach var="boxGrp" items="${boxGrp_['military-discharged-date']}" begin="0" varStatus="ndx">
						<td class="online-answer">
							<aui:input label="${boxGrp.label}" cssClass="need${ndx.count-1} online-radio" name="${boxGrp.boxSubGroup}" 
								type="radio" value="${boxGrp.primaryKey}" checked="${bgAsn_[boxGrp.primaryKey]}" id="discharge${ndx.count-1}"  />
						</td>
					</c:forEach>				
				</tr>
				
				<tr class="enrolled-in-va-health">
					<td class="online-question"><liferay-ui:message key="enrolled-in-va-health" /></td>
					<c:forEach var="boxGrp" items="${boxGrp_['enrolled-in-va-health']}">
						<td class="online-answer">
							<aui:input label="${boxGrp.label}" cssClass="online-radio" name="${boxGrp.boxSubGroup}" 
								type="radio" value="${boxGrp.primaryKey}" checked="${bgAsn_[boxGrp.primaryKey]}"  />
						</td>
					</c:forEach>
				</tr>
				
				<tr class="needs-assistance-basic-functions">
					<td class="online-question"><liferay-ui:message key="needs-assistance-basic-functions" />
					<c:forEach var="boxGrp" items="${boxGrp_['needs-assistance-basic-functions']}" begin="0" varStatus="ndx">
						<td class="online-answer">
							<aui:input label="${boxGrp.label}" cssClass="need${ndx.count-1} online-radio" name="${boxGrp.boxSubGroup}" 
								type="radio" value="${boxGrp.primaryKey}" checked="${bgAsn_[boxGrp.primaryKey]}" id="post91${ndx.count-1}"  />
						</td>
					</c:forEach>					
				</tr>
			</table>
		</div>
	</div>
</div>
   </form>
   
<div class="reset-wrapper" >
	<button id="clearRadio" class="btn btn-primary"><liferay-ui:message key="reset-selections" /></button>
</div>
   
   <div class="veteran-msg">
	   <div id="caretIneligible" class="portlet-msg-alert hidden-msg">
	   		<liferay-ui:message key="caret-ineligible" />
		</div> 	
		
		<div id="caretCheckEligible" class="portlet-msg-info hidden-msg">
			<liferay-ui:message key="caret-check-eligible" />
		</div> 
		
		<div id="caretEligible" class="portlet-msg-success hidden-msg">
			<liferay-ui:message key="caret-eligible" />			
		</div> 	
   </div>
	  

	   
<aui:script use="aui-io-request,aui-parse-content">

	A.one('#clearRadio').on('click', function(){
		A.all('input:radio').attr('checked',false);
		if ( ! A.one ('#caretIneligible').hasClass('hidden-msg') ){
			A.one ('#caretIneligible').addClass('hidden-msg');
		}
		if ( ! A.one ('#caretCheckEligible').hasClass('hidden-msg') ){
			A.one ('#caretCheckEligible').addClass('hidden-msg');
		}
		if ( ! A.one ('#caretEligible').hasClass('hidden-msg') ){
			A.one ('#caretEligible').addClass('hidden-msg');
		}
		
		window.caretIo( '${caretResourceURL}', 'json', 
				  { action: 'clearAnswer' },
				  function( data ){
					  if ( data.form_ == 'true' ){
			 		  		//console.log( 'saved' );
			 		  	} else {
							alert( 'Could not save' );
			 		  	}
					} 
				);
	});

	function configUI(){
		if ( A.all('.need1:input:checked').size() > 0  ) {
			if ( A.one('#<portlet:namespace/>post911').attr('checked') ){
				if ( ! A.one ('#caretEligible').hasClass('hidden-msg') ){
					A.one ('#caretEligible').addClass('hidden-msg');
				}
				if ( A.one ('#caretIneligible').hasClass('hidden-msg') ){
					A.one ('#caretIneligible').removeClass('hidden-msg');
				}
				if ( ! A.one ('#caretCheckEligible').hasClass('hidden-msg') ){
					A.one ('#caretCheckEligible').addClass('hidden-msg');
				}
			} else if ( A.one('#<portlet:namespace/>discharge1').attr('checked') ) {
				if ( ! A.one ('#caretEligible').hasClass('hidden-msg') ){
					A.one ('#caretEligible').addClass('hidden-msg');
				}
				if ( ! A.one ('#caretIneligible').hasClass('hidden-msg') ){
					A.one ('#caretIneligible').addClass('hidden-msg');
				}
				if ( A.one ('#caretCheckEligible').hasClass('hidden-msg') ){
					A.one ('#caretCheckEligible').removeClass('hidden-msg');
				}
			}
		} else {
			if ( ! A.one ('#caretIneligible').hasClass('hidden-msg') ){
				A.one ('#caretIneligible').addClass('hidden-msg');
			}
			if ( ! A.one ('#caretCheckEligible').hasClass('hidden-msg') ){
				A.one ('#caretCheckEligible').addClass('hidden-msg');
			}
			if ( A.all('.questionaire-table input:checked').size() == 4 ){
				if ( A.one ('#caretEligible').hasClass('hidden-msg') ){
					A.one ('#caretEligible').removeClass('hidden-msg');
				}
			}
		}
	}
	configUI();
	
	A.all('.questionaire-table input').on ( 'click', function (e) {
		 configUI();
		
		 window.caretIo( '${caretResourceURL}', 'json', 
				  { 
				  	action: 'saveAnswer',
			 		subgroup_: e.currentTarget.ancestor('tr').attr('class'),
			 		boxGrpId: e.currentTarget.val()
			 	  },
				  function( data ){
			 		  	if ( data.form_ == 'true' ){
			 		  		//console.log( 'saved' );
			 		  	} else {
							alert( 'Could not save' );
			 		  	}
					} 
				);
		
	});
	
	  A.one('.applyNow').on('click', function(){
					
			/**
			var node = A.one('#<portlet:namespace/>1010cg');
			if ( node.html() == "" ) {
				window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="load1010cg" /></portlet:resourceURL>', 'html', 
					'<portlet:namespace/>onlineQue_fm',
					function( data ){
						console.log('it loaded... ' );
						node.plug( A.Plugin.ParseContent );
						node.setContent( data );
					} 
				);
				console.log (  node.html() == "" );
			}
	    	window.careTmainTab.selectChild(3);
	    	**/
	    	
		  document.forms["<portlet:namespace/>onlineQue_fm"].submit();
		});
	  
  
</aui:script>	

