<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>


<%@ taglib uri="http://liferay.com/tld/ui" prefix="liferay-ui" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ include file="/jsp/init.jsp" %>	


<style>
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.section{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
	.manage-layout-td text{
		/* width: 840px; */
		width: 67px;
		padding-left: 10px;
	}
	.manage-layout-td textarea{
		/* width: 840px; */
		width: 767px;
		padding-left: 10px;
	}

	.messageicon{
	margin-left:50px;font-size: 15px; font-weight:100; float:center;
	}

	.assessment-history-all{
		float:right;
		margin:10px;
	}
	.section-link{
		float:right;
		margin:10px;
	}
	
</style>	

 <c:if test="${!empty form_['allLetters']}">
	<div class="summaryTable">
		<table style="width:150%">
			<tr>
			  <th>File Name</th> 
			  <th>From</th> 
			  <th>Sent Date</th> 
			  <th>Action</th>			  
			</tr>
		 <c:forEach var="doc" items="${form_['allLetters']}">
		 <c:set var="docInfo" value="${fn:split(doc.note, ',')}" />
		 <tr>
			 <td>${doc.name}</td>
			 <td>${docInfo[1]}</td>
			 <td>${docInfo[0]}</td>
			 <td>
			 	 <portlet:resourceURL var="getDocum">
                       <portlet:param name="action" value="getDocum"/>
                       <portlet:param name="documId" value="${doc.documId}"/>
                 </portlet:resourceURL>
                 <div class="poa-docum manage-layout" >
                       <a href="${getDocum}" target="_blank" >View</a>
                 </div>
			 </td>
         </tr>           
        </c:forEach>
		</table>
	</div>
</c:if>
<aui:script use="aui-io-request,aui-parse-content,aui-modal">
 
	/*
	window.saveLetter = function() {
		var data = CKEDITOR.instances.editor1.getData();
		A.one('#<portlet:namespace/>letterContent').val(data);	
		A.one("#<portlet:namespace/>saveLetter").submit();
		window.caretIo( '<portlet:actionURL><portlet:param name="action" value="saveLetter" /></portlet:actionURL>', 'json',
				{ 	
					letterContent:  CKEDITOR.instances.editor1.getData()
			  	},
				function( data ) {
					  alert("Success");
				} 
		);
	}*/
	
   </aui:script>