<%@ include file="/jsp/init.jsp" %>

<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['viewMember']}">

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="queueName" value="${SEARCH_CONTAINER_RESULT_ROW.object['queueName']}" />
<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['type']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['worImId']}" />
<c:set var="ownerId" value="${SEARCH_CONTAINER_RESULT_ROW.object['userId'] eq 0 }" />
<c:set var="mine" value="${SEARCH_CONTAINER_RESULT_ROW.object['userId'] eq user.userId}" />
<c:set var="complete" value="${SEARCH_CONTAINER_RESULT_ROW.object['complete'] }" />
<c:set var="workItem" value="${SEARCH_CONTAINER_RESULT_ROW.object['this'] }" />
<c:set var="primaryKey" value="${SEARCH_CONTAINER_RESULT_ROW.object['classPk']}" />
<c:set var="veteranId" value="${SEARCH_CONTAINER_RESULT_ROW.object['persnId']}" />
<c:set var="context" value="${caretMap_['context'] }" />

<c:set var="isReferral" value="${fn:contains(type, 'REFERRAL')}" />

<liferay-ui:icon-menu>
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${worImId});" />

<c:if test="${ workItem.canAssign(resourceRequest) }" >
<c:if test="${!complete }" >
<c:if test="${!mine}" >
  <portlet:actionURL var="takeOwnership">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
	<portlet:param name="context" value="${context}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="edit" message="take-ownership" url="javascript: window.escapePrevent(); window.location.assign('${takeOwnership}');"  />
</c:if>
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId},'${context}');" />
<c:if test="${!ownerId}" >
  <portlet:actionURL var="unassignTo">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="unassignTo"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="context" value="${caretMap_['context']}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="unassign_user" message="unassign-ownership" url="javascript: window.escapePrevent(); window.location.assign('${unassignTo}','${context}');" />
</c:if>
</c:if>
	<c:if test="${isReferral}">
			<portlet:actionURL var="openReferral">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="openReferral" />
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="callId" value="${primaryKey}"/>
				<portlet:param name="type" value="${type}"/>
			</portlet:actionURL>
			
			<portlet:actionURL var="createAppfromCall">
				<portlet:param name="javax.portlet.action" value="doAction"/>
				<portlet:param name="action" value="loadEntry"/>
				<portlet:param name="entry" value="CREATE_APPLICATIONS"/>
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="callId" value="${primaryKey}"/>
			</portlet:actionURL>
			
			<portlet:actionURL var="createReferralVcg">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="loadEntry"/>
				<portlet:param name="entry" value="CREATE_VCG"/>
				<portlet:param name="veteranId" value="${veteranId}"/>
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="associate" value="true"/>
			</portlet:actionURL>

			<liferay-ui:icon image="preview" message="view-referral" url="${openReferral}" />
			<liferay-ui:icon image="add" message="start-application" cssClass="edit-page" url="${createAppfromCall}" />
<!-- 
			<liferay-ui:icon image="close" message="mark-closed-completed" url="javascript:markClosed(${worImId});" />
 -->
			<liferay-ui:icon image="message" message="internal_message" url="javascript:composeReferral(${worImId},${primaryKey},'${type}');"  />
			<c:choose>
				<c:when test="${vcgId gt 0}" >
					<liferay-ui:icon image="group" message="manage-vcg" cssClass="edit-page" url="${loadVcgManagement}" />
					<liferay-ui:icon image="all_pages" message="send-letter" url="${initiateLetter}" />
				</c:when>
				<c:otherwise>
					<liferay-ui:icon image="view" message="assign-to-vcg" cssClass="edit-page" url="${createReferralVcg}" />
				</c:otherwise>
			</c:choose>
		</c:if>


</c:if>
	<c:if test="${workItem.canReview(resourceRequest,permissionChecker,scopeGroupId)}" >
		<liferay-ui:icon image="reply" message="review-work"  url="javascript:manageOccWork(${worImId}, \"${type}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['personName']}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['caregiverName']}\", \"${context}\");"  />
	</c:if>
	<c:if test="${workItem.canReviewDelay(resourceRequest,permissionChecker,scopeGroupId)}">
		<c:set var="isMyApp" value="${SEARCH_CONTAINER_RESULT_ROW.object['createId'] eq user.userId}" />
		<liferay-ui:icon image="manage_task" message="review-app-delay" url="javascript:reviewAppDelay(${worImId},'${context}', ${isMyApp});" />
	</c:if>
	<c:if test="${workItem.canTransfer(permissionChecker,scopeGroupId)}" >
		<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId},'${context}');"  />
	</c:if>
	<c:if test="${workItem.canCscCorrect(permissionChecker,scopeGroupId)}" >
		<liferay-ui:icon image="checked" message="corrective-action-completed" url="javascript:markCorrected(${worImId},'${context}');" />
	</c:if>
	

	
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['vcgId'] gt 0 && 'manageVcg' ne caretMap_['context'] }" >
		<portlet:actionURL var="loadVcgManagement">
			<portlet:param name="javax.portlet.action" value="doAction" />
			<portlet:param name="action" value="loadEntry"/>
			<portlet:param name="entry" value="MANAGE_VCG"/>
			<portlet:param name="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['vcgId']}"/>
		</portlet:actionURL>
		<liferay-ui:icon image="group" message="manage-vcg" url="${loadVcgManagement}"  />
	</c:if>
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['docLoaded']}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="classPk" value="${SEARCH_CONTAINER_RESULT_ROW.object['classPk']}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>

	<liferay-ui:icon image="add" message="new-note" url="javascript:newWorkNote(${worImId},'${context}' );" />

</liferay-ui:icon-menu>

</c:if>



