
<%@ include file="/jsp/init.jsp" %>	

<c:set var="form_" value="${caretMap_['form_']}" />

<c:set var="calcInfo" value="${workItem.calcInfo}" />
<c:set var="caregiver" value="${workItem.caregiver}" />
<c:set var="vcgSupport" value="${workItem.vcgSupport}" />
<c:set var="stipendPaymentConfig" value="${calcInfo.stipendPaymentConfig}" /> 

<div id="${randomStr}workTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-b11${randomStr}"><div class="icon-bullhorn"></div> View </a></li>
    <li class="tab-click" ><a href="#tab-b12${randomStr}"><div class="icon-credit"></div> Calculations </a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-b11${randomStr}" class="tab-pane">
		
		
		<div id="reviewOccWork2">
			<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
			<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
			<div class='portlet-msg-info' style="width:80%">(TBD) Top things to Highlight here...
				<div class="ten-ten-links" >
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="classPk" value="${workItem.classPk}"/>
					</portlet:resourceURL>
			  		<a href="${getDocum}" tabindex="0"  target="_blank" class="tab-click btn icon-file stipend-row float-right" title='<liferay-ui:message key="pdf-10-10cg" />' >&nbsp;<liferay-ui:message key="pdf-10-10cg-review-message" /></a>
		  		</div>
		  	
		  
			  <ul>
				<fmt:formatDate value="${vcgSupport.primaryRevocationDate}" var="revocationDate" type="date" pattern="MM/dd/yyyy"/>
				<fmt:formatDate value="${vcgSupport.primaryDispositionDate}" var="dispositionDate" type="date" pattern="MM/dd/yyyy"/>
				<fmt:formatDate value="${stipendPaymentConfig.stipendStartDate}" var="stipendStartDate" type="date" pattern="MM/dd/yyyy"/>
				<fmt:formatDate value="${stipendPaymentConfig.payslipDate}" var="payslipDate" type="date" pattern="MM/dd/yyyy"/>

					<li><liferay-ui:message key='cg-vendor' /> Name: ${caregiver.lastName}, ${caregiver.firstName} ${caregiver.middleName} &nbsp;</li>
					<li>SSN: ${caregiver.ssn} </li>
					<li><liferay-ui:message key='cg-vendor' /> Address:${caregiver.address} ${caregiver.address2}
					  <div style="margin-left:100px;" >
						<c:choose>
							<c:when test="${caregiver.validUspsAddress}">
								<span class="icon-star has-tooltip" title="<liferay-ui:message key='usps-validated'/>" >&nbsp;</span>
							</c:when>
							<c:otherwise>
								<span class="icon-flag" title="<liferay-ui:message key='non-usps-validated'/>" >&nbsp;</span>
							</c:otherwise>
						</c:choose>
							${caregiver.city}, ${caregiver.state} ${caregiver.zip}
					  </div>
					 </li>
					
					<c:if test="${workItem.workType.canManualWork()}">
						${workItem.manualInfo}
					</c:if>
					
					
					<c:if test="${form_['isViewMode']}">
						<li> Status: <liferay-ui:message key='${workItem.status}'/>
						</li>
					</c:if>
					
			  </ul>
			</div><!-- end Top things to Highlight here... -->
			

		
			<div id="reviewMyWork">
			  	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
					<a class="btn" style="float:right; margin-left:30px; margin-bottom:-10px " href="javascript:manageOccWorkHide();" >&nbsp;<liferay-ui:message key="close" /></a>      			
				</aui:field-wrapper>
			</div>
			
		</div><!-- end reviewOccWork2 -->
    </div> <!-- end tab-11 -->
	
	<div id="tab-b12${randomStr}" class="tab-pane">
	  
	  
	  <c:choose>
    	<c:when test="${workItem.type eq 'MANUAL_PAYMENT'}" >
			<div class="work-section manage-layout">
				<div class="center-position">
					<div id="tier-info">
						<div class="selected-vcg">
							<div class="selected-info">
								<fmt:formatDate value="${vcgSupport.tierEffectiveDate}"
									var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy" />
								<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate"
									type="date" pattern="MM/dd/yyyy" />

								<div class="selected-vcg-row">
									<div class="srow-label">Tier Level:</div>
									<liferay-ui:message
										key="tier-level-${vcgSupport.tierLevel}" />
								</div>
								<div class="my-shim"></div>
								<div class="selected-vcg-row">
									<div class="srow-label">Stipend Start Date:</div>${stipendStartDate}
								</div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Initial Payment Date:</div>${payslipDate}
				    			</div>
								<div class="selected-vcg-row">
									<div class="srow-label">Payment Status:</div><liferay-ui:message key="${stipendPaymentConfig.stipendStatus}" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<div class="work-section">
				<div class="center-position">
					<div class="rate-info" >
						<div class="selected-vcg">
							<div class="selected-info">
								<div class="selected-vcg-row">
									<div class="srow-label">Zip:</div>${caregiver.zip}
									&nbsp;
								</div>
								<div class="selected-vcg-row has-tooltip"
									id="${randomStr}itemization0" title="click-for-itemization">
									<div class="header toggler-header-expanded">
										<c:choose>
											<c:when test="${stipendPaymentConfig.stipendType eq 'one-time'}">
												<div class="srow-label">One Time Payment:</div>
												<div class="float-left">
													<fmt:formatNumber value="${stipendPaymentConfig.oneTimePayment}"
														type="currency" />
													&nbsp;
												</div>
												<div class="icon-info-sign "></div>
												&nbsp;
											</c:when>
											<c:otherwise>
												<div class="srow-label">Monthly Rate:</div>
												<div class="float-left">
													<fmt:formatNumber value="${calcInfo.monthlyRate}"
														type="currency" />
													&nbsp;
												</div>
												<div class="icon-info-sign "></div>
												&nbsp;
											</c:otherwise>
										</c:choose>
									</div>
									<div class="content toggler-content-expanded portlet-msg-info">
										<c:choose>
											<c:when test="${stipendPaymentConfig.stipendType eq 'one-time' and stipendPaymentConfig.payment eq '0' }">
												No calculations available.
											</c:when>
											<c:otherwise>
												<table class="itemized-table">
													<tr>
														<th>[Monthly Rate] =</th>
														<th>[Tier Monthly Hrs] x</th>
														<th>[ZIP Hourly Wage]</th>
													</tr>
													<tr>
														<td>$${calcInfo.monthlyRate}</td>
														<td>${stipendPaymentConfig.tierHours}</td>
														<td>$${calcInfo.hourlyRate}</td>
													</tr>
												</table>
												<table class="itemized-table">
													<tr>
														<th>[Daily Rate] =</th>
														<th>[Tier Monthly Hrs] &times;</th>
														<th>[ZIP Hourly Wage] &times;</th>
														<th class="itemized-fract"><sup>12</sup>&frasl;<sub>365</sub>
														</th>
													</tr>
													<tr>
														<td>$${calcInfo.dailyRate}</td>
														<td>${stipendPaymentConfig.tierHours}</td>
														<td>$${calcInfo.hourlyRate}</td>
														<td class="itemized-fract"><sup>12</sup>&frasl;<sub>365</sub></td>
													</tr>
												</table>
											</c:otherwise>
										</c:choose>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

<aui:script use="aui-toggler">
				new A.TogglerDelegate( {
				animated: true,
				container: '#${randomStr}itemization0' ,
				content: '.content',
				expanded: true,
				header: '.header'
			  });
</aui:script>

		</c:when>
    	<c:otherwise>
			
			
			<div class="work-section manage-layout" >
				<div class="center-position">
					<div id="tier-info">
						<div class="selected-vcg">
				    		<div class="selected-info">
				    			<fmt:formatDate value="${vcgSupport.tierEffectiveDate}" var="tierEffectiveDate" type="date" pattern="MM/dd/yyyy"/>
				    			<fmt:formatDate value="${payLog.paymentDate}" var="paymentDate" type="date" pattern="MM/dd/yyyy"/>
				    		 
				    			<div class="selected-vcg-row">
				    	 			<div class="srow-label">Tier Level:</div><liferay-ui:message key="tier-level-${vcgSupport.tierLevel}" />
				    			</div>
			    				<div class="my-shim"></div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Stipend Start Date:</div>${stipendStartDate}
				    			</div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Initial Payment Date:</div>${payslipDate}
				    			</div>
				    		  <c:if test="${! empty payLog}">
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">Check Submit Date:</div>${paymentDate}
				    			</div>
				    			<div class="my-shim"></div>
				    			<div class="selected-vcg-row">
				    				<div class="srow-label">FMS Payment Response:</div><fmt:formatNumber value="${payLog.amount}" type="currency"/>, <liferay-ui:message key='${payLog.reason}' />
				    			</div>
				    		  </c:if>
				    		</div>
				    	</div>
					</div>
				</div>
			</div>
			<div class="work-section" >	
				<div class="center-position">
					<div class="rate-info" >
						<div class="selected-vcg">
				    	 	<div class="selected-info">
				    	 		<div class="selected-vcg-row">
					    	 		<div class="srow-label">Zip:</div>${caregiver.zip} &nbsp;
					    	 	</div>
								<div class="selected-vcg-row has-tooltip" id="${randomStr}itemization1" title="click-for-itemization" >
									<div class="header toggler-header-expanded" >
										<div class="srow-label" >Monthly Rate: </div>
										<div class="float-left" ><fmt:formatNumber value="${calcInfo.monthlyRate}" type="currency"/>&nbsp; </div>
										<div class="icon-info-sign "></div> &nbsp;
									</div>
									<div class="content toggler-content-expanded portlet-msg-info"  >
										<table class="itemized-table">
											<tr><th>[Monthly Rate] =</th>      <th>[Tier Monthly Hrs] x </th>  <th>[ZIP Hourly Wage]</th></tr>
											<tr><td>$${calcInfo.monthlyRate}</td><td>${stipendPaymentConfig.tierHours} </td>				  <td> $${calcInfo.hourlyRate}</td></tr>
										</table>
										<table class="itemized-table">
											<tr><th>[Daily Rate] =</th>      <th>[Tier Monthly Hrs] &times; </th>  <th>[ZIP Hourly Wage] &times;</th><th class="itemized-fract">  <sup>12</sup>&frasl;<sub>365</sub> </th></tr>
											<tr><td>$${calcInfo.dailyRate}</td><td>${stipendPaymentConfig.tierHours} </td><td> $${calcInfo.hourlyRate}</td><td class="itemized-fract"><sup>12</sup>&frasl;<sub>365</sub></td></tr>
										</table>
									</div>
								</div>
									
								<c:if test="${! empty payLog}">
									<div class="selected-vcg-row has-tooltip" id="${randomStr}itemization2" title="click-for-itemization-of-retroactive-and-or-prorated" >
										<div class="header toggler-header-collapsed" >
											<div class="srow-label" >Back Pay: </div>
											<div class="float-left" >${(calcInfo.backPayAmount + calcInfo.proratedAmount)  gt 0 ? "YES": "NO"} &nbsp; </div>
											<div class="icon-info-sign "></div> &nbsp;
										</div>
										<div class="content toggler-content-expanded"  >
											<div class="portlet-msg-info">
												<div class="itemized-data" >[# of Retro Months] = Number of Unpaid Full months after Tier Effective date(${tierEffectiveDate}) prior to Payment Month (${payLog.paymentMonth})
												</div>
												<table class="itemized-table">
													<tr><th>[Monthly Back Pay] =</th>      <th>[Monthly Rate] x </th>  <th>[# of Retro Months]</th></tr>
													<tr><td><fmt:formatNumber value="${calcInfo.backPayAmount}" type="currency"/></td><td>$${calcInfo.monthlyRate} </td><td> ${calcInfo.retroactiveMonths}</td></tr>
												</table>
												<div class="itemized-data" >[# of Retro Days] = Number of Partial-month days after Tier Effective date(${tierEffectiveDate}) prior to Payment Month (${payLog.paymentMonth})
												</div>
												<table class="itemized-table">
													<tr><th>[Prorated Amt] =</th>      <th>[Daily Rate] x </th>  <th>[# of Retro Days]</th></tr>
													<tr><td><fmt:formatNumber value="${calcInfo.proratedAmount}" type="currency"/></td><td><fmt:formatNumber value="${calcInfo.dailyRate}" type="currency"/> </td><td> ${calcInfo.totalDays}</td></tr>
												</table>
												<table class="itemized-table">
													<tr><th>[Back Pay] =</th>      <th>[Monthly Back Pay] + </th>  <th>[Prorated Amt]</th></tr>
													<tr><td><fmt:formatNumber value="${calcInfo.backPayAmount + calcInfo.proratedAmount}" type="currency"/></td><td><fmt:formatNumber value="${calcInfo.backPayAmount}" type="currency"/></td><td> <fmt:formatNumber value="${calcInfo.proratedAmount}" type="currency"/></td></tr>
												</table>
											</div>
										</div>
									</div>
						    		<div class="selected-vcg-row">
						    			<div class="srow-label">Back Pay Amount: </div><fmt:formatNumber value="${calcInfo.backPayAmount + calcInfo.proratedAmount}" type="currency"/>&nbsp;
						    		</div>
		
					    			<div class="selected-vcg-row">
					    	 			<div class="srow-label">Total Payment Amount:</div><fmt:formatNumber value="${calcInfo.finalAmount}" type="currency"/> &nbsp;
					    			</div>
								</c:if>	
					    	</div>
				    	</div>
					</div>
				</div>
			</div>
			
<aui:script use="aui-toggler">
	  new A.TogglerDelegate( {
				container: '#${randomStr}itemization1',
				animated: true,
				content: '.content',
				expanded: true,
				header: '.header'
			  });
	
</aui:script>	
	
	
    	</c:otherwise>
      </c:choose>
	</div>
    
	
  </div><!-- end tab-context -->
</div><!-- workTab -->

	
<aui:script use="aui-tabview">

  new A.TabView({
      srcNode: '#${randomStr}workTab',
      type: 'pills'
    }
  ).render();
  

	
</aui:script>

		