
<%@include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<portlet:actionURL var="selectRole">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="selectRole"/>
</portlet:actionURL>


<aui:form action="${selectRole}" method="post" name="sign_fm" >
	<h3><liferay-ui:message key='please-review-below-info-for-participation' /></h3>
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<div class="reset-wrapper" >
	
		
	
	</div>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout required-input"   >
		<aui:select inlineField="true" label="roles" name="role" id="role" >
			<aui:option value="" label="select-role" />
			<c:forEach var="role" items="${roleChooser}">
			  <c:choose>
				<c:when test="${fn:startsWith(role.name, 'VISN')}" >
					<c:set var="roleClass" value="visns" />
				</c:when>
				<c:when test="${fn:startsWith(role.name, 'CSC')}" >
					<c:set var="roleClass" value="facility" />
				</c:when>
				<c:otherwise>
					<c:set var="roleClass" value="none" />
				</c:otherwise>
			  </c:choose>
			  <aui:option value="${role.roleId}" label="${role.name}" cssClass="${roleClass}" />
			</c:forEach>
		</aui:select>
	</aui:field-wrapper>


	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout manage-layout-wide-input"   >
		<aui:select label="select-facility" cssClass="preferred-facility" name="facility" id="facility" >
			<aui:option value="-1" label="select-facility" selected="true"/>
			<c:forEach var="district" items="${faciltyChooser}">
				<aui:option value="${district.key}" label="${district.key}" cssClass="district" disabled="true" selected="false" />
				<c:forEach var="visn" items="${district.value}">
					<aui:option value="${visn.key}" label="${visn.key}" cssClass="visn" disabled="true" selected="false"/>
					<c:forEach var="facility" items="${visn.value}">
						<aui:option value="${facility.value}" label="${facility.key}" cssClass="facility" selected="${facility.value eq person.groupId}" />
					</c:forEach>
				</c:forEach>
			</c:forEach>
		</aui:select>
	</aui:field-wrapper>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout"   >
		<aui:select label="select-visn" name="visn" id="visns" >
			<aui:option value="-1" label="select-visn" selected="true"/>
			<c:forEach var="visn" items="${visnChooser}">
				<aui:option value="${visn.value}" label="${visn.key}" />
			</c:forEach>
		</aui:select>
	</aui:field-wrapper>

	
	<div class="my-shim"></div>
	
	<div class="reset-wrapper" >
		<input type="submit" class="btn btn-primary" id="submitRole" value='Proceed to CareT' />
	</div>
</aui:form>


<aui:script use="node">

  
  
   var requireField = function( node ){
		if (node && !node.hasClass('required-input') ){
             node.addClass( 'required-input' );
        }
        node.show();
        node.attr('disabled', '');
	}
	
	var unrequireField = function( node ){
		if (node && node.hasClass('required-input') ){
             node.removeClass( 'required-input' );
        }
        node.hide();
        node.attr('disabled', 'true');
	}
  
  A.one('#<portlet:namespace/>role').on( 
				      'change',
				      function( event ) {
				      	
				      		var node = A.one(event.currentTarget);
				      		node = A.one(node.attr('options')._nodes[node.attr('selectedIndex')]);
				    	  	if ( node.hasClass('none') ){
				    	  		unrequireField ( A.one('#<portlet:namespace/>facility').ancestor('.field-wrapper') );
				    	  		unrequireField ( A.one('#<portlet:namespace/>visns').ancestor('.field-wrapper') );
				    	  	} else if ( node.hasClass('visns') ){ 
				    	  		unrequireField ( A.one('#<portlet:namespace/>facility').ancestor('.field-wrapper') );
				    	  		requireField ( A.one('#<portlet:namespace/>visns').ancestor('.field-wrapper') );
				    	  	} else if ( node.hasClass('facility') ){ 
				    	  		requireField ( A.one('#<portlet:namespace/>facility').ancestor('.field-wrapper') );
				    	  		unrequireField ( A.one('#<portlet:namespace/>visns').ancestor('.field-wrapper') );
				    	  	}
				     }
				 );
	unrequireField( A.one('#<portlet:namespace/>visns').ancestor('.field-wrapper') );
	unrequireField( A.one('#<portlet:namespace/>facility').ancestor('.field-wrapper') );  
  
</aui:script>
