<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="mine" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx13'] eq user.screenName}" />
<c:set var="ownerId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx13'] eq null || empty SEARCH_CONTAINER_RESULT_ROW.object['ndx13'] }" />
<c:set var="documId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx12']}" />
<c:set var="isDelayReviewed" value="${fn:contains(type, 'DELAY_REVIEWED')}" />


<liferay-ui:icon-menu>

<c:if test="${!mine}" >
  <portlet:actionURL var="takeOwnership">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="edit" message="take-ownership" url="${takeOwnership}" />
</c:if>
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId});" />
<c:if test="${!ownerId}" >
  <portlet:actionURL var="unassignTo">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="unassignTo"/>
	<portlet:param name="worImId" value="${worImId}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="unassign_user" message="unassign-ownership" url="${unassignTo}" />
</c:if>
		
	<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']});" cssClass="update-pii" />
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']});" />
	
	<c:if test="${documId gt 0}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="documId" value="${documId}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	<liferay-ui:icon image="add" message="application-note" url="javascript:newWorkNote(${worImId},'', '${vcgId}' );" />
	<c:if test="${isDelayReviewed}" >
		<liferay-ui:icon image="checked" message="mark-closed-completed" url="javascript:markClosed(${worImId});" />
	</c:if>
	
	
</liferay-ui:icon-menu>