<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="primaryKey" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx10']}" />
<c:set var="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx11']}" />
<c:set var="veteranId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx15']}" />
<c:set var="isMyApp" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx20'] eq user.userId}" />


<portlet:actionURL var="loadProcessApplication">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadProcessApplication" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="primaryKey" value="${primaryKey}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>

<portlet:actionURL var="loadVcgManagement">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="MANAGE_VCG"/>
	<portlet:param name="vcgId" value="${vcgId}"/>
</portlet:actionURL>

<c:set var="isReferral" value="${fn:contains(type, 'REFERRAL')}" />
<c:set var="isAppDelay" value="${fn:contains(type, 'APP_DELAY')}" />
<c:set var="isDelayReviewed" value="${fn:contains(type, 'DELAY_REVIEWED')}" />

<liferay-ui:icon-menu>

<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId});" />
<portlet:actionURL var="unassignTo">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="unassignTo"/>
	<portlet:param name="worImId" value="${worImId}"/>
</portlet:actionURL>
<liferay-ui:icon image="unassign_user" message="unassign-ownership" url="${unassignTo}" />

	<portlet:actionURL var="initiateLetter">
		<portlet:param name="javax.portlet.action" value="doAction" />
		<portlet:param name="action" value="initiateLetter"/>
		<portlet:param name="vcgId" value="${vcgId}"/>
		<portlet:param name="worImId" value="${worImId}"/>
		<portlet:param name="associate" value="true"/>
	</portlet:actionURL>
	<c:if test="${!isAppDelay}" >
		<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId});"  />
	</c:if>
	<c:if test="${isDelayReviewed}" >
		<liferay-ui:icon image="checked" message="mark-closed-completed" url="javascript:markClosed(${worImId});" />
	</c:if>
	<liferay-ui:icon image="time" cssClass="popup-searchcontainer" message="work-audit" url="javascript:auditLog(${worImId});" />
	<c:set var="documId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx12']}" />
	<c:if test="${documId gt 0}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="documId" value="${documId}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	<c:choose>
		<c:when test="${isReferral}">
			<portlet:actionURL var="openReferral">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="openReferral" />
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="callId" value="${primaryKey}"/>
				<portlet:param name="type" value="${type}"/>
			</portlet:actionURL>
			
			<portlet:actionURL var="createAppfromCall">
				<portlet:param name="javax.portlet.action" value="doAction"/>
				<portlet:param name="action" value="loadEntry"/>
				<portlet:param name="entry" value="CREATE_APPLICATIONS"/>
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="callId" value="${primaryKey}"/>
			</portlet:actionURL>
			
			<portlet:actionURL var="createReferralVcg">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="loadEntry"/>
				<portlet:param name="entry" value="CREATE_VCG"/>
				<portlet:param name="veteranId" value="${veteranId}"/>
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="associate" value="true"/>
			</portlet:actionURL>

			<liferay-ui:icon image="preview" message="view-referral" url="${openReferral}" />
			<liferay-ui:icon image="add" message="start-application" cssClass="edit-page" url="${createAppfromCall}" />
<!-- 
			<liferay-ui:icon image="close" message="mark-closed-completed" url="javascript:markClosed(${worImId});" />
 -->
			<liferay-ui:icon image="message" message="internal_message" url="javascript:composeReferral(${worImId},${primaryKey},'${type}');"  />
			<c:choose>
				<c:when test="${vcgId gt 0}" >
					<liferay-ui:icon image="group" message="manage-vcg" cssClass="edit-page" url="${loadVcgManagement}" />
					<liferay-ui:icon image="all_pages" message="send-letter" url="${initiateLetter}" />
				</c:when>
				<c:otherwise>
					<liferay-ui:icon image="view" message="assign-to-vcg" cssClass="edit-page" url="${createReferralVcg}" />
				</c:otherwise>
			</c:choose>
			
		</c:when>
		<c:otherwise>	
			<c:choose>
				<c:when test="${vcgId gt 0}">
					<c:if test="${isAppDelay}">
						<liferay-ui:icon image="manage_task" message="review-app-delay" url="javascript:reviewAppDelay(${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']},'', ${isMyApp} );" />
					</c:if>
			        <liferay-ui:icon image="group" message="manage-vcg" url="${loadVcgManagement}"/>
			        <liferay-ui:icon image="all_pages" message="letters" url="${initiateLetter}" />
					<liferay-ui:icon image="message" message="internal_message" url="javascript:composeVCG(${vcgId});"  />
			    </c:when>    
			    <c:otherwise>
			        <liferay-ui:icon image="submit" message="process-application" url="${loadProcessApplication}" />
					<liferay-ui:icon image="message" message="internal_message" url="javascript:composeApplication(${worImId},${primaryKey},'${type}');"  />
			    </c:otherwise>		
			</c:choose>
			<c:if test="${fn:endsWith(type, '_APP')}">
				<liferay-ui:icon image="add" message="application-note" url="javascript:newWorkNote(${worImId},true);" />
			</c:if>
		</c:otherwise>
	</c:choose>
</liferay-ui:icon-menu>